package org.ferris.journal.gui.view.textfield;

import java.awt.Color;
import java.util.List;

import javax.swing.JTextField;

import org.apache.commons.lang.StringUtils;
import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;

public abstract class KAbstractTextField extends JTextField
{
	private static final long serialVersionUID = 7199685263725412678L;
	private Color originalBackgroundColor;
	
	public KAbstractTextField() {
		super();
		originalBackgroundColor = getBackground();
	}
	
	public abstract Constraint<String> getConstraint(); 
	
	public abstract String getExplaination(Check check); 
	
	public KAbstractTextField validate(List<String> explainations) 
	{
		setBackground(originalBackgroundColor);
		
		setText(StringUtils.trimToEmpty(getText()));
	
		Check check 
			= getConstraint().check(getText());
		
		if (check != null) {
			setBackground(Color.red);
			explainations.add(getExplaination(check));
		}
		
		return this;
	}
	
	public Color getOriginalBackgroundColor() {
		return originalBackgroundColor;
	}
}
