package org.ferris.journal.gui.view.textfield;

import static org.ferris.journal.gui.i18n.i18n.getString;

import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;
import org.ferris.constraint.NotNull;
import org.ferris.constraint.StringLengthBetween;
import org.ferris.constraint.StringPattern;
import org.ferris.util.regex.EmailPattern;

public class KEmailTextField extends KAbstractTextField
{	
	private static final long serialVersionUID = -352120234314107743L;

	private Constraint<String> constraint;
	
	private int getMin() {
		return 0;
	}
	
	private int getMax() {
		return 50;
	}
	
	
	public KEmailTextField()  {
		super();
	}
	
	@Override
	public Constraint<String> getConstraint()
	{
		if (constraint == null) {
			constraint =
				new NotNull<String>
			(
				new StringLengthBetween
				(
					  getMin(),  false,	// min must be greater than ... 
					  getMax(), true,		// max must be less than or equal to ... 
					  new StringPattern
					  (
						 EmailPattern.PATTERN
					  )
				)
			);
		}
		return constraint;
	}

	@Override
	public String getExplaination(Check check)
	{
		if (check.equals(Check.IsNull)) {
			return getString("email.malformed.null");
		}
		else
		if (check.equals(Check.EqualToMin)) {
			return getString("email.malformed.tooshort");
		}
		else
		if (check.equals(Check.GreaterThan)) {
			return getString("email.malformed.toolong", getMax(), getText().length());
		}
		else
		if (check.equals(Check.NoMatch)) {
			return getString("email.malformed.wrongpattern");
		}
		else {
			throw new RuntimeException(
				getString("exception.check.not.recognized", check)
			);
		}
	}

}
