package org.ferris.journal.gui.view.editorpane;

import static org.ferris.journal.gui.i18n.i18n.getString;

import java.awt.Font;

import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;
import org.ferris.constraint.NotNull;
import org.ferris.constraint.StringLengthGreaterThan;

public class KEntryTextPane extends KAbstractTextPane 
{
	private static final long serialVersionUID = -3089172614698537757L;

	private Constraint<String> constraint;
	
	public KEntryTextPane() {
		super();
		setFont(new Font("verdana", Font.PLAIN, 12));
	}
	
	@Override
	public Constraint<String> getConstraint() 
	{
		if (constraint == null) {
			constraint 
				= new NotNull<String>(
					new StringLengthGreaterThan(0)
				);
		}
		return constraint;
	}

	@Override
	public String getExplaination(Check check) 
	{
		if (check.equals(Check.IsNull)) {
			return getString("entry.text.malformed.null");
		}
		else
		if (check.equals(Check.EqualToMin)) {
			return getString("entry.text.malformed.empty");
		}
		else {
			throw new RuntimeException(
				getString("exception.check.not.recognized", check)
			);
		}
	}

}
