/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.axis.components.net;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.SecureSocketFactory;
import org.apache.axis.components.net.TransportClientProperties;
import org.apache.axis.components.net.TransportClientPropertiesFactory;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.StringUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.log4j.Logger;

public class MySecureSocketFactory
implements SecureSocketFactory {
    private Logger log = Logger.getLogger(this.getClass());
    private SSLSocketFactory factory;
    private static final int DEFAULT_SSL_PORT = 443;
    private static final int DEFAULT_PROXY_PORT = 7777;

    public static void main(String[] args) throws Exception {
        new MySecureSocketFactory(new Hashtable());
    }

    public MySecureSocketFactory(Hashtable<? extends Object, ? extends Object> table) throws Exception {
        this.log.info((Object)"Get default type");
        String defaultType = KeyStore.getDefaultType();
        this.log.info((Object)String.format("defaultType=\"%s\"", defaultType));
        this.log.info((Object)String.format("Get KeyStore instance", new Object[0]));
        KeyStore ks = KeyStore.getInstance(defaultType);
        String keystore = "/FerrisKeystore";
        this.log.info((Object)String.format("Get class path resource \"%s\"", keystore));
        InputStream is = this.getClass().getResourceAsStream(keystore);
        if (is == null) {
            throw new RuntimeException(String.format("The class path resource \"%s\" is not found!", keystore));
        }
        this.log.info((Object)String.format("Create char[]", new Object[0]));
        char[] password = new char[]{'t', 'o', 'm', 'c', 'a', 't'};
        this.log.info((Object)String.format("Load KeyStore", new Object[0]));
        ks.load(is, password);
        this.log.info((Object)String.format("Loop over KeyStore aliases...", new Object[0]));
        Enumeration<String> enu = ks.aliases();
        while (enu.hasMoreElements()) {
            this.log.info((Object)String.format("Alias=\"%s\"", String.valueOf(enu.nextElement())));
        }
        this.log.info((Object)String.format("Get KeyManagerFactory instance", new Object[0]));
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        this.log.info((Object)String.format("Init KeyManagerFactory", new Object[0]));
        kmf.init(ks, password);
        this.log.info((Object)String.format("Get TrustManagerFactory instance", new Object[0]));
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        this.log.info((Object)String.format("Init TrustManagerFactory", new Object[0]));
        tmf.init(ks);
        this.log.info((Object)String.format("Get SSLContext instance", new Object[0]));
        SSLContext context = SSLContext.getInstance("SSL");
        this.log.info((Object)String.format("Init SSLContext", new Object[0]));
        context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
        this.log.info((Object)String.format("Get SocketFactory", new Object[0]));
        this.factory = context.getSocketFactory();
    }

    private boolean directSSLConnection(TransportClientProperties tcp) {
        return tcp.getProxyHost() == null || tcp.getProxyHost().length() == 0;
    }

    public Socket create(String host, int thePort, StringBuffer otherHeaders, BooleanHolder useFullURL) throws Exception {
        Socket sslSocket;
        int port = thePort == -1 ? 443 : thePort;
        TransportClientProperties tcp = TransportClientPropertiesFactory.create((String)"https");
        if (this.directSSLConnection(tcp)) {
            sslSocket = this.factory.createSocket(host, port);
        } else {
            int tunnelPort;
            int n = tunnelPort = tcp.getProxyPort().length() != 0 ? Integer.parseInt(tcp.getProxyPort()) : 7777;
            if (tunnelPort < 0) {
                tunnelPort = 7777;
            }
            Socket tunnel = new Socket(InetAddress.getByName(tcp.getProxyHost()), tunnelPort);
            OutputStream tunnelOutputStream = tunnel.getOutputStream();
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(tunnelOutputStream)));
            out.print("CONNECT " + host + ":" + port + " HTTP/1.0\r\n" + "User-Agent: AxisClient");
            if (tcp.getProxyUser().length() != 0 && tcp.getProxyPassword().length() != 0) {
                String encodedPassword = XMLUtils.base64encode((byte[])(tcp.getProxyUser() + ":" + tcp.getProxyPassword()).getBytes());
                out.print("\nProxy-Authorization: Basic " + encodedPassword);
            }
            out.print("\nContent-Length: 0");
            out.print("\nPragma: no-cache");
            out.print("\r\n\r\n");
            out.flush();
            InputStream tunnelInputStream = tunnel.getInputStream();
            this.log.debug((Object)Messages.getMessage((String)"isNull00", (String)"tunnelInputStream", (String)("" + (tunnelInputStream == null))));
            String replyStr = "";
            int newlinesSeen = 0;
            boolean headerDone = false;
            while (newlinesSeen < 2) {
                int i = tunnelInputStream.read();
                if (i < 0) {
                    throw new IOException("Unexpected EOF from proxy");
                }
                if (i == 10) {
                    headerDone = true;
                    ++newlinesSeen;
                    continue;
                }
                if (i == 13) continue;
                newlinesSeen = 0;
                if (headerDone) continue;
                replyStr = replyStr + String.valueOf((char)i);
            }
            if (!StringUtils.startsWithIgnoreWhitespaces((String)"HTTP/1.0 200", (String)replyStr) && !StringUtils.startsWithIgnoreWhitespaces((String)"HTTP/1.1 200", (String)replyStr)) {
                throw new IOException(Messages.getMessage((String)"cantTunnel00", (String[])new String[]{tcp.getProxyHost(), "" + tunnelPort, replyStr}));
            }
            sslSocket = this.factory.createSocket(tunnel, host, port, true);
            this.log.debug((Object)Messages.getMessage((String)"setupTunnel00", (String)tcp.getProxyHost(), (String)("" + tunnelPort)));
        }
        ((SSLSocket)sslSocket).startHandshake();
        this.log.debug((Object)Messages.getMessage((String)"createdSSL00"));
        return sslSocket;
    }
}

