/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.controller;

import java.awt.Container;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import org.ferris.awt.ContainerTools;
import org.ferris.journal.gui.controller.JournalsController;
import org.ferris.journal.gui.controller.SearchController;
import org.ferris.journal.gui.data.JournalData;
import org.ferris.journal.gui.data.JournalEntryData;
import org.ferris.journal.gui.i18n.i18n;
import org.ferris.journal.gui.model.Model;
import org.ferris.journal.gui.view.frame.KEntryFrame;
import org.ferris.journal.jws.journal.Journal;
import org.ferris.journal.jws.journalentry.JournalEntry;
import org.ferris.swing.JComponentTools;

public class EntryController {
    private Model model;
    private KEntryFrame view;

    private EntryController setModel(Model model) {
        this.model = model;
        return this;
    }

    private Model getModel() {
        return this.model;
    }

    private EntryController setView() {
        this.view = new KEntryFrame(this, this.getModel());
        return this;
    }

    private KEntryFrame getView() {
        return this.view;
    }

    private EntryController setData() {
        this.getModel().setJournals(JournalData.getInstance().findAll(this.getModel().getAccount()));
        return this;
    }

    public EntryController(Model model) {
        this.setModel(model).setData().setView().getView().setVisible(true);
    }

    public void exit() {
        this.getModel().release();
    }

    public void addEditJournals() {
        new JournalsController(this.getModel());
    }

    public void searchJournalEntries() {
        new SearchController(this.getModel());
    }

    public void insertEntry(final Journal journal, final Date day, final String subject, final String entry) {
        new Thread(){

            @Override
            public void run() {
                ContainerTools.setEnabled((Container)EntryController.this.view.getJContentPane(), (boolean)false);
                JComponentTools.setWaitCursor((JComponent)EntryController.this.view.getJContentPane());
                EntryController.this.model.performingOperation(i18n.getString("op.entry.newEntry", new Object[0]));
                JournalEntry j = new JournalEntry();
                EntryController.this.model.performingOperation(i18n.getString("op.entry.setAccount", new Object[0]));
                j.setAccount(EntryController.this.model.getAccount());
                EntryController.this.model.performingOperation(i18n.getString("op.entry.setJournal", new Object[0]));
                j.setJournal(journal);
                EntryController.this.model.performingOperation(i18n.getString("op.entry.setCreatedOn", new Object[0]));
                j.setCreatedOn(Calendar.getInstance());
                EntryController.this.model.performingOperation(i18n.getString("op.entry.setDay", new Object[0]));
                Calendar cal = Calendar.getInstance();
                cal.setTime(day);
                j.setDay(cal);
                EntryController.this.model.performingOperation(i18n.getString("op.entry.setSubject", new Object[0]));
                j.setSubject(subject);
                EntryController.this.model.performingOperation(i18n.getString("op.entry.setEntry", new Object[0]));
                j.setEntry(entry);
                EntryController.this.model.performingOperation(i18n.getString("op.entry.insert", new Object[0]));
                j = JournalEntryData.getInstance().insert(j);
                ContainerTools.setEnabled((Container)EntryController.this.view.getJContentPane(), (boolean)true);
                JComponentTools.setDefaultCursor((JComponent)EntryController.this.view.getJContentPane());
                EntryController.this.model.performingOperation(i18n.getString("op.entry.inserted", new Object[0]));
                EntryController.this.model.insertJournalEntry(j);
            }
        }.start();
    }

    public void updateEntry(final Long journalEntryId, final Journal journal, final Date day, final String subject, final String entry) {
        new Thread(){

            @Override
            public void run() {
                ContainerTools.setEnabled((Container)EntryController.this.view.getJContentPane(), (boolean)false);
                JComponentTools.setWaitCursor((JComponent)EntryController.this.view.getJContentPane());
                EntryController.this.model.performingOperation(i18n.getString("op.entry.newEntry", new Object[0]));
                JournalEntry j = new JournalEntry();
                EntryController.this.model.performingOperation(i18n.getString("op.entry.setAccount", new Object[0]));
                j.setAccount(EntryController.this.model.getAccount());
                EntryController.this.model.performingOperation(i18n.getString("op.entry.setJournal", new Object[0]));
                j.setJournal(journal);
                EntryController.this.model.performingOperation(i18n.getString("op.entry.setId", new Object[0]));
                j.setId(journalEntryId);
                EntryController.this.model.performingOperation(i18n.getString("op.entry.setCreatedOn", new Object[0]));
                j.setCreatedOn(Calendar.getInstance());
                EntryController.this.model.performingOperation(i18n.getString("op.entry.setDay", new Object[0]));
                Calendar cal = Calendar.getInstance();
                cal.setTime(day);
                j.setDay(cal);
                EntryController.this.model.performingOperation(i18n.getString("op.entry.setSubject", new Object[0]));
                j.setSubject(subject);
                EntryController.this.model.performingOperation(i18n.getString("op.entry.setEntry", new Object[0]));
                j.setEntry(entry);
                EntryController.this.model.performingOperation(i18n.getString("op.entry.update", new Object[0]));
                j = JournalEntryData.getInstance().update(j);
                ContainerTools.setEnabled((Container)EntryController.this.view.getJContentPane(), (boolean)true);
                JComponentTools.setDefaultCursor((JComponent)EntryController.this.view.getJContentPane());
                EntryController.this.model.performingOperation(i18n.getString("op.entry.updated", new Object[0]));
                EntryController.this.model.updateJournalEntry(j);
            }
        }.start();
    }

    public void newEntry() {
        new Thread(){

            @Override
            public void run() {
                EntryController.this.model.performingOperation(i18n.getString("op.entry.new", new Object[0]));
                EntryController.this.model.newJournalEntry();
            }
        }.start();
    }

    public void deleteEntry(final JournalEntry journalEntryBeingEdited) {
        new Thread(){

            @Override
            public void run() {
                ContainerTools.setEnabled((Container)EntryController.this.view.getJContentPane(), (boolean)false);
                JComponentTools.setWaitCursor((JComponent)EntryController.this.view.getJContentPane());
                EntryController.this.model.performingOperation(i18n.getString("op.entry.delete", new Object[0]));
                JournalEntryData.getInstance().delete(EntryController.this.model.getAccount().getId(), journalEntryBeingEdited.getId());
                ContainerTools.setEnabled((Container)EntryController.this.view.getJContentPane(), (boolean)true);
                JComponentTools.setDefaultCursor((JComponent)EntryController.this.view.getJContentPane());
                EntryController.this.model.performingOperation(i18n.getString("op.entry.deleted", new Object[0]));
                EntryController.this.model.deleteJournalEntry(journalEntryBeingEdited);
            }
        }.start();
    }
}

