/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.controller;

import java.awt.Container;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.JComponent;
import org.ferris.awt.ContainerTools;
import org.ferris.journal.gui.data.JournalData;
import org.ferris.journal.gui.i18n.i18n;
import org.ferris.journal.gui.model.Model;
import org.ferris.journal.gui.view.dialog.KErrorDialog;
import org.ferris.journal.gui.view.frame.KJournalsFrame;
import org.ferris.journal.jws.journal.Journal;
import org.ferris.swing.JComponentTools;
import org.ferris.swing.ui.ThrowableDialog;

public class JournalsController {
    private Model model;
    private KJournalsFrame view;

    private JournalsController setModel(Model model) {
        this.model = model;
        return this;
    }

    private Model getModel() {
        return this.model;
    }

    private JournalsController setData() {
        if (this.getModel().getAllJournals() == null) {
            new ThrowableDialog((Throwable)new Exception("Journal data not already set."), true);
        }
        return this;
    }

    private JournalsController setView() {
        this.view = new KJournalsFrame(this, this.getModel());
        return this;
    }

    private KJournalsFrame getView() {
        return this.view;
    }

    public JournalsController(Model model) {
        this.setModel(model).setData().setView().getView().setVisible(true);
    }

    public void closeFrame() {
        this.getView().setVisible(false);
        this.getView().dispose();
    }

    public void addEditJournals() {
        new JournalsController(this.getModel());
    }

    public void insertJournal(final String journalName, final boolean isActive) {
        new Thread(){

            @Override
            public void run() {
                ContainerTools.setEnabled((Container)JournalsController.this.view.getJContentPane(), (boolean)false);
                JComponentTools.setWaitCursor((JComponent)JournalsController.this.view.getJContentPane());
                JournalsController.this.model.performingOperation(i18n.getString("op.journal.newJournal", new Object[0]));
                Journal j = new Journal();
                JournalsController.this.model.performingOperation(i18n.getString("op.journal.setAccount", new Object[0]));
                j.setAccount(JournalsController.this.model.getAccount());
                JournalsController.this.model.performingOperation(i18n.getString("op.journal.setCreatedOn", new Object[0]));
                j.setCreatedOn(Calendar.getInstance());
                JournalsController.this.model.performingOperation(i18n.getString("op.journal.setName", new Object[0]));
                j.setName(journalName);
                JournalsController.this.model.performingOperation(i18n.getString("op.journal.setIsActive", new Object[0]));
                j.setIsActive(isActive);
                JournalsController.this.model.performingOperation(i18n.getString("op.journal.insert", new Object[0]));
                j = JournalData.getInstance().insert(j);
                ContainerTools.setEnabled((Container)JournalsController.this.view.getJContentPane(), (boolean)true);
                JComponentTools.setDefaultCursor((JComponent)JournalsController.this.view.getJContentPane());
                JournalsController.this.model.performingOperation(i18n.getString("op.journal.inserted", new Object[0]));
                JournalsController.this.model.insertJournal(j);
            }
        }.start();
    }

    public void updateJournal(final Long journalId, final String journalName, final boolean journalIsActive) {
        new Thread(){

            @Override
            public void run() {
                ContainerTools.setEnabled((Container)JournalsController.this.view.getJContentPane(), (boolean)false);
                JComponentTools.setWaitCursor((JComponent)JournalsController.this.view.getJContentPane());
                JournalsController.this.model.performingOperation(i18n.getString("op.journal.findingId", new Object[0]));
                Journal existingData = JournalData.getInstance().find(JournalsController.this.model.getAccount(), journalId);
                if (existingData == null) {
                    JournalsController.this.model.performingOperation(i18n.getString("op.journal.id.missing", new Object[0]));
                    ArrayList<String> errors = new ArrayList<String>();
                    errors.add(i18n.getString("journal.id.missing", new Object[0]));
                    new KErrorDialog(JournalsController.this.view, errors);
                    return;
                }
                JournalsController.this.model.performingOperation(i18n.getString("op.journal.setName", new Object[0]));
                existingData.setName(journalName);
                JournalsController.this.model.performingOperation(i18n.getString("op.journal.setIsActive", new Object[0]));
                existingData.setIsActive(journalIsActive);
                JournalsController.this.model.performingOperation(i18n.getString("op.journal.update", new Object[0]));
                existingData = JournalData.getInstance().update(existingData);
                ContainerTools.setEnabled((Container)JournalsController.this.view.getJContentPane(), (boolean)true);
                JComponentTools.setDefaultCursor((JComponent)JournalsController.this.view.getJContentPane());
                JournalsController.this.model.performingOperation(i18n.getString("op.journal.updated", new Object[0]));
                JournalsController.this.model.updateJournal(existingData);
            }
        }.start();
    }

    public void newJournal() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JournalsController.this.model.performingOperation(i18n.getString("op.journal.new", new Object[0]));
                JournalsController.this.model.newJournal();
            }
        }.start();
    }

    public void deleteJournal(final Journal j) {
        new Thread(){

            @Override
            public void run() {
                ContainerTools.setEnabled((Container)JournalsController.this.view.getJContentPane(), (boolean)false);
                JComponentTools.setWaitCursor((JComponent)JournalsController.this.view.getJContentPane());
                JournalsController.this.model.performingOperation(i18n.getString("op.journal.delete", new Object[0]));
                JournalData.getInstance().delete(JournalsController.this.model.getAccount(), j.getId());
                ContainerTools.setEnabled((Container)JournalsController.this.view.getJContentPane(), (boolean)true);
                JComponentTools.setDefaultCursor((JComponent)JournalsController.this.view.getJContentPane());
                JournalsController.this.model.performingOperation(i18n.getString("op.journal.deleted", new Object[0]));
                JournalsController.this.model.deleteJournal(j);
            }
        }.start();
    }
}

