/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.ferris.journal.gui.model.JournalNameComparator;
import org.ferris.journal.jws.journal.Journal;

public class JournalList {
    private List<Journal> all = null;
    private List<Journal> active = null;
    private Comparator<Journal> journalNameComparator = new JournalNameComparator();

    private List<Journal> getAll() {
        if (this.all == null) {
            this.all = new ArrayList<Journal>();
        }
        return this.all;
    }

    private List<Journal> getActive() {
        if (this.active == null) {
            this.active = new ArrayList<Journal>(){
                private static final long serialVersionUID = -2438861478410307586L;

                @Override
                public boolean add(Journal j) {
                    if (j.getIsActive().booleanValue()) {
                        super.add(j);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.active;
    }

    public List<Journal> all() {
        return Collections.unmodifiableList(this.getAll());
    }

    public List<Journal> active() {
        return Collections.unmodifiableList(this.getActive());
    }

    public void add(List<Journal> journals) {
        if (journals == null) {
            return;
        }
        for (Journal journal : journals) {
            this.add(journal);
        }
    }

    public void add(Journal journal) {
        if (this.getAll().add(journal)) {
            Collections.sort(this.getAll(), this.journalNameComparator);
        }
        if (this.getActive().add(journal)) {
            Collections.sort(this.getActive(), this.journalNameComparator);
        }
    }

    public void remove(Journal journal) {
        ListIterator<Journal> itr = this.getAll().listIterator();
        while (itr.hasNext()) {
            if (!itr.next().getId().equals(journal.getId())) continue;
            itr.remove();
            break;
        }
        itr = this.getActive().listIterator();
        while (itr.hasNext()) {
            if (!itr.next().getId().equals(journal.getId())) continue;
            itr.remove();
            break;
        }
    }

    public void update(Journal journal) {
        this.remove(journal);
        this.add(journal);
    }
}

