/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.model;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ferris.journal.gui.model.JournalEntryObserver;
import org.ferris.journal.gui.model.JournalEntrySearchObserver;
import org.ferris.journal.gui.model.JournalList;
import org.ferris.journal.gui.model.JournalObserver;
import org.ferris.journal.gui.model.Model;
import org.ferris.journal.gui.model.OperationObserver;
import org.ferris.journal.gui.model.ReleaseObserver;
import org.ferris.journal.jws.account.Account;
import org.ferris.journal.jws.journal.Journal;
import org.ferris.journal.jws.journalentry.JournalEntry;

public class ModelForApplication
implements Model {
    private Logger log = Logger.getLogger(this.getClass());
    private Set<ReleaseObserver> releaseObservers = Collections.synchronizedSet(new LinkedHashSet());
    private Set<OperationObserver> operationObservers = Collections.synchronizedSet(new LinkedHashSet());
    private Set<JournalObserver> journalObservers = Collections.synchronizedSet(new LinkedHashSet());
    private Set<JournalEntryObserver> journalEntryObservers = Collections.synchronizedSet(new LinkedHashSet());
    private Set<JournalEntrySearchObserver> journalEntrySearchObservers = Collections.synchronizedSet(new LinkedHashSet());
    private Account account = null;
    private JournalList journalList = new JournalList();

    @Override
    public Model performingOperation(String description) {
        for (OperationObserver o : this.operationObservers) {
            o.performingOperation(description);
        }
        return this;
    }

    @Override
    public Model release() {
        for (ReleaseObserver r : this.releaseObservers) {
            r.released();
        }
        System.exit(0);
        return this;
    }

    @Override
    public Account getAccount() {
        return this.account;
    }

    @Override
    public Model setAccount(Account iAmLoggedIn) {
        this.account = iAmLoggedIn;
        return this;
    }

    @Override
    public List<Journal> getAllJournals() {
        return this.journalList.all();
    }

    @Override
    public Model setJournals(List<Journal> allJournals) {
        this.journalList.add(allJournals);
        return this;
    }

    @Override
    public Model insertJournal(Journal j) {
        this.journalList.add(j);
        for (JournalObserver o : this.journalObservers) {
            o.insertedJournal(j);
        }
        return this;
    }

    @Override
    public Model updateJournal(Journal j) {
        this.journalList.update(j);
        for (JournalObserver o : this.journalObservers) {
            o.updatedJournal(j);
        }
        return this;
    }

    @Override
    public Model newJournal() {
        for (JournalObserver o : this.journalObservers) {
            o.newJournal();
        }
        return this;
    }

    @Override
    public Model editJournal(Journal editMe) {
        for (JournalObserver o : this.journalObservers) {
            o.editJournal(editMe);
        }
        return this;
    }

    @Override
    public Model editJournalEntry(JournalEntry editMe) {
        for (JournalEntryObserver o : this.journalEntryObservers) {
            o.editJournalEntry(editMe);
        }
        return this;
    }

    @Override
    public Model deleteJournal(Journal j) {
        this.journalList.remove(j);
        for (JournalObserver o : this.journalObservers) {
            o.deletedJournal(j);
        }
        return this;
    }

    @Override
    public List<Journal> getActiveJournals() {
        return this.journalList.active();
    }

    @Override
    public Model insertJournalEntry(JournalEntry je) {
        for (JournalEntryObserver o : this.journalEntryObservers) {
            o.insertedJournalEntry(je);
        }
        return this;
    }

    @Override
    public Model updateJournalEntry(JournalEntry je) {
        for (JournalEntryObserver o : this.journalEntryObservers) {
            o.updatedJournalEntry(je);
        }
        return this;
    }

    @Override
    public Model newJournalEntry() {
        for (JournalEntryObserver o : this.journalEntryObservers) {
            o.newJournalEntry();
        }
        return this;
    }

    @Override
    public Model deleteJournalEntry(JournalEntry j) {
        for (JournalEntryObserver o : this.journalEntryObservers) {
            o.deletedJournalEntry(j);
        }
        return this;
    }

    @Override
    public Model setJournalEntrySearchResults(List<JournalEntry> searchResults) {
        for (JournalEntrySearchObserver o : this.journalEntrySearchObservers) {
            o.results(searchResults);
        }
        return this;
    }

    @Override
    public Model registerObserver(ReleaseObserver observer) {
        this.log.info((Object)("Register : ReleaseObserver : " + observer.hashCode()));
        this.releaseObservers.add(observer);
        return this;
    }

    @Override
    public ReleaseObserver removeObserver(ReleaseObserver observer) {
        this.log.info((Object)("Remove : ReleaseObserver : " + observer.hashCode()));
        return this.releaseObservers.remove(observer) ? observer : null;
    }

    @Override
    public Model registerObserver(OperationObserver observer) {
        this.log.info((Object)("Register : OperationObserver : " + observer.hashCode()));
        this.operationObservers.add(observer);
        return this;
    }

    @Override
    public OperationObserver removeObserver(OperationObserver observer) {
        this.log.info((Object)("Remove : OperationObserver : " + observer.hashCode()));
        return this.operationObservers.remove(observer) ? observer : null;
    }

    @Override
    public Model registerObserver(JournalObserver observer) {
        this.log.info((Object)("Register : JournalObserver : " + observer.hashCode()));
        this.journalObservers.add(observer);
        return this;
    }

    @Override
    public JournalObserver removeObserver(JournalObserver observer) {
        this.log.info((Object)("Remove : JournalObserver : " + observer.hashCode()));
        return this.journalObservers.remove(observer) ? observer : null;
    }

    @Override
    public Model registerObserver(JournalEntryObserver observer) {
        this.log.info((Object)("Register : JournalEntryObserver : " + observer.hashCode()));
        this.journalEntryObservers.add(observer);
        return this;
    }

    @Override
    public JournalEntryObserver removeObserver(JournalEntryObserver observer) {
        this.log.info((Object)("Remove : JournalEntryObserver : " + observer.hashCode()));
        return this.journalEntryObservers.remove(observer) ? observer : null;
    }

    @Override
    public Model registerObserver(JournalEntrySearchObserver observer) {
        this.log.info((Object)("Register : JournalEntrySearchObserver : " + observer.hashCode()));
        this.journalEntrySearchObservers.add(observer);
        return this;
    }

    @Override
    public JournalEntrySearchObserver removeObserver(JournalEntrySearchObserver observer) {
        this.log.info((Object)("Remove : JournalEntrySearchObserver : " + observer.hashCode()));
        return this.journalEntrySearchObservers.remove(observer) ? observer : null;
    }
}

