/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.view.combobox;

import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;
import org.ferris.journal.gui.model.JournalObserver;
import org.ferris.journal.gui.model.Model;
import org.ferris.journal.jws.journal.Journal;

public class KJournalComboBoxModel
extends DefaultComboBoxModel
implements JournalObserver {
    private static final long serialVersionUID = -5067783059004831441L;
    private Logger log = Logger.getLogger(this.getClass());
    private Model model;

    private List<Journal> getJournals() {
        return this.model.getActiveJournals();
    }

    private void journalChanged(Journal journal) {
        if (!journal.getIsActive().booleanValue()) {
            this.log.info((Object)"Changed journal is NOT active");
        } else {
            this.log.info((Object)"Changed journal IS active");
            int newSelectedIndex = this.getJournals().indexOf(journal);
            this.fireContentsChanged(this, newSelectedIndex, newSelectedIndex);
        }
    }

    public KJournalComboBoxModel(Model model) {
        this.model = model;
    }

    @Override
    public Object getElementAt(int index) {
        return this.getJournalAt(index);
    }

    public Journal getJournalAt(int index) {
        return this.getJournals().get(index);
    }

    @Override
    public int getSize() {
        return this.getJournals().size();
    }

    @Override
    public void deletedJournal(Journal deletedJournal) {
        this.log.info((Object)"ENTER: deletedJournal()");
        this.fireContentsChanged(this, 0, this.getJournals().size());
        this.log.info((Object)"EXIT: deletedJournal()");
    }

    @Override
    public void editJournal(Journal editMe) {
        this.log.info((Object)"ENTER: editJournal()");
        this.log.info((Object)"EXIT: editJournal()");
    }

    @Override
    public void insertedJournal(Journal newJournal) {
        this.log.info((Object)"ENTER: insertedJournal()");
        this.journalChanged(newJournal);
        this.log.info((Object)"EXIT: insertedJournal()");
    }

    @Override
    public void newJournal() {
        this.log.info((Object)"ENTER: newJournal()");
        this.log.info((Object)"EXIT: newJournal()");
    }

    @Override
    public void updatedJournal(Journal updatedJournal) {
        this.log.info((Object)"ENTER: updatedJournal()");
        this.journalChanged(updatedJournal);
        this.log.info((Object)"EXIT: updatedJournal()");
    }
}

