/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.view.textfield;

import org.apache.commons.lang.ArrayUtils;
import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;
import org.ferris.constraint.NotNull;
import org.ferris.constraint.StringLengthBetween;
import org.ferris.journal.gui.i18n.i18n;
import org.ferris.journal.gui.view.textfield.KAbstractPasswordField;

public class KPasswordField
extends KAbstractPasswordField {
    private static final long serialVersionUID = -352120234314107743L;
    private Constraint<String> constraint;

    private int getMin() {
        return 8;
    }

    private int getMax() {
        return 50;
    }

    @Override
    public Constraint<String> getConstraint() {
        if (this.constraint == null) {
            this.constraint = new NotNull((Constraint)new StringLengthBetween(this.getMin(), true, this.getMax(), true));
        }
        return this.constraint;
    }

    @Override
    public String getExplaination(Check check) {
        if (check.equals((Object)Check.IsNull)) {
            return i18n.getString("password.malformed.null", new Object[0]);
        }
        if (check.equals((Object)Check.LessThan)) {
            int len = ArrayUtils.getLength((Object)this.getPassword());
            if (len == 0) {
                return i18n.getString("password.malformed.null", new Object[0]);
            }
            return i18n.getString("password.malformed.tooshort", this.getMin(), len);
        }
        if (check.equals((Object)Check.GreaterThan)) {
            return i18n.getString("password.malformed.toolong", this.getMax(), ArrayUtils.getLength((Object)this.getPassword()));
        }
        throw new RuntimeException(i18n.getString("exception.check.not.recognized", check));
    }
}

