/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.view.list;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.ferris.journal.gui.view.list.KAbstractJournalListModel;
import org.ferris.journal.gui.view.list.KJournalListCellRenderer;
import org.ferris.journal.jws.journal.Journal;

public class KJournalList
extends JList {
    private Logger log = Logger.getLogger(this.getClass());
    private static final long serialVersionUID = -6949799304095333307L;

    public KJournalList(KAbstractJournalListModel m) {
        super(m);
        this.setCellRenderer(new KJournalListCellRenderer());
    }

    public KAbstractJournalListModel getJournalListModel() {
        this.log.info((Object)"ENTER: getJournalListModel()");
        return (KAbstractJournalListModel)this.getModel();
    }

    public List<Journal> getSelectedJournals() {
        Object[] array = this.getSelectedValues();
        int lngth = array == null ? 0 : array.length;
        ArrayList<Journal> selected = new ArrayList<Journal>(lngth);
        for (int i = 0; i < lngth; ++i) {
            selected.add((Journal)array[i]);
        }
        return selected;
    }

    @Override
    public void setSelectedValue(Object anObject, boolean shouldScroll) {
        this.log.info((Object)"ENTER: setSelectedValue()");
        if (anObject == null) {
            this.log.info((Object)"The parameter anObject == null");
            this.setSelectedIndex(-1);
        } else if (!Journal.class.isAssignableFrom(anObject.getClass())) {
            this.log.info((Object)("The parameter's anObject class is \"" + anObject.getClass() + "\" which is not assignable to \"" + Journal.class + "\" "));
            super.setSelectedValue(anObject, shouldScroll);
        } else {
            KAbstractJournalListModel listModel = this.getJournalListModel();
            Journal newSelectedJournal = (Journal)anObject;
            final int newSelectedIndex = listModel.getIndexOf(newSelectedJournal);
            this.log.info((Object)("newSelectedIndex: " + newSelectedIndex));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KJournalList.this.log.info((Object)"ENTER: run()");
                    KJournalList.this.log.info((Object)("Set selected index to: " + newSelectedIndex));
                    KJournalList.this.setSelectedIndex(newSelectedIndex);
                    KJournalList.this.ensureIndexIsVisible(newSelectedIndex);
                    KJournalList.this.fireSelectionValueChanged(newSelectedIndex, newSelectedIndex, false);
                    KJournalList.this.log.info((Object)"EXIT: run()");
                }
            });
        }
        this.log.info((Object)"EXIT: setSelectedValue()");
    }
}

