/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.journal.gui.view.textfield;

import org.ferris.constraint.Check;
import org.ferris.constraint.Constraint;
import org.ferris.constraint.NotNull;
import org.ferris.constraint.StringLengthBetween;
import org.ferris.journal.gui.i18n.i18n;
import org.ferris.journal.gui.view.textfield.KAbstractTextField;

public class KEntrySubjectTextField
extends KAbstractTextField {
    private static final long serialVersionUID = -352120234314107743L;
    private Constraint<String> constraint;

    private int getMin() {
        return 1;
    }

    private int getMax() {
        return 100;
    }

    @Override
    public Constraint<String> getConstraint() {
        if (this.constraint == null) {
            this.constraint = new NotNull((Constraint)new StringLengthBetween(this.getMin(), true, this.getMax(), true));
        }
        return this.constraint;
    }

    @Override
    public String getExplaination(Check check) {
        if (check.equals((Object)Check.IsNull)) {
            return i18n.getString("entry.subject.malformed.null", new Object[0]);
        }
        if (check.equals((Object)Check.LessThan)) {
            return i18n.getString("entry.subject.malformed.empty", new Object[0]);
        }
        if (check.equals((Object)Check.GreaterThan)) {
            return i18n.getString("entry.subject.malformed.toolong", this.getMax(), this.getText().length());
        }
        throw new RuntimeException(i18n.getString("exception.check.not.recognized", check));
    }
}

