/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.ferris.math.Mean;
import org.ferris.math.SampleStandardDeviation;
import org.ferris.math.SampleVariance;
import org.ferris.math.Scale;

public class ConfidenceIntervalForOneSampleT {
    private Double[] doubles;
    private int scale;
    private RoundingMode roundingMode;
    private BigDecimal mean;
    private SampleVariance variance;
    private SampleStandardDeviation deviation;

    private void setDoubles(Double[] doubles) {
        this.doubles = doubles;
    }

    private void setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }

    private void setScale(int scale) {
        this.scale = new Scale(scale).getScale();
    }

    private BigDecimal getMean() {
        if (this.mean == null) {
            this.mean = new Mean(this.getScale(), this.getRoundingMode()).evaluate(this.doubles);
        }
        return this.mean;
    }

    private SampleVariance getSampleVariance() {
        if (this.variance == null) {
            this.variance = new SampleVariance(this.getDoubles(), this.getScale(), this.getRoundingMode());
        }
        return this.variance;
    }

    private SampleStandardDeviation getSampleStandardDeviation() {
        if (this.deviation == null) {
            this.deviation = new SampleStandardDeviation(this.getSampleVariance());
        }
        return this.deviation;
    }

    public ConfidenceIntervalForOneSampleT(int scale, RoundingMode roundingMode) {
        this.setScale(scale);
        this.setRoundingMode(roundingMode);
    }

    public BigDecimal[] evaluate(Double[] ds, double t) {
        this.setDoubles(ds);
        BigDecimal[] evaluate = new BigDecimal[2];
        double interval = t * (this.getSampleStandardDeviation().evaluate().doubleValue() / Math.sqrt(ds.length));
        evaluate[0] = new BigDecimal(this.getMean().doubleValue() - interval).setScale(this.getScale(), this.getRoundingMode());
        evaluate[1] = new BigDecimal(this.getMean().doubleValue() + interval).setScale(this.getScale(), this.getRoundingMode());
        return evaluate;
    }

    public int getScale() {
        return this.scale;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public Double[] getDoubles() {
        return this.doubles;
    }
}

