/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.math;

import org.apache.log4j.Logger;
import org.ferris.math.PMF;

public class ExpectedValue {
    private Logger log = Logger.getLogger(this.getClass());
    private PMF pmf;
    private double sum = Double.NaN;

    private PMF getPmf() {
        return this.pmf;
    }

    private int getLength() {
        return this.getPmf().getLength();
    }

    private double getX(int idx) {
        return this.getPmf().getX(idx);
    }

    private double getPx(int idx) {
        return this.getPmf().getPx(idx);
    }

    public ExpectedValue(PMF pmf) {
        this.pmf = pmf;
    }

    public double evaluate() {
        if (Double.compare(this.sum, Double.NaN) == 0) {
            this.log.info((Object)"Expected Value Summation");
            this.sum = 0.0;
            for (int i = 0; i < this.getLength(); ++i) {
                double d = this.getX(i) * this.getPx(i);
                this.log.debug((Object)(i + ") " + d));
                this.sum += d;
            }
        }
        return this.sum;
    }
}

