/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import org.ferris.math.Scale;
import org.ferris.math.lang.Code;
import org.ferris.math.lang.MathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mean {
    private Scale scale;
    private RoundingMode roundingMode;

    public Mean() {
        this.setScale(new Scale(2));
        this.setRoundingMode(RoundingMode.HALF_UP);
    }

    public Mean(int scale) {
        this.setScale(scale);
        this.setRoundingMode(RoundingMode.HALF_UP);
    }

    public Mean(Scale scale) {
        this.setScale(scale);
        this.setRoundingMode(RoundingMode.HALF_UP);
    }

    public Mean(Scale scale, RoundingMode roundingMode) {
        this.setScale(scale);
        this.setRoundingMode(roundingMode);
    }

    public Mean(RoundingMode roundingMode) {
        this.setScale(new Scale(2));
        this.setRoundingMode(roundingMode);
    }

    public Mean(int scale, RoundingMode roundingMode) {
        this.setScale(scale);
        this.setRoundingMode(roundingMode);
    }

    public BigDecimal evaluate(Double ... doubles) {
        if (doubles.length == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal bd = new BigDecimal(0);
        for (int i = 0; i < doubles.length; ++i) {
            bd = bd.add(new BigDecimal(doubles[i]));
        }
        return bd.divide(new BigDecimal(doubles.length), this.getScale(), this.getRoundingMode());
    }

    public BigDecimal evaluate(Integer ... integers) {
        BigDecimal bd = new BigDecimal(0);
        for (int i = 0; i < integers.length; ++i) {
            bd = bd.add(new BigDecimal(integers[i]));
        }
        return bd.divide(new BigDecimal(integers.length), this.getScale(), this.getRoundingMode());
    }

    public BigDecimal evaluate(Collection<Double> doubles) {
        return this.evaluate(doubles.toArray(new Double[0]));
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    private Mean setRoundingMode(RoundingMode roundingMode) {
        if (roundingMode == null) {
            throw new MathException(Code.MATH00013, new Object[0]);
        }
        this.roundingMode = roundingMode;
        return this;
    }

    public int getScale() {
        return this.scale.getScale();
    }

    private Mean setScale(Scale scale) {
        if (scale == null) {
            throw new MathException(Code.MATH00012, new Object[0]);
        }
        this.scale = scale;
        return this;
    }

    private Mean setScale(int scale) {
        this.scale = new Scale(scale);
        return this;
    }
}

