/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.ferris.math.Mean;
import org.ferris.math.Scale;

public class SampleVariance {
    private Double[] doubles;
    private BigDecimal mean;
    private BigDecimal evaluate;
    private int scale;
    private RoundingMode roundingMode;

    private void setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }

    private void setScale(int scale) {
        this.scale = new Scale(scale).getScale();
    }

    private Double[] getDoubles() {
        return this.doubles;
    }

    private void setDoubles(Double[] doubles) {
        this.doubles = doubles;
    }

    public SampleVariance(Double[] data, int scale, RoundingMode roundingMode) {
        this.setDoubles(data);
        this.setScale(scale);
        this.setRoundingMode(roundingMode);
    }

    public int getScale() {
        return this.scale;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public BigDecimal getMean() {
        if (this.mean == null) {
            this.mean = new Mean(this.getScale(), this.getRoundingMode()).evaluate(this.getDoubles());
        }
        return this.mean;
    }

    public BigDecimal evaluate() {
        if (this.evaluate == null) {
            BigDecimal numerator = BigDecimal.ZERO;
            for (Double x : this.getDoubles()) {
                numerator = numerator.add(new BigDecimal(Math.pow(x - this.getMean().doubleValue(), 2.0)).setScale(this.getScale(), this.getRoundingMode()));
            }
            BigDecimal denominator = new BigDecimal(this.getDoubles().length - 1);
            this.evaluate = numerator.divide(denominator, this.getScale(), this.getRoundingMode());
        }
        return this.evaluate;
    }
}

