/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.math;

import org.apache.log4j.Logger;
import org.ferris.math.ExpectedValue;
import org.ferris.math.PMF;

public class Variance {
    private Logger log = Logger.getLogger(this.getClass());
    private PMF pmf;
    private ExpectedValue ev;
    private double sum = Double.NaN;

    public Variance(PMF pmf, ExpectedValue ev) {
        this.pmf = pmf;
        this.ev = ev;
    }

    public double evaluate() {
        if (Double.compare(this.sum, Double.NaN) == 0) {
            this.log.info((Object)"Variance Summation");
            this.sum = 0.0;
            for (int i = 0; i < this.pmf.getLength(); ++i) {
                double d = Math.pow(this.pmf.getX(i) - this.ev.evaluate(), 2.0) * this.pmf.getPx(i);
                this.log.debug((Object)(i + ") " + d));
                this.sum += d;
            }
        }
        return this.sum;
    }
}

