/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.data.splatalogue;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.ferris.astronomy.data.splatalogue.Splatalogue;
import org.ferris.lang.string.ToStringStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyToStringStrategy
implements ToStringStrategy<Splatalogue> {
    private static final long serialVersionUID = 3390609634074675089L;
    private static final String NL = "\n";
    private static final int[] columnLengths = new int[]{15, 15, 30, 15, 15, 15, 30, 30};
    private static final String[] columnDescriptions = new String[]{"Line ID", "Species ID", "Species", "Frequecy", "ELower", "EUpper", "Sij", "Line List"};
    private static final List<String> header;
    private static final ToStringStrategy<Splatalogue> instance;

    static {
        instance = new MyToStringStrategy();
        header = new LinkedList<String>();
        int stop = -1;
        int i = 0;
        while (i < columnLengths.length) {
            int length = columnLengths[i];
            int start = stop + 2;
            stop = start + (length - 1);
            String s = "# [" + StringUtils.leftPad((String)(String.valueOf(start) + " "), (int)4, (char)' ') + "-" + StringUtils.leftPad((String)(String.valueOf(stop) + " "), (int)4, (char)' ') + "]  " + columnDescriptions[i];
            header.add(s);
            ++i;
        }
    }

    public static final String getHeader() {
        StringBuilder sp = new StringBuilder();
        int i = 0;
        for (String line : header) {
            if (i > 0) {
                sp.append(NL);
            }
            ++i;
            sp.append(line);
        }
        return sp.toString();
    }

    public static final List<String> getHeaderLines() {
        return header;
    }

    public static final ToStringStrategy<Splatalogue> getInstance() {
        return instance;
    }

    private MyToStringStrategy() {
    }

    public String toString(Splatalogue s) {
        StringBuffer sp = new StringBuffer();
        int idx = 0;
        int length = columnLengths[idx++] + 1;
        sp.append(StringUtils.rightPad((String)s.getId(), (int)length, (char)' '));
        length = columnLengths[idx++] + 1;
        sp.append(StringUtils.rightPad((String)s.getMolecule().getId(), (int)length, (char)' '));
        length = columnLengths[idx++] + 1;
        sp.append(StringUtils.rightPad((String)s.getMolecule().getName(), (int)length, (char)' '));
        length = columnLengths[idx++] + 1;
        sp.append(StringUtils.rightPad((String)s.getFrequency().toPlainString(), (int)length, (char)' '));
        length = columnLengths[idx++] + 1;
        sp.append(StringUtils.rightPad((String)s.getELower().toPlainString(), (int)length, (char)' '));
        length = columnLengths[idx++] + 1;
        sp.append(StringUtils.rightPad((String)s.getEUpper().toPlainString(), (int)length, (char)' '));
        length = columnLengths[idx++] + 1;
        sp.append(StringUtils.rightPad((String)s.getSij().toPlainString(), (int)length, (char)' '));
        length = columnLengths[idx++] + 1;
        sp.append(StringUtils.rightPad((String)s.getLineList().getName(), (int)length, (char)' '));
        return sp.toString();
    }
}

