/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.jfree.chart.axis;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.ferris.astronomy.math.BigDecimalTools;
import org.ferris.lang.string.StringTools;
import org.ferris.slise.jfree.chart.axis.SetNumberAxisRangeListener;
import org.ferris.slise.plot.PlotFrame;

public class SetNumberAxisRangeDialog
extends JDialog {
    private static final long serialVersionUID = -4024280399000839432L;
    private JPanel setRangePanel = null;
    private JLabel lowerBoundSpacerLabel = null;
    private JPanel componentPanel = null;
    private JLabel lowerBoundLabel = null;
    private JTextField lowerBoundText = null;
    private JLabel upperBoundSpacerLabel = null;
    private JLabel upperBoundLabel = null;
    private JTextField upperBoundText = null;
    private JPanel buttonPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private SetNumberAxisRangeListener listener;

    public SetNumberAxisRangeDialog(PlotFrame owner) throws HeadlessException {
        super((Frame)owner, true);
        this.initialize();
    }

    public void setSetNumberAxisRangeListener(SetNumberAxisRangeListener listener) {
        this.listener = listener;
    }

    protected void fireNumberAxisRangeEvent(double lower, double upper) {
        this.listener.setRange(lower, upper);
    }

    private void initialize() {
        this.setSize(new Dimension(212, 142));
        this.setContentPane(this.getComponentPanel());
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(this.getOwner());
    }

    private JPanel getSetRangePanel() {
        if (this.setRangePanel == null) {
            GridBagConstraints gridBagConstraints71 = new GridBagConstraints();
            gridBagConstraints71.gridx = 0;
            gridBagConstraints71.gridwidth = 2;
            gridBagConstraints71.insets = new Insets(9, 0, 0, 0);
            gridBagConstraints71.gridy = 4;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 3;
            gridBagConstraints6.gridy = 3;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints5.anchor = 13;
            gridBagConstraints5.gridy = 3;
            this.upperBoundLabel = new JLabel();
            this.upperBoundLabel.setText("Upper Bound :");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            this.upperBoundSpacerLabel = new JLabel();
            this.upperBoundSpacerLabel.setText("       ");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 3;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridy = 1;
            this.lowerBoundLabel = new JLabel();
            this.lowerBoundLabel.setText("Lower Bound :");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            this.lowerBoundSpacerLabel = new JLabel();
            this.lowerBoundSpacerLabel.setText("       ");
            this.setRangePanel = new JPanel();
            this.setRangePanel.setLayout(new GridBagLayout());
            this.setRangePanel.add((Component)this.lowerBoundSpacerLabel, gridBagConstraints1);
            this.setRangePanel.add((Component)this.lowerBoundLabel, gridBagConstraints);
            this.setRangePanel.add((Component)this.getLowerBoundText(), gridBagConstraints2);
            this.setRangePanel.add((Component)this.upperBoundSpacerLabel, gridBagConstraints3);
            this.setRangePanel.add((Component)this.upperBoundLabel, gridBagConstraints5);
            this.setRangePanel.add((Component)this.getUpperBoundText(), gridBagConstraints6);
            this.setRangePanel.add((Component)this.getButtonPanel(), gridBagConstraints71);
        }
        return this.setRangePanel;
    }

    private JPanel getComponentPanel() {
        if (this.componentPanel == null) {
            this.componentPanel = new JPanel();
            this.componentPanel.setLayout(new BorderLayout());
            this.componentPanel.add((Component)this.getSetRangePanel(), "North");
        }
        return this.componentPanel;
    }

    private JTextField getLowerBoundText() {
        if (this.lowerBoundText == null) {
            this.lowerBoundText = new JTextField();
            this.lowerBoundText.setPreferredSize(new Dimension(100, 20));
        }
        return this.lowerBoundText;
    }

    private JTextField getUpperBoundText() {
        if (this.upperBoundText == null) {
            this.upperBoundText = new JTextField();
            this.upperBoundText.setPreferredSize(new Dimension(100, 20));
        }
        return this.upperBoundText;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints7.gridy = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints4.gridy = 0;
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            this.buttonPanel.add((Component)this.getOkButton(), gridBagConstraints4);
            this.buttonPanel.add((Component)this.getCancelButton(), gridBagConstraints7);
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.setPreferredSize(new Dimension(75, 26));
            this.getRootPane().setDefaultButton(this.okButton);
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evnt) {
                    JTextField field = null;
                    LinkedList<String> errors = new LinkedList<String>();
                    double lower = 0.0;
                    try {
                        field = SetNumberAxisRangeDialog.this.getLowerBoundText();
                        field.setBackground(Color.WHITE);
                        field.setText(StringTools.trimToDefault((String)field.getText(), (String)""));
                        lower = BigDecimalTools.getBigDecimal((String)field.getText()).doubleValue();
                    }
                    catch (NumberFormatException e) {
                        errors.add("Lower bound is not numeric");
                        field.setBackground(Color.RED);
                    }
                    double upper = 0.0;
                    try {
                        field = SetNumberAxisRangeDialog.this.getUpperBoundText();
                        field.setBackground(Color.WHITE);
                        field.setText(StringTools.trimToDefault((String)field.getText(), (String)""));
                        upper = BigDecimalTools.getBigDecimal((String)field.getText()).doubleValue();
                    }
                    catch (NumberFormatException e) {
                        errors.add("Upper bound is not numeric");
                        field.setBackground(Color.RED);
                    }
                    if (errors.size() == 0 && lower > upper) {
                        errors.add("Lower bound must be less than upper bound");
                        SetNumberAxisRangeDialog.this.getLowerBoundText().setBackground(Color.RED);
                        SetNumberAxisRangeDialog.this.getUpperBoundText().setBackground(Color.RED);
                    }
                    if (errors.size() > 0) {
                        StringBuffer sp = new StringBuffer();
                        Iterator itr = errors.iterator();
                        while (itr.hasNext()) {
                            sp.append(itr.next());
                            if (!itr.hasNext()) continue;
                            sp.append("\n");
                        }
                        JOptionPane.showMessageDialog(SetNumberAxisRangeDialog.this, sp.toString(), "Input Error", 0);
                        return;
                    }
                    SetNumberAxisRangeDialog.this.fireNumberAxisRangeEvent(lower, upper);
                    SetNumberAxisRangeDialog.this.getCancelButton().doClick();
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setPreferredSize(new Dimension(75, 26));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SetNumberAxisRangeDialog.this.setVisible(false);
                    SetNumberAxisRangeDialog.this.dispose();
                }
            });
        }
        return this.cancelButton;
    }
}

