/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.jfree.data.xy;

import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;

public class SliseXYSeries
extends XYSeries {
    private static final long serialVersionUID = -3168009005014028297L;
    private double xmin = Double.MAX_VALUE;
    private double xmax = Double.MIN_VALUE;
    private double ymin = Double.MAX_VALUE;
    private double ymax = Double.MIN_VALUE;

    public SliseXYSeries(Comparable arg0) {
        super(arg0);
    }

    public SliseXYSeries(Comparable arg0, boolean arg1) {
        super(arg0, arg1);
    }

    public SliseXYSeries(Comparable arg0, boolean arg1, boolean arg2) {
        super(arg0, arg1, arg2);
    }

    private void setX(double x) {
        this.setXMin(x);
        this.setXMax(x);
    }

    private void setXMin(double x) {
        if (x < this.xmin) {
            this.xmin = x;
        }
    }

    private void setXMax(double x) {
        if (x > this.xmax) {
            this.xmax = x;
        }
    }

    private void setY(double y) {
        this.setYMin(y);
        this.setYMax(y);
    }

    private void setYMin(double y) {
        if (y < this.ymin) {
            this.ymin = y;
        }
    }

    private void setYMax(double y) {
        if (y > this.ymax) {
            this.ymax = y;
        }
    }

    public double getXMax() {
        return this.xmax;
    }

    public boolean isXMaxSet() {
        return Double.compare(this.xmax, Double.MIN_VALUE) != 0;
    }

    public double getXMin() {
        return this.xmin;
    }

    public boolean isXMinSet() {
        return Double.compare(this.xmin, Double.MAX_VALUE) != 0;
    }

    public double getYMax() {
        return this.ymax;
    }

    public boolean isYMaxSet() {
        return Double.compare(this.ymax, Double.MIN_VALUE) != 0;
    }

    public double getYMin() {
        return this.ymin;
    }

    public boolean isYMinSet() {
        return Double.compare(this.ymin, Double.MAX_VALUE) != 0;
    }

    public void add(XYDataItem item, boolean notify) {
        this.setX(item.getX().doubleValue());
        this.setY(item.getY().doubleValue());
        super.add(item, notify);
    }
}

