/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.jfree.data.xy;

import java.util.HashMap;
import java.util.Map;
import org.ferris.astronomy.data.sourcedata.SourceData;
import org.ferris.astronomy.data.sourcedata.SourceDataList;
import org.ferris.slise.jfree.data.xy.SliseXYSeries;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SliseXYSeriesCollection
extends XYSeriesCollection {
    private static final long serialVersionUID = -687762587473094892L;

    public void addSeries(Map<String, SourceDataList> map) {
        for (String band : map.keySet()) {
            SliseXYSeries xyseries = new SliseXYSeries((Comparable)((Object)"SourceDataSeries"), true, true);
            xyseries.setDescription(band);
            SourceDataList list = map.get(band);
            for (SourceData data : list) {
                xyseries.add(data.getFrequency().doubleValue(), data.getIntensity().doubleValue());
            }
            this.addSeries(xyseries);
        }
    }

    public Map<String, SliseXYSeries> getSourceDataSeries() {
        HashMap<String, SliseXYSeries> map = new HashMap<String, SliseXYSeries>();
        for (XYSeries series : this.getSeries()) {
            Comparable key = series.getKey();
            if (key == null || key.compareTo("SourceDataSeries") != 0) continue;
            map.put(series.getDescription(), (SliseXYSeries)series);
        }
        return map;
    }

    public double getSeriesYMin() {
        double d = Double.MAX_VALUE;
        for (SliseXYSeries s : this.getSourceDataSeries().values()) {
            if (!(s.getYMin() < d)) continue;
            d = s.getYMin();
        }
        return d;
    }

    public double getSeriesYMax() {
        double d = Double.MIN_VALUE;
        for (SliseXYSeries s : this.getSourceDataSeries().values()) {
            if (!(s.getYMax() > d)) continue;
            d = s.getYMax();
        }
        return d;
    }

    public double getSeriesXMin() {
        double d = Double.MAX_VALUE;
        for (SliseXYSeries s : this.getSourceDataSeries().values()) {
            if (!(s.getXMin() < d)) continue;
            d = s.getXMin();
        }
        return d;
    }

    public double getSeriesXMax() {
        double d = Double.MIN_VALUE;
        for (SliseXYSeries s : this.getSourceDataSeries().values()) {
            if (!(s.getXMax() > d)) continue;
            d = s.getXMax();
        }
        return d;
    }

    public void refresh() {
        Map<String, SliseXYSeries> map = this.getSourceDataSeries();
        this.removeAllSeries();
        for (SliseXYSeries s : map.values()) {
            this.addSeries(s);
        }
    }

    public void refreshWithFrequencyShift(double d) {
        Map<String, SliseXYSeries> oldMap = this.getSourceDataSeries();
        this.removeAllSeries();
        HashMap<String, SliseXYSeries> newMap = new HashMap<String, SliseXYSeries>();
        for (String band : oldMap.keySet()) {
            SliseXYSeries oldSeries = oldMap.get(band);
            SliseXYSeries newSeries = new SliseXYSeries((Comparable)((Object)"SourceDataSeries"), true, true);
            newMap.put(band, newSeries);
            for (XYDataItem item : oldSeries.getItems()) {
                newSeries.add(item.getX().doubleValue() + d, item.getY());
            }
            this.addSeries(newSeries);
        }
    }
}

