/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.model;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ferris.astronomy.data.h.HServices;
import org.ferris.astronomy.data.he.HEServices;
import org.ferris.astronomy.data.molecule.MoleculeServices;
import org.ferris.astronomy.data.source.Source;
import org.ferris.astronomy.data.source.SourceFactory;
import org.ferris.astronomy.data.source.SourceServices;
import org.ferris.astronomy.data.sourcedata.SourceData;
import org.ferris.astronomy.data.sourcedata.SourceDataList;
import org.ferris.astronomy.data.sourcedata.SourceDataServices;
import org.ferris.astronomy.data.splatalogue.Splatalogue;
import org.ferris.astronomy.data.splatalogue.SplatalogueServices;
import org.ferris.astronomy.data.telescope.Telescope;
import org.ferris.astronomy.data.telescope.TelescopeArrayType;
import org.ferris.astronomy.data.telescope.TelescopeArrayTypeServices;
import org.ferris.astronomy.data.telescope.TelescopeServices;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.math.BigDecimalTools;
import org.ferris.slise.data.source.MySourceBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SliseModel {
    private SourceServices sourceServices;
    private SourceDataServices sourceDataServices;
    private SplatalogueServices splatalogServices;
    private HServices hServices;
    private HEServices heServices;
    private TelescopeServices telescopeServices;
    private SourceDataServices userSourceDataServices;
    private MoleculeServices moleculeServices;
    private TelescopeArrayTypeServices telescopeArrayTypeServices;
    private PreloadMoleculesThread preloadMoleculesThread;
    private List<String> sourceClientIds;

    protected SliseModel() {
    }

    protected SliseModel init(SourceServices sourceServices, SourceDataServices sourceDataServices, SplatalogueServices splatalogServices, HServices hServices, HEServices heServices, TelescopeServices telescopeServices, SourceDataServices userSourceDataServices, MoleculeServices moleculeServices, TelescopeArrayTypeServices telescopeArrayTypeServices) {
        System.setProperty("org.ferris.astronomy.data.source.SourceFactory", "org.ferris.slise.data.source.MySourceFactory");
        this.sourceServices = sourceServices;
        this.sourceDataServices = sourceDataServices;
        this.splatalogServices = splatalogServices;
        this.hServices = hServices;
        this.heServices = heServices;
        this.telescopeServices = telescopeServices;
        this.userSourceDataServices = userSourceDataServices;
        this.moleculeServices = moleculeServices;
        this.telescopeArrayTypeServices = telescopeArrayTypeServices;
        this.preloadMoleculesThread = new PreloadMoleculesThread();
        this.preloadMoleculesThread.start();
        return this;
    }

    public SliseModel setSourceClientIds(List<String> clientIds) {
        if (clientIds == null) {
            this.sourceClientIds = null;
        } else {
            this.sourceClientIds = new ArrayList<String>(clientIds.size());
            this.sourceClientIds.addAll(clientIds);
        }
        return this;
    }

    public List getSourceList() throws AstronomyException {
        return this.sourceServices.findByClient(this.sourceClientIds);
    }

    public Map<String, SourceDataList> getSourceDataMap(double minFreq, double maxFreq, Source source) throws AstronomyException {
        SourceDataList all = this.sourceDataServices.findByFrequency(minFreq, maxFreq, new Source[]{source});
        HashMap<String, SourceDataList> map = new HashMap<String, SourceDataList>();
        if (all.isEmpty()) {
            map.put("empty", all);
        } else {
            for (SourceData data : all) {
                SourceDataList list;
                String band = data.getBand();
                if (band == null) {
                    band = "null";
                }
                if ((list = (SourceDataList)map.get(band)) == null) {
                    list = new SourceDataList();
                    map.put(band, list);
                }
                list.add((Object)data);
            }
        }
        return map;
    }

    public List<Splatalogue> getSplatalogueData(double minFreq, double maxFreq, List<String> speciesIds) throws AstronomyException {
        return this.splatalogServices.findByFrequency(minFreq, maxFreq, speciesIds);
    }

    public List getHRecombData(double minFreq, double maxFreq) throws AstronomyException {
        return this.hServices.findByFrequency(minFreq, maxFreq);
    }

    public List getHERecombData(double minFreq, double maxFreq) throws AstronomyException {
        return this.heServices.findByFrequency(minFreq, maxFreq);
    }

    public Source getUserSource(File sourceDataFile, String name, double velocityKmSec, double freqencyMultiplier) throws AstronomyException {
        MySourceBean s = (MySourceBean)SourceFactory.getSource((String)sourceDataFile.getPath(), (String)name, (String)"", (BigDecimal)BigDecimalTools.getBigDecimal((double)velocityKmSec), (Telescope)this.getUserTelescope(), (double)freqencyMultiplier);
        s.setUserDataSet(true);
        return s;
    }

    public Source getEmptySource(String name, double velocityKmSec, double freqencyMultiplier) throws AstronomyException {
        File emptyFile = null;
        try {
            emptyFile = File.createTempFile("SLiSE_Empty_Data_File-", ".txt");
            emptyFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        MySourceBean s = (MySourceBean)SourceFactory.getSource((String)emptyFile.getPath(), (String)name, (String)"", (BigDecimal)BigDecimalTools.getBigDecimal((double)velocityKmSec), (Telescope)this.getEmptyTelescope(), (double)freqencyMultiplier);
        s.setUserDataSet(true);
        return s;
    }

    private Telescope getUserTelescope() throws AstronomyException {
        return this.telescopeServices.getTelescope("Local File");
    }

    private Telescope getEmptyTelescope() throws AstronomyException {
        return this.telescopeServices.getTelescope("");
    }

    public Map<String, SourceDataList> getUserSourceDataMap(double minFreq, double maxFreq, Source source) throws AstronomyException {
        SourceDataList all = this.userSourceDataServices.findByFrequency(minFreq, maxFreq, new Source[]{source});
        HashMap<String, SourceDataList> map = new HashMap<String, SourceDataList>();
        if (all.isEmpty()) {
            map.put("empty", all);
        } else {
            for (SourceData data : all) {
                SourceDataList list;
                String band = data.getBand();
                if (band == null) {
                    band = "null";
                }
                if ((list = (SourceDataList)map.get(band)) == null) {
                    list = new SourceDataList();
                    map.put(band, list);
                }
                list.add((Object)data);
            }
        }
        return map;
    }

    public List getMoleculesAvailable() throws AstronomyException {
        try {
            this.preloadMoleculesThread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Problem waiting for PreloadMoleculesThread to die.", e);
        }
        if (this.preloadMoleculesThread.hasException()) {
            throw this.preloadMoleculesThread.getException();
        }
        return this.preloadMoleculesThread.getList();
    }

    public TelescopeArrayType getArrayTelescopeType() throws AstronomyException {
        return this.telescopeArrayTypeServices.getArray();
    }

    public TelescopeArrayType getSingleDishTelescopeType() throws AstronomyException {
        return this.telescopeArrayTypeServices.getSingleDish();
    }

    private class PreloadMoleculesThread
    extends Thread {
        private List moleculesAvailable = null;
        private AstronomyException exception;

        private PreloadMoleculesThread() {
        }

        public void run() {
            try {
                System.out.println("PRELOADING molecules available - START");
                this.moleculesAvailable = SliseModel.this.moleculeServices.findAll();
                System.out.println("PRELOADING molecules available - COMPLETE");
            }
            catch (AstronomyException e) {
                System.out.println("PRELOADING molecules available - EXCEPTION");
                this.exception = e;
            }
        }

        public boolean hasException() {
            return this.exception != null;
        }

        public AstronomyException getException() {
            return this.exception;
        }

        public List getList() {
            return this.moleculesAvailable;
        }
    }
}

