/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.model;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ferris.astronomy.data.h.HServices;
import org.ferris.astronomy.data.h.HServicesBySql;
import org.ferris.astronomy.data.he.HEServices;
import org.ferris.astronomy.data.he.HEServicesBySql;
import org.ferris.astronomy.data.molecule.MoleculeServices;
import org.ferris.astronomy.data.molecule.MoleculeServicesByPhp;
import org.ferris.astronomy.data.source.SourceServices;
import org.ferris.astronomy.data.source.SourceServicesBySql;
import org.ferris.astronomy.data.sourcedata.SourceDataServices;
import org.ferris.astronomy.data.sourcedata.SourceDataServicesByFile;
import org.ferris.astronomy.data.sourcedata.SourceDataServicesBySql;
import org.ferris.astronomy.data.splatalogue.SplatalogueServices;
import org.ferris.astronomy.data.splatalogue.SplatalogueServicesByPhp;
import org.ferris.astronomy.data.telescope.TelescopeArrayTypeServices;
import org.ferris.astronomy.data.telescope.TelescopeArrayTypeServicesByGeneration;
import org.ferris.astronomy.data.telescope.TelescopeServices;
import org.ferris.astronomy.data.telescope.TelescopeServicesByGeneration;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.derby.DerbyShutdownThread;
import org.ferris.derby.DerbyUrl;
import org.ferris.naming.spi.FerrisInitialContextFactory;
import org.ferris.slise.model.SliseModel;
import org.ferris.sql.ConnectionFactory;
import org.ferris.sql.ConnectionFactoryByJndi;
import org.ferris.sql.DataSourceWithSingleConnection;

public class SliseModelByDerby
extends SliseModel {
    public SliseModelByDerby(File databaseDirectory) throws AstronomyException, InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException, NamingException {
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        DerbyUrl derbyUrl = new DerbyUrl(databaseDirectory);
        Connection conn = DriverManager.getConnection(derbyUrl.getConnectionUrl());
        Runtime.getRuntime().addShutdownHook((Thread)new DerbyShutdownThread(derbyUrl));
        FerrisInitialContextFactory.init();
        DataSourceWithSingleConnection ds = new DataSourceWithSingleConnection(conn);
        InitialContext ctx = new InitialContext();
        ctx.bind("java:comp/env/jdbc/kelly", (Object)ds);
        ConnectionFactoryByJndi fact = new ConnectionFactoryByJndi("java:comp/env/jdbc/kelly");
        this.init((SourceServices)new SourceServicesBySql((ConnectionFactory)fact), (SourceDataServices)new SourceDataServicesBySql((ConnectionFactory)fact), (SplatalogueServices)new SplatalogueServicesByPhp(), (HServices)new HServicesBySql((ConnectionFactory)fact), (HEServices)new HEServicesBySql((ConnectionFactory)fact), (TelescopeServices)new TelescopeServicesByGeneration(), (SourceDataServices)new SourceDataServicesByFile(), (MoleculeServices)new MoleculeServicesByPhp(), (TelescopeArrayTypeServices)new TelescopeArrayTypeServicesByGeneration());
    }
}

