/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.ferris.slise.plot.PlotFrame;
import org.ferris.slise.plot.action.DataPointsAction;
import org.ferris.slise.plot.action.FrequencyShiftAction;
import org.ferris.slise.plot.action.PlotFrequencyAction;
import org.ferris.slise.plot.action.PlotHRecombAction;
import org.ferris.slise.plot.action.PlotHeRecombAction;
import org.ferris.slise.plot.action.PlotSplatalogueAction;
import org.ferris.slise.plot.action.PlotVelocityAction;
import org.ferris.slise.plot.action.PrintAction;
import org.ferris.slise.plot.action.RefreshAction;
import org.ferris.slise.plot.action.SearchSlaimAction;

public class InputPanel
extends JPanel {
    private static final long serialVersionUID = 1342529136670784110L;
    private JLabel frequencyLineLabel;
    private JTextField frequencyLineInput;
    private JButton frequencyLineButton;
    private JLabel velocityLabel;
    private JTextField velocityInput;
    private JButton velocityButton;
    private JLabel frequencyShiftLabel;
    private JTextField frequencyShiftInput;
    private JButton frequencyShiftButton;
    private JButton showDataPointsButton;
    private JButton plotSlaimButton;
    private JButton plotSplatalogue;
    private JButton plotHRecombButton;
    private JButton plotHeRecombButton;
    private JButton printButton;
    private JButton refreshButton;
    private JLabel spaceLabel;
    private JPanel miscButtonPanel;
    private JPanel plotButtonPanel;
    private Insets buttonMargin;

    public void clear() {
        this.frequencyLineInput.setText("");
        this.velocityInput.setText("");
        this.frequencyShiftInput.setText("");
    }

    public void setVelocityEnabled(boolean b) {
        this.velocityLabel.setEnabled(b);
        this.velocityInput.setEnabled(b);
        this.velocityButton.setEnabled(b);
        this.velocityButton.setBackground(this.getVelocityColor(b));
    }

    public void setFrequencyShiftEnabled(boolean b) {
        this.frequencyShiftLabel.setEnabled(b);
        this.frequencyShiftInput.setEnabled(b);
        this.frequencyShiftButton.setEnabled(b);
    }

    public boolean isFrequencyShiftEnabled() {
        return this.frequencyShiftButton.isEnabled();
    }

    public InputPanel(PlotFrame plotFrame) {
        super(new GridBagLayout());
        this.setProperties();
        this.createVisualObjects(plotFrame);
        this.grouppVisualObjects();
        this.layoutVisualObjects();
    }

    private void layoutVisualObjects() {
        this.layoutFrequencyLine();
        this.layoutVelocity();
        this.layoutFrequencyShift();
        this.layoutShowDataPoints();
        this.layoutButtonPanel();
    }

    private void layoutFrequencyLine() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        this.add((Component)this.frequencyLineLabel, gbc);
        gbc.anchor = 10;
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.add((Component)this.frequencyLineInput, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.add((Component)this.spaceLabel, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        this.add((Component)this.frequencyLineButton, gbc);
    }

    private void layoutVelocity() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridheight = -1;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 13;
        this.add((Component)this.velocityLabel, gbc);
        gbc.anchor = 10;
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.add((Component)this.velocityInput, gbc);
        gbc.gridx = 2;
        gbc.gridy = 1;
        this.add((Component)this.spaceLabel, gbc);
        gbc.gridx = 3;
        gbc.gridy = 1;
        this.add((Component)this.velocityButton, gbc);
    }

    private void layoutFrequencyShift() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridheight = 0;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 13;
        this.add((Component)this.frequencyShiftLabel, gbc);
        gbc.anchor = 10;
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.add((Component)this.frequencyShiftInput, gbc);
        gbc.gridx = 2;
        gbc.gridy = 2;
        this.add((Component)this.spaceLabel, gbc);
        gbc.gridx = 3;
        gbc.gridy = 2;
        this.add((Component)this.frequencyShiftButton, gbc);
    }

    private void layoutShowDataPoints() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridheight = 4;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.weightx = 90.0;
        gbc.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.plotButtonPanel, gbc);
    }

    private void layoutButtonPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.gridheight = 3;
        gbc.anchor = 13;
        this.add((Component)this.miscButtonPanel, gbc);
    }

    private void grouppVisualObjects() {
        this.miscButtonPanel = new JPanel(new FlowLayout(2));
        this.miscButtonPanel.add(this.showDataPointsButton);
        this.miscButtonPanel.add(this.refreshButton);
        this.miscButtonPanel.add(this.printButton);
        this.plotButtonPanel = new JPanel(new GridLayout(4, 1));
        this.plotButtonPanel.add(this.plotSlaimButton);
        this.plotButtonPanel.add(this.plotHRecombButton);
        this.plotButtonPanel.add(this.plotHeRecombButton);
    }

    private void createVisualObjects(PlotFrame plotFrame) {
        this.frequencyLineLabel = new JLabel(" Frequency Line: ");
        this.frequencyLineInput = new JTextField(8);
        this.frequencyLineInput.addActionListener(new PlotFrequencyAction(this.frequencyLineInput));
        this.frequencyLineInput.setToolTipText("A comma-separated list of frequency lines.");
        this.frequencyLineButton = new JButton("Plot");
        this.frequencyLineButton.addActionListener(new PlotFrequencyAction(this.frequencyLineInput));
        this.frequencyLineButton.setBackground(this.getFrequencyColor());
        this.setMargin(this.frequencyLineButton);
        this.frequencyShiftLabel = new JLabel(" Frequency Shift: ");
        this.frequencyShiftInput = new JTextField(8);
        this.frequencyShiftInput.addActionListener(new FrequencyShiftAction(this.frequencyShiftInput));
        this.frequencyShiftInput.setToolTipText("Frequency Shift");
        this.frequencyShiftButton = new JButton("Plot");
        this.frequencyShiftButton.addActionListener(new FrequencyShiftAction(this.frequencyShiftInput));
        this.setMargin(this.frequencyShiftButton);
        this.velocityLabel = new JLabel("Velocity: ");
        this.velocityInput = new JTextField(8);
        this.velocityInput.addActionListener(new PlotVelocityAction(this.velocityInput));
        this.velocityInput.setToolTipText("A comma separated list of velocities");
        this.velocityButton = new JButton("Plot");
        this.velocityButton.addActionListener(new PlotVelocityAction(this.velocityInput));
        this.velocityButton.setBackground(this.getVelocityColor());
        this.setMargin(this.velocityButton);
        this.showDataPointsButton = new JButton("Data Points");
        this.showDataPointsButton.addActionListener(new DataPointsAction());
        this.setMargin(this.showDataPointsButton);
        this.plotSlaimButton = new JButton("Slaim");
        this.plotSlaimButton.addActionListener(new SearchSlaimAction());
        this.plotSlaimButton.setBackground(this.getSlaimColor());
        this.plotSlaimButton.setForeground(Color.WHITE);
        this.setMargin(this.plotSlaimButton);
        this.plotSplatalogue = new JButton("Splatalogue");
        this.plotSplatalogue.addActionListener((ActionListener)((Object)new PlotSplatalogueAction(plotFrame)));
        this.plotSplatalogue.setBackground(this.getSplatalogueColor());
        this.setMargin(this.plotSplatalogue);
        this.plotHRecombButton = new JButton("H Recomb");
        this.plotHRecombButton.addActionListener(new PlotHRecombAction());
        this.plotHRecombButton.setBackground(this.getHRecombColor());
        this.setMargin(this.plotHRecombButton);
        this.plotHeRecombButton = new JButton("He Recomb");
        this.plotHeRecombButton.addActionListener(new PlotHeRecombAction());
        this.plotHeRecombButton.setBackground(this.getHeRecombColor());
        this.setMargin(this.plotHeRecombButton);
        this.printButton = new JButton("Print");
        this.printButton.addActionListener(new PrintAction());
        this.setMargin(this.printButton);
        this.refreshButton = new JButton("Clear Plot");
        this.refreshButton.addActionListener(new RefreshAction());
        this.setMargin(this.refreshButton);
        this.spaceLabel = new JLabel(" ");
    }

    public Color getFrequencyColor() {
        return Color.GREEN;
    }

    public Color getVelocityColor() {
        return Color.ORANGE;
    }

    public Color getVelocityColor(boolean b) {
        return b ? Color.ORANGE : null;
    }

    public Color getSlaimColor() {
        return Color.BLUE;
    }

    public Color getSplatalogueColor() {
        return Color.magenta;
    }

    public Color getHRecombColor() {
        return Color.PINK;
    }

    public Color getHeRecombColor() {
        return Color.YELLOW;
    }

    private void setProperties() {
        this.buttonMargin = new Insets(2, 5, 2, 5);
    }

    private void setMargin(AbstractButton button) {
        button.setMargin(this.buttonMargin);
    }
}

