/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.plot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ferris.astronomy.data.catalog.Catalog;
import org.ferris.astronomy.data.catalog.CatalogIterator;
import org.ferris.astronomy.data.catalog.CatalogList;
import org.ferris.astronomy.data.h.H;
import org.ferris.astronomy.data.he.HE;
import org.ferris.astronomy.data.intensity.IntensityStrategy;
import org.ferris.astronomy.data.sourcedata.SourceDataList;
import org.ferris.astronomy.data.splatalogue.Splatalogue;
import org.ferris.astronomy.data.telescope.TelescopeArrayType;
import org.ferris.losst.common.model.LosstModel;
import org.ferris.losst.common.result.ResultFrame;
import org.ferris.slise.data.source.MySourceBean;
import org.ferris.slise.jfree.chart.axis.SetNumberAxisRangeDialog;
import org.ferris.slise.jfree.chart.axis.SetNumberAxisRangeListener;
import org.ferris.slise.jfree.data.xy.SliseXYSeries;
import org.ferris.slise.jfree.data.xy.SliseXYSeriesCollection;
import org.ferris.slise.model.SliseModel;
import org.ferris.slise.plot.InputPanel;
import org.ferris.slise.plot.SourceDataResultFrame;
import org.ferris.slise.plot.SplatalogueResultFrame;
import org.ferris.slise.search.SlaimSearchDialog;
import org.ferris.slise.splatalogue.SelectedMolecule;
import org.ferris.slise.swing.SliseFrame;
import org.ferris.swing.ui.ThrowableDialog;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.ui.RectangleInsets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotFrame
extends SliseFrame {
    private static Logger log = Logger.getLogger(PlotFrame.class);
    private static final long serialVersionUID = -6406458821884319431L;
    private JFreeChart jfreechart;
    private XYPlot xyplot;
    private SliseXYSeriesCollection xyseriescollection;
    private XYItemRenderer xyrenderer;
    private XYLineAndShapeRenderer xylineandshaperenderer;
    private double[] searchRange;
    private double[] searchCenter;
    private ChartPanel chartPanel;
    private InputPanel inputPanel;
    private SliseModel sliseModel;
    private LosstModel losstModel;
    private List<MySourceBean> sources = new LinkedList<MySourceBean>();
    private double[] xAxisBounds;
    private double[] yAxisBounds;
    private TelescopeArrayType telescopeArrayType;
    private JPanel contentPanel;
    private double velocity;
    private double velocityRes;

    private void setSearchRange(double[] freqMinAndFreqMax) {
        this.searchCenter = null;
        this.searchRange = freqMinAndFreqMax;
    }

    private void setSearchCenter(double[] centerAndOffset) {
        this.searchRange = null;
        this.searchCenter = centerAndOffset;
    }

    public double getSearchFrequencyMin() {
        if (this.searchRange != null) {
            return this.searchRange[0];
        }
        return this.searchCenter[0] - this.searchCenter[1];
    }

    public double getSearchFrequencyMax() {
        if (this.searchRange != null) {
            return this.searchRange[1];
        }
        return this.searchCenter[0] + this.searchCenter[1];
    }

    private List<MySourceBean> getSources() {
        return this.sources;
    }

    private void setInputPanel() {
        this.inputPanel = new InputPanel(this);
    }

    private void setFrame() {
        this.setSize(600, 500);
        this.setLocation(50, 50);
        this.setDefaultCloseOperation(2);
        this.chartPanel = new ChartPanel(this.jfreechart);
        this.updatePopupMenu();
        this.getContentPanel().add((Component)this.chartPanel, "Center");
        this.getContentPanel().add((Component)this.inputPanel, "South");
        this.getContentPane().add((Component)this.getContentPanel(), "Center");
    }

    public JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel(new BorderLayout());
        }
        return this.contentPanel;
    }

    private void updatePopupMenu() {
        this.updatePopupMenuXAxis();
        this.updatePopupMenuYAxis();
    }

    private void updatePopupMenuXAxis() {
        JPopupMenu result = this.chartPanel.getPopupMenu();
        result.addSeparator();
        JMenu xAxis = new JMenu("X Axis");
        JMenuItem changeItem = new JMenuItem("Change");
        changeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SetNumberAxisRangeDialog d = new SetNumberAxisRangeDialog(PlotFrame.this);
                d.setTitle("Set X Axis");
                d.setSetNumberAxisRangeListener(new SetXAxis());
                d.setVisible(true);
            }
        });
        JMenuItem resetItem = new JMenuItem("Reset");
        resetItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotFrame.this.resetXAxis();
            }
        });
        xAxis.add(changeItem);
        xAxis.add(resetItem);
        result.add(xAxis);
    }

    private void updatePopupMenuYAxis() {
        JPopupMenu result = this.chartPanel.getPopupMenu();
        JMenu yAxis = new JMenu("Y Axis");
        JMenuItem changeItem = new JMenuItem("Change");
        changeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SetNumberAxisRangeDialog d = new SetNumberAxisRangeDialog(PlotFrame.this);
                d.setTitle("Set Y Axis");
                d.setSetNumberAxisRangeListener(new SetYAxis());
                d.setVisible(true);
            }
        });
        JMenuItem resetItem = new JMenuItem("Reset");
        resetItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotFrame.this.resetYAxis();
            }
        });
        yAxis.add(changeItem);
        yAxis.add(resetItem);
        result.add(yAxis);
    }

    public void clear() {
        this.xyseriescollection.removeAllSeries();
        this.inputPanel.clear();
        this.xAxisBounds = null;
        this.yAxisBounds = null;
        this.getSources().clear();
        this.setChartTitle("");
    }

    private String getXAxisLabel() {
        return "Frequency (MHz)";
    }

    private String getYAxisLabel() {
        return "";
    }

    private void setChart() {
        this.jfreechart = ChartFactory.createXYLineChart((String)"Title", (String)this.getXAxisLabel(), (String)this.getYAxisLabel(), (XYDataset)new SliseXYSeriesCollection(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.jfreechart.setBackgroundPaint((Paint)Color.white);
        this.jfreechart.removeLegend();
        this.xyplot = (XYPlot)this.jfreechart.getPlot();
        this.xyplot.setBackgroundPaint((Paint)Color.WHITE);
        this.xyplot.setDomainGridlinePaint((Paint)Color.GRAY);
        this.xyplot.setRangeGridlinePaint((Paint)Color.GRAY);
        this.xyplot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        this.xyseriescollection = (SliseXYSeriesCollection)this.xyplot.getDataset();
        this.xyrenderer = this.xyplot.getRenderer();
        this.xylineandshaperenderer = (XYLineAndShapeRenderer)this.xyplot.getRenderer();
        this.xylineandshaperenderer.setShapesVisible(false);
        NumberAxis numberaxis = (NumberAxis)this.xyplot.getRangeAxis();
        numberaxis.setStandardTickUnits(NumberAxis.createStandardTickUnits());
        numberaxis.setAutoRangeIncludesZero(false);
    }

    private void addVerticalLine(double x, Color c) {
        this.xyrenderer.setSeriesPaint(this.xyseriescollection.getSeriesCount(), (Paint)c);
        double min = this.xyseriescollection.getSeriesYMin();
        double max = this.xyseriescollection.getSeriesYMax();
        SliseXYSeries xyseries = new SliseXYSeries((Comparable)((Object)"line"));
        xyseries.add(x, min);
        xyseries.add(x, max);
        this.xyseriescollection.addSeries(xyseries);
    }

    private void addVerticalLine(double x, double y, Color c) {
        this.xyrenderer.setSeriesPaint(this.xyseriescollection.getSeriesCount(), (Paint)c);
        SliseXYSeries xyseries = new SliseXYSeries((Comparable)((Object)"line"));
        xyseries.add(x, 0.0);
        xyseries.add(x, y);
        this.xyseriescollection.addSeries(xyseries);
    }

    private void addChartSeries(SliseXYSeries xyseries, Color c) {
        this.xyrenderer.setSeriesPaint(this.xyseriescollection.getSeriesCount(), (Paint)c);
        this.xyseriescollection.addSeries(xyseries);
    }

    private void setChartCenter() {
        if (this.searchCenter != null) {
            this.addVerticalLine(this.searchCenter[0], Color.red);
        }
    }

    private void setChartTitle(String title) {
        this.jfreechart.setTitle(title);
    }

    private String getChartTitle() {
        return this.jfreechart.getTitle().getText();
    }

    private void setChartZoom() {
        this.chartPanel.restoreAutoBounds();
    }

    private void setSliseModel(SliseModel sliseModel) {
        this.sliseModel = sliseModel;
    }

    public SliseModel getSliseModel() {
        return this.sliseModel;
    }

    public void setLosstModel(LosstModel losstModel) {
        this.losstModel = losstModel;
    }

    private LosstModel getLosstModel() {
        return this.losstModel;
    }

    public PlotFrame(SliseModel sliseModel, LosstModel losstModel) {
        super("");
        this.setChart();
        this.setInputPanel();
        this.setFrame();
        this.setSliseModel(sliseModel);
        this.setLosstModel(losstModel);
    }

    public PlotFrame(SliseModel sliseModel, LosstModel losstModel, TelescopeArrayType telescopeArrayType) {
        this(sliseModel, losstModel);
        this.setTelescopeArrayType(telescopeArrayType);
    }

    private final String getTitle(MySourceBean source) {
        String title = source.getName();
        if (source.getTelescope() != null && source.getTelescope().getName() != null && source.getTelescope().getName().length() > 0) {
            title = String.valueOf(title) + " (" + source.getTelescope().getName() + ")";
        }
        return title;
    }

    private void addSourceAndSeries(Map<String, SourceDataList> map, MySourceBean source) {
        this.sources.add(source);
        Color color = null;
        switch (this.getSources().size()) {
            case 1: {
                color = Color.black;
                break;
            }
            case 2: {
                color = Color.orange;
                break;
            }
            case 3: {
                color = Color.green;
                break;
            }
            case 4: {
                color = Color.yellow;
                break;
            }
            case 5: {
                color = Color.magenta;
                break;
            }
            default: {
                color = Color.darkGray;
            }
        }
        this.xyrenderer.setSeriesPaint(this.getSources().size() - 1, (Paint)color);
        this.xyseriescollection.addSeries(map);
        StringBuilder sp = new StringBuilder();
        for (MySourceBean s : this.sources) {
            if (sp.length() > 0) {
                sp.append(", ");
            }
            sp.append(this.getTitle(s));
        }
        this.setChartTitle(sp.toString());
        this.setChartCenter();
        this.setTitle("Search Results");
        this.inputPanel.setFrequencyShiftEnabled(source.isUserDataSet());
        this.inputPanel.setVelocityEnabled(this.searchCenter != null);
    }

    public void plot(double[] range, double[] center, Map<String, SourceDataList> sourceData, MySourceBean source) {
        if (range != null) {
            this.plotRange(sourceData, range, source);
        } else if (center != null) {
            this.plotCenter(sourceData, center, source);
        } else {
            new ThrowableDialog((Throwable)new Exception("Why are both double[] range and double[] center null??"), true);
        }
    }

    public void plot(Map<String, SourceDataList> map, double[] freqMinAndFreqMax, double vel, double velRes, MySourceBean source) {
        this.plotRange(map, freqMinAndFreqMax, vel, velRes, source);
    }

    private void plotRange(Map<String, SourceDataList> map, double[] freqMinAndFreqMax, double vel, double velRes, MySourceBean source) {
        this.setSearchRange(freqMinAndFreqMax);
        this.velocity = vel;
        this.velocityRes = velRes;
        System.out.println(String.valueOf(vel) + " " + velRes);
        this.addSourceAndSeries(map, source);
    }

    private void plotRange(Map<String, SourceDataList> map, double[] freqMinAndFreqMax, MySourceBean source) {
        this.plotRange(map, freqMinAndFreqMax, 0.0, 0.03, source);
    }

    private void plotCenter(Map<String, SourceDataList> map, double[] centerAndOffset, MySourceBean source) {
        this.setSearchCenter(centerAndOffset);
        this.addSourceAndSeries(map, source);
    }

    public void searchSlaim() {
        SlaimSearchDialog dia = new SlaimSearchDialog(this, this.getLosstModel(), "Slaim Search: " + this.getChartTitle(), this.searchRange, this.searchCenter);
        dia.setVisible(true);
    }

    public void plotSlaim(CatalogList matches) {
        try {
            CatalogIterator itr = matches.getIterator();
            while (itr.hasNext()) {
                Catalog cat = (Catalog)itr.next();
                this.addVerticalLine(cat.getFrequency(), this.inputPanel.getSlaimColor());
            }
            ResultFrame slaimResults = new ResultFrame("Slaim Overlap: " + this.getChartTitle(), 3000);
            slaimResults.display(matches);
            slaimResults.setVisible(true);
            slaimResults.toFront();
        }
        catch (Exception e) {
            e.printStackTrace();
            new ThrowableDialog((Throwable)e, true);
        }
    }

    public void plotSplatalogue(double freqMin, double freqMax, List<SelectedMolecule> selectedMolecules) {
        try {
            log.info((Object)"Remove old series");
            LinkedList<XYSeries> toRemove = new LinkedList<XYSeries>();
            for (XYSeries series : this.xyseriescollection.getSeries()) {
                boolean b;
                Comparable key = series.getKey();
                if (key == null) continue;
                String skey = key.toString();
                boolean bl = b = skey.startsWith("line") || skey.startsWith("Splatalogue-g");
                if (!b) continue;
                toRemove.add(series);
            }
            for (XYSeries series : toRemove) {
                this.xyseriescollection.removeSeries(series);
            }
            log.info((Object)"Gather species ids");
            ArrayList<String> speciesIds = new ArrayList<String>(selectedMolecules.size());
            for (SelectedMolecule molecule : selectedMolecules) {
                speciesIds.add(molecule.getMolecule().getId());
            }
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            int index = 0;
            for (SelectedMolecule molecule : selectedMolecules) {
                String id = molecule.getMolecule().getId().toString();
                if (map.get(id) == null) {
                    Integer i = new Integer(index);
                    ++index;
                    map.put(id, i);
                    System.out.println(String.valueOf(id) + " isn't ");
                    continue;
                }
                System.out.println(String.valueOf(id) + " is ");
            }
            log.info((Object)"Call web service to get splat data");
            List<Splatalogue> matches = this.getSliseModel().getSplatalogueData(freqMin, freqMax, speciesIds);
            if (matches.size() == 0) {
                JOptionPane.showMessageDialog(this, "No overlapping splatalogue data found.");
                return;
            }
            log.info((Object)"Set intensity strategy for results");
            for (Splatalogue splatalogue : matches) {
                int ind = (Integer)map.get(splatalogue.getMolecule().getId());
                splatalogue.setIntensityStrategy((IntensityStrategy)new IntensityStrategyForCH30Hv0(splatalogue, selectedMolecules.get(ind)));
                log.info((Object)("Intensity: " + splatalogue.getIntensity()));
            }
            double light = 3.0 * Math.pow(10.0, 5.0);
            double lsr = this.velocity;
            double center = (freqMin + freqMax) / 2.0;
            log.info((Object)"Add vertical line for each result");
            for (Splatalogue splatalogue : matches) {
                double frequency = splatalogue.getFrequency().doubleValue();
                double vel = lsr - (frequency - center) / center * light;
                this.addVerticalLine(vel, splatalogue.getIntensity().doubleValue(), this.inputPanel.getSplatalogueColor());
            }
            log.info((Object)"Gaussian preparation");
            double Upper = lsr - (freqMin - center) / center * light;
            double Lower = lsr - (freqMax - center) / center * light;
            NumberAxis domainAxis = (NumberAxis)this.xyplot.getDomainAxis();
            double step = 0.03;
            double upper = Upper;
            double lower = Lower;
            log.info((Object)("upper: " + upper));
            log.info((Object)("lower: " + lower));
            log.info((Object)("step:  " + step));
            int c = 0;
            log.info((Object)"Gaussian plot");
            for (String id : speciesIds) {
                log.info((Object)("c:" + c + " specieId:" + id));
                Random rand = new Random();
                int randi = rand.nextInt();
                SliseXYSeries xyseries = new SliseXYSeries((Comparable)((Object)("Splatalogue-guassian " + randi)));
                int i = 0;
                while (lower < upper) {
                    Guassian g = null;
                    for (Splatalogue splatalogue : matches) {
                        if (!id.equals(splatalogue.getMolecule().getId())) continue;
                        double frequency = splatalogue.getFrequency().doubleValue();
                        double vel = lsr - (frequency - center) / center * light;
                        Guassian gg = new Guassian(splatalogue.getIntensity().doubleValue(), vel, selectedMolecules.get(c).getLineWidth().doubleValue(), lower);
                        g = g == null ? gg : g.add(gg);
                    }
                    if (g != null) {
                        xyseries.add(lower, g.getValue());
                    }
                    ++i;
                    lower += step;
                }
                lower = Lower;
                this.addChartSeries(xyseries, this.inputPanel.getSplatalogueColor());
                ++c;
            }
            SplatalogueResultFrame splatalogueResults = new SplatalogueResultFrame("Splatalogue Overlap: " + this.getChartTitle());
            splatalogueResults.display(matches);
            splatalogueResults.setVisible(true);
            splatalogueResults.toFront();
        }
        catch (Exception e) {
            e.printStackTrace();
            new ThrowableDialog((Throwable)e, false);
        }
    }

    public TelescopeArrayType getTelescopeArrayType() {
        return this.telescopeArrayType;
    }

    private void setTelescopeArrayType(TelescopeArrayType type) {
        this.telescopeArrayType = type;
    }

    public void plotHRecomb() {
        try {
            double xmin = this.xyseriescollection.getSeriesXMin();
            double xmax = this.xyseriescollection.getSeriesXMax();
            List matches = this.getSliseModel().getHRecombData(xmin, xmax);
            if (matches.size() == 0) {
                JOptionPane.showMessageDialog(this, "No overlapping H data found.");
                return;
            }
            for (H di : matches) {
                this.addVerticalLine(di.getFrequency().doubleValue(), this.inputPanel.getHRecombColor());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            new ThrowableDialog((Throwable)e, true);
        }
    }

    public void plotHeRecomb() {
        try {
            double xmin = this.xyseriescollection.getSeriesXMin();
            double xmax = this.xyseriescollection.getSeriesXMax();
            List matches = this.getSliseModel().getHERecombData(xmin, xmax);
            if (matches.size() == 0) {
                JOptionPane.showMessageDialog(this, "No overlapping He data found.");
                return;
            }
            for (HE di : matches) {
                this.addVerticalLine(di.getFrequency().doubleValue(), this.inputPanel.getHeRecombColor());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            new ThrowableDialog((Throwable)e, true);
        }
    }

    public void plotFrequency(double frequency) {
        this.addVerticalLine(frequency, this.inputPanel.getFrequencyColor());
    }

    public void plotVelocity(double velocity) {
        for (MySourceBean source : this.getSources()) {
            this.addVerticalLine(source.getCalculatedVelocity(velocity, this.searchCenter[0]).doubleValue(), this.inputPanel.getVelocityColor());
        }
    }

    public void showDataPoints() {
        LinkedList<String> lines = new LinkedList<String>();
        Map<String, SliseXYSeries> map = this.xyseriescollection.getSourceDataSeries();
        if (map.isEmpty()) {
            for (XYSeries series : this.xyseriescollection.getSeries()) {
                String skey;
                boolean b;
                Comparable key = series.getKey();
                if (key == null || !(b = (skey = key.toString()).startsWith("Splatalogue-g"))) continue;
                map = new HashMap<String, SliseXYSeries>();
                map.put("", (SliseXYSeries)series);
            }
        }
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String obj;
            String band = obj = iterator.next();
            for (XYDataItem item : ((XYSeries)map.get(band)).getItems()) {
                lines.add(String.valueOf(StringUtils.rightPad((String)("" + item.getX()), (int)15, (char)' ')) + "  " + StringUtils.rightPad((String)("" + item.getY()), (int)15, (char)' ') + "  " + StringUtils.rightPad((String)String.valueOf(band), (int)15, (char)' '));
            }
        }
        SourceDataResultFrame sourceResults = new SourceDataResultFrame("Data Points: " + this.getChartTitle(), this.xyplot.getDomainAxis().getLabel(), this.xyplot.getRangeAxis().getLabel(), "Band");
        sourceResults.setIconImage(this.getIconImage());
        sourceResults.display(lines);
        sourceResults.setVisible(true);
        sourceResults.toFront();
    }

    public void print() {
        this.chartPanel.createChartPrintJob();
    }

    public void refresh() {
        this.xyseriescollection.refresh();
        this.setChartCenter();
        this.chartPanel.restoreAutoBounds();
    }

    public void setFrequencyShift(double d) {
        this.xyseriescollection.refreshWithFrequencyShift(d);
        this.chartPanel.restoreAutoBounds();
    }

    public void resetXAxis() {
        if (this.xAxisBounds != null) {
            NumberAxis domainAxis = (NumberAxis)this.xyplot.getDomainAxis();
            domainAxis.setRange(this.xAxisBounds[0], this.xAxisBounds[1]);
            this.xAxisBounds = null;
        }
    }

    public void resetYAxis() {
        if (this.yAxisBounds != null) {
            NumberAxis domainAxis = (NumberAxis)this.xyplot.getRangeAxis();
            domainAxis.setRange(this.yAxisBounds[0], this.yAxisBounds[1]);
            this.yAxisBounds = null;
        }
    }

    public boolean isVelocityEnabled() {
        return this.searchCenter != null;
    }

    public boolean isFrequencyShiftEnabled() {
        return this.inputPanel.isFrequencyShiftEnabled();
    }

    class Guassian {
        private double value;

        public Guassian(double _intensity, double _velocity, double _lineWidth, double _frequency) {
            double numerator = _frequency - _velocity;
            double denominator = _lineWidth / 1.665;
            double q = numerator / denominator;
            double exponent = -1.0 * Math.pow(q, 2.0);
            double unnorm = Math.exp(exponent);
            this.value = _intensity * unnorm;
        }

        private Guassian() {
        }

        public double getValue() {
            return this.value;
        }

        public Guassian add(Guassian g) {
            Guassian add = new Guassian();
            add.value = this.value + g.getValue();
            return add;
        }
    }

    class IntensityStrategyForCH30Hv0
    implements IntensityStrategy {
        private Splatalogue splatalogue;
        private SelectedMolecule selectedMolecule;

        public IntensityStrategyForCH30Hv0(Splatalogue splatalogue, SelectedMolecule selectedMolecule) {
            this.splatalogue = splatalogue;
            this.selectedMolecule = selectedMolecule;
        }

        public BigDecimal getIntensity() {
            BigDecimal zero = null;
            double temperature = 0.0;
            if (this.selectedMolecule.getTemperature() != null) {
                temperature = this.selectedMolecule.getTemperature().doubleValue();
            } else {
                zero = BigDecimal.ZERO;
            }
            double columnDensity = 0.0;
            if (this.selectedMolecule.getColumnDensity() != null) {
                columnDensity = this.selectedMolecule.getColumnDensity().doubleValue();
            } else {
                zero = BigDecimal.ZERO;
            }
            double lineWidth = 0.0;
            if (this.selectedMolecule.getLineWidth() != null) {
                lineWidth = this.selectedMolecule.getLineWidth().doubleValue();
            } else {
                zero = BigDecimal.ZERO;
            }
            double thetaA = 0.0;
            if (this.selectedMolecule.getThetaA() != null) {
                thetaA = this.selectedMolecule.getThetaA().doubleValue();
            } else {
                zero = BigDecimal.ZERO;
            }
            double thetaB = 0.0;
            if (this.selectedMolecule.getThetaB() != null) {
                thetaB = this.selectedMolecule.getThetaB().doubleValue();
            } else {
                zero = BigDecimal.ZERO;
            }
            double b = 0.0;
            if (this.selectedMolecule.getB() != null) {
                b = this.selectedMolecule.getB().doubleValue();
            } else {
                zero = BigDecimal.ZERO;
            }
            double freq = 0.0;
            if (this.splatalogue.getFrequency() != null) {
                freq = this.splatalogue.getFrequency().doubleValue() / 1000.0;
            } else {
                zero = BigDecimal.ZERO;
            }
            double eupper = 0.0;
            if (this.splatalogue.getEUpper() != null) {
                eupper = this.splatalogue.getEUpper().doubleValue();
            } else {
                zero = BigDecimal.ZERO;
            }
            double sij = 0.0;
            if (this.splatalogue.getSij() != null) {
                sij = this.splatalogue.getSij().doubleValue();
            } else {
                zero = BigDecimal.ZERO;
            }
            double qc = 0.0;
            if (this.splatalogue.getQc() != null) {
                qc = this.splatalogue.getQc().doubleValue();
            } else {
                zero = BigDecimal.ZERO;
            }
            double qe = 0.0;
            if (this.splatalogue.getQe() != null) {
                qe = this.splatalogue.getQe().doubleValue();
            } else {
                zero = BigDecimal.ZERO;
            }
            if (zero != null) {
                return zero;
            }
            double[] terms = new double[]{8.19672, new BigDecimal("1e-21").doubleValue(), b, Math.pow(Math.E, -1.0 * eupper / temperature), Math.pow(freq, 3.0), columnDensity, thetaA, thetaB, sij};
            double numerator = 1.0;
            int i = 0;
            while (i < terms.length) {
                numerator *= terms[i];
                ++i;
            }
            double denominator = qc * Math.pow(temperature, qe);
            double arg = numerator / denominator;
            return new BigDecimal(arg);
        }
    }

    class SetXAxis
    implements SetNumberAxisRangeListener {
        SetXAxis() {
        }

        public void setRange(double lower, double upper) {
            NumberAxis domainAxis = (NumberAxis)PlotFrame.this.xyplot.getDomainAxis();
            if (PlotFrame.this.xAxisBounds == null) {
                Range range = domainAxis.getRange();
                PlotFrame.this.xAxisBounds = new double[2];
                ((PlotFrame)PlotFrame.this).xAxisBounds[0] = range.getLowerBound();
                ((PlotFrame)PlotFrame.this).xAxisBounds[1] = range.getUpperBound();
            }
            domainAxis.setRange(lower, upper);
        }
    }

    class SetYAxis
    implements SetNumberAxisRangeListener {
        SetYAxis() {
        }

        public void setRange(double lower, double upper) {
            NumberAxis domainAxis = (NumberAxis)PlotFrame.this.xyplot.getRangeAxis();
            if (PlotFrame.this.yAxisBounds == null) {
                Range range = domainAxis.getRange();
                PlotFrame.this.yAxisBounds = new double[2];
                ((PlotFrame)PlotFrame.this).yAxisBounds[0] = range.getLowerBound();
                ((PlotFrame)PlotFrame.this).yAxisBounds[1] = range.getUpperBound();
            }
            domainAxis.setRange(lower, upper);
        }
    }
}

