/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.plot.action;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.ferris.astronomy.math.BigDecimalTools;
import org.ferris.slise.plot.PlotFrame;
import org.ferris.swing.ui.ThrowableDialog;

public abstract class PlotFrameAction
implements ActionListener {
    private PlotFrame frame;

    public PlotFrameAction() {
    }

    public PlotFrameAction(PlotFrame frame) {
        this();
        this.frame = frame;
    }

    public abstract void actionPerformed(PlotFrame var1);

    public void actionPerformed(ActionEvent e) {
        if (this.frame == null) {
            this.frame = this.getPlotFrame(e);
        }
        this.actionPerformed(this.frame);
    }

    private PlotFrame getPlotFrame(ActionEvent e) {
        Container cont = this.getContainer(this.getJComponent(this.getSource(e)));
        if (!(cont instanceof PlotFrame)) {
            new ThrowableDialog((Throwable)new Exception("getTopLevelAncester() is not the right class: \"" + cont.getClass().getName() + "\""), true);
        }
        return (PlotFrame)cont;
    }

    private Container getContainer(JComponent comp) {
        Container c = comp.getTopLevelAncestor();
        if (c == null) {
            new ThrowableDialog((Throwable)new Exception("getTopLevelAncester() is null"), true);
        }
        return c;
    }

    private JComponent getJComponent(Object o) {
        if (!(o instanceof JComponent)) {
            new ThrowableDialog((Throwable)new Exception("Not a JComponent: \"" + o.getClass().getName() + "\""), true);
        }
        return (JComponent)o;
    }

    private Object getSource(ActionEvent e) {
        Object o = e.getSource();
        if (o == null) {
            new ThrowableDialog((Throwable)new Exception("ActionEvent.getSource() is null"), true);
        }
        return o;
    }

    protected List getBigDecimals(Component parent, JTextField txtField) {
        LinkedList<BigDecimal> bdList = new LinkedList<BigDecimal>();
        txtField.setText(txtField.getText().trim());
        if (txtField.getText().length() > 0) {
            StringTokenizer tokens = new StringTokenizer(txtField.getText(), ",");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                if (token.length() <= 0) continue;
                try {
                    bdList.add(BigDecimalTools.getBigDecimal((String)token));
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(parent, String.valueOf(token) + " is not numeric.", "Input error", 0);
                    bdList.clear();
                    break;
                }
            }
        }
        return bdList;
    }
}

