/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.plot.action;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import org.ferris.astronomy.data.telescope.TelescopeArrayType;
import org.ferris.slise.plot.PlotFrame;
import org.ferris.slise.splatalogue.ArrayOrSingleDishDialog;
import org.ferris.slise.splatalogue.PlotItEvent;
import org.ferris.slise.splatalogue.PlotItListener;
import org.ferris.slise.splatalogue.SplatalogueSearchDialog;
import org.ferris.swing.event.DisableAllAndExecuteActionListener;
import org.ferris.swing.ui.ThrowableDialog;

public class PlotSplatalogueAction
extends DisableAllAndExecuteActionListener {
    private PlotFrame frame;

    public PlotSplatalogueAction(PlotFrame frame) {
        super((Container)frame.getContentPanel(), (JComponent)frame.getContentPanel());
        this.frame = frame;
    }

    public void execute(ActionEvent evnt) {
        try {
            Window dialog;
            TelescopeArrayType myType = null;
            if (this.frame.getTelescopeArrayType() == null) {
                dialog = new ArrayOrSingleDishDialog((Frame)this.frame, this.frame.getSliseModel());
                ((Dialog)dialog).setVisible(true);
                myType = ((ArrayOrSingleDishDialog)dialog).getTelescopeArrayType();
            } else {
                myType = this.frame.getTelescopeArrayType();
            }
            if (myType == null) {
                return;
            }
            System.out.println("Got telescope array type: " + myType.getDescription());
            dialog = new SplatalogueSearchDialog(this.frame, this.frame.getSliseModel().getMoleculesAvailable(), new Double(this.frame.getSearchFrequencyMin()), new Double(this.frame.getSearchFrequencyMax()), myType);
            ((SplatalogueSearchDialog)dialog).addPlotItListener(new MyPlotItListener(this.frame));
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            new ThrowableDialog((Throwable)e, false);
        }
    }

    private class MyPlotItListener
    implements PlotItListener {
        private PlotFrame frame;

        private MyPlotItListener(PlotFrame frame) {
            this.frame = frame;
        }

        public void plotIt(PlotItEvent event) {
            this.frame.plotSplatalogue(event.getFreqMin(), event.getFreqMax(), event.getSelectedMolecules());
        }
    }
}

