/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FilePermission;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.ferris.astronomy.data.source.Source;
import org.ferris.astronomy.data.sourcedata.SourceDataList;
import org.ferris.losst.common.model.LosstModel;
import org.ferris.losst.common.search.FrequencySearchCriteriaPanel;
import org.ferris.slise.about.AboutDialog;
import org.ferris.slise.data.source.MySourceBean;
import org.ferris.slise.model.SliseModel;
import org.ferris.slise.plot.PlotFrame;
import org.ferris.slise.search.SearchFrameErrors;
import org.ferris.slise.search.SourcesList;
import org.ferris.slise.search.TelescopesTable;
import org.ferris.slise.source.AddSourceDialog;
import org.ferris.slise.source.SourceSelectedEvent;
import org.ferris.slise.source.SourceSelectedListener;
import org.ferris.slise.swing.SliseFrame;
import org.ferris.slise.version.Version;
import org.ferris.swing.event.DisableAllAndExecuteActionListener;
import org.ferris.swing.ui.ThrowableDialog;

public class SearchFrame
extends SliseFrame {
    private static final Logger log = Logger.getLogger(SearchFrame.class);
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel searchCriteriaPanel = null;
    private JLabel sourceSpacerLabel = null;
    private JLabel sourceLabel = null;
    private SourcesList sourcesList = null;
    private JLabel telescopSpacerLabel = null;
    private JLabel telescopeLabel = null;
    private JLabel frequencySpacerLabel = null;
    private JLabel frequencyLabel = null;
    private TelescopesTable telescopesTable = null;
    private JPanel sourceTablePanel = null;
    private JScrollPane sourceTableScrollPane = null;
    private JScrollPane sourcesListScrollPane = null;
    private FrequencySearchCriteriaPanel freqSearchCriteriaPanel = null;
    private JPanel buttonPanel = null;
    private JButton searchButton = null;
    private JButton searchNewButton = null;
    private SliseModel sliseModel = null;
    private MyActions myActions = null;
    private JMenuBar jJMenuBar = null;
    private JMenu fileMenu = null;
    private JMenuItem exitMenuItem = null;
    private JMenu helpMenu = null;
    private JMenuItem aboutMenuItem = null;
    private SearchFrameErrors errors = null;
    private JButton addSourceButton = null;
    private LosstModel losstModel;
    private JPanel sourcesLabelPanel = null;

    public SearchFrame(SliseModel sliseModel, LosstModel losstModel) {
        this.sliseModel = sliseModel;
        this.losstModel = losstModel;
        this.myActions = new MyActions();
        this.initialize();
        this.myActions.setComponent(this.getSearchCriteriaPanel());
        this.myActions.setContainer(this.getSearchCriteriaPanel());
        super.setSize(644, super.getSize().height);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        super.setLocation((int)((d.getWidth() - (double)super.getWidth()) / 2.0), (int)((d.getHeight() - (double)super.getHeight()) / 2.0));
    }

    private void initialize() {
        this.setSize(644, 350);
        this.setJMenuBar(this.getJJMenuBar());
        this.setContentPane(this.getJContentPane());
        this.errors = new SearchFrameErrors(this);
        this.setTitle("Spectrum Line Search Engine (SLiSE) v" + new Version().getVersion());
        this.setDefaultCloseOperation(3);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getSearchCriteriaPanel(), "North");
        }
        return this.jContentPane;
    }

    public JPanel getSearchCriteriaPanel() {
        if (this.searchCriteriaPanel == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.anchor = 12;
            gridBagConstraints14.fill = 0;
            gridBagConstraints14.weighty = 1.0;
            gridBagConstraints14.gridy = 1;
            GridBagConstraints gridBagConstraints131 = new GridBagConstraints();
            gridBagConstraints131.gridx = 0;
            gridBagConstraints131.gridwidth = 3;
            gridBagConstraints131.fill = 2;
            gridBagConstraints131.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints131.gridy = 6;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 1;
            gridBagConstraints12.anchor = 17;
            gridBagConstraints12.fill = 0;
            gridBagConstraints12.gridy = 5;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.anchor = 18;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints11.gridwidth = 1;
            gridBagConstraints11.gridy = 3;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints8.anchor = 12;
            gridBagConstraints8.gridy = 5;
            this.frequencyLabel = new JLabel();
            this.frequencyLabel.setText("Frequency (MHz) :");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 4;
            this.frequencySpacerLabel = new JLabel();
            this.frequencySpacerLabel.setText("     ");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.anchor = 12;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 3;
            gridBagConstraints5.insets = new Insets(0, 5, 0, 5);
            this.telescopeLabel = new JLabel();
            this.telescopeLabel.setText("Telescopes : ");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 2;
            this.telescopSpacerLabel = new JLabel();
            this.telescopSpacerLabel.setText("     ");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.fill = 1;
            this.sourceLabel = new JLabel();
            this.sourceLabel.setText("Sources :");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.sourceSpacerLabel = new JLabel();
            this.sourceSpacerLabel.setText("     ");
            this.searchCriteriaPanel = new JPanel();
            this.searchCriteriaPanel.setLayout(new GridBagLayout());
            this.searchCriteriaPanel.add((Component)this.sourceSpacerLabel, gridBagConstraints);
            this.searchCriteriaPanel.add((Component)this.getSourcesListScrollPane(), gridBagConstraints2);
            this.searchCriteriaPanel.add((Component)this.telescopSpacerLabel, gridBagConstraints4);
            this.searchCriteriaPanel.add((Component)this.telescopeLabel, gridBagConstraints5);
            this.searchCriteriaPanel.add((Component)this.frequencySpacerLabel, gridBagConstraints7);
            this.searchCriteriaPanel.add((Component)this.frequencyLabel, gridBagConstraints8);
            this.searchCriteriaPanel.add((Component)this.getSourceTablePanel(), gridBagConstraints11);
            this.searchCriteriaPanel.add((Component)this.getFreqSearchCriteriaPanel(), gridBagConstraints12);
            this.searchCriteriaPanel.add((Component)this.getButtonPanel(), gridBagConstraints131);
            this.searchCriteriaPanel.add((Component)this.getSourcesLabelPanel(), gridBagConstraints14);
        }
        return this.searchCriteriaPanel;
    }

    public SourcesList getSourcesList() {
        if (this.sourcesList == null) {
            try {
                this.sourcesList = new SourcesList(this.sliseModel.getSourceList());
                this.sourcesList.addListSelectionListener(this.myActions);
            }
            catch (Throwable e) {
                new ThrowableDialog(e, true);
            }
        }
        return this.sourcesList;
    }

    public TelescopesTable getTelescopesTable() {
        if (this.telescopesTable == null) {
            this.telescopesTable = new TelescopesTable(this.getSourcesList().getAllSources());
            this.telescopesTable.setSources(new Source[]{this.getSourcesList().getSelectedSource()});
        }
        return this.telescopesTable;
    }

    private JPanel getSourceTablePanel() {
        if (this.sourceTablePanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            this.sourceTablePanel = new JPanel();
            this.sourceTablePanel.setLayout(new GridBagLayout());
            this.sourceTablePanel.add((Component)this.getSourceTableScrollPane(), gridBagConstraints3);
        }
        return this.sourceTablePanel;
    }

    private JScrollPane getSourceTableScrollPane() {
        if (this.sourceTableScrollPane == null) {
            this.sourceTableScrollPane = new JScrollPane();
            this.sourceTableScrollPane.setPreferredSize(new Dimension(200, 80));
            this.sourceTableScrollPane.setViewportView(this.getTelescopesTable());
        }
        return this.sourceTableScrollPane;
    }

    private JScrollPane getSourcesListScrollPane() {
        if (this.sourcesListScrollPane == null) {
            this.sourcesListScrollPane = new JScrollPane();
            this.sourcesListScrollPane.setViewportView(this.getSourcesList());
        }
        return this.sourcesListScrollPane;
    }

    private FrequencySearchCriteriaPanel getFreqSearchCriteriaPanel() {
        if (this.freqSearchCriteriaPanel == null) {
            this.freqSearchCriteriaPanel = new FrequencySearchCriteriaPanel();
            this.freqSearchCriteriaPanel.getMhzBtn().setSelected(true);
        }
        return this.freqSearchCriteriaPanel;
    }

    public JRadioButton getMhzRadioButton() {
        return this.getFreqSearchCriteriaPanel().getMhzBtn();
    }

    public JRadioButton getGhzRadioButton() {
        return this.getFreqSearchCriteriaPanel().getGhzBtn();
    }

    public JTextField getFreqMinText() {
        return this.getFreqSearchCriteriaPanel().getFreqMinText();
    }

    public JTextField getFreqCenterText() {
        return this.getFreqSearchCriteriaPanel().getFreqCenterText();
    }

    public JTextField getFreqMaxText() {
        return this.getFreqSearchCriteriaPanel().getFreqMaxText();
    }

    public JTextField getFreqPlusMinusText() {
        return this.getFreqSearchCriteriaPanel().getFreqPlusMinusText();
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setVgap(10);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setBorder(new SoftBevelBorder(0));
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.add((Component)this.getSearchButton(), null);
            this.buttonPanel.add((Component)this.getSearchNewButton(), null);
        }
        return this.buttonPanel;
    }

    public JButton getSearchButton() {
        if (this.searchButton == null) {
            this.searchButton = new JButton();
            this.searchButton.setActionCommand("search");
            this.searchButton.setText("Search");
            this.searchButton.addActionListener((ActionListener)((Object)this.myActions));
            this.getRootPane().setDefaultButton(this.searchButton);
        }
        return this.searchButton;
    }

    private JButton getSearchNewButton() {
        if (this.searchNewButton == null) {
            this.searchNewButton = new JButton();
            this.searchNewButton.setActionCommand("searchNew");
            this.searchNewButton.setText("Search (New Window)");
            this.searchNewButton.addActionListener((ActionListener)((Object)this.myActions));
        }
        return this.searchNewButton;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFileMenu());
            this.jJMenuBar.add(this.getHelpMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getExitMenuItem());
        }
        return this.fileMenu;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText("Exit");
            this.exitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        return this.exitMenuItem;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.add(this.getAboutMenuItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText("About");
            this.aboutMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new AboutDialog(SearchFrame.this).setVisible(true);
                }
            });
        }
        return this.aboutMenuItem;
    }

    private JButton getAddSourceButton() {
        if (this.addSourceButton == null) {
            this.addSourceButton = new JButton();
            this.addSourceButton.setText("Add Source");
            this.addSourceButton.setActionCommand("addSource");
            this.addSourceButton.addActionListener((ActionListener)((Object)this.myActions));
            this.addSourceButton.setEnabled(this.isAddSourceButtonEnabled());
        }
        return this.addSourceButton;
    }

    private boolean isAddSourceButtonEnabled() {
        boolean ret = false;
        SecurityManager security = System.getSecurityManager();
        if (security == null) {
            ret = true;
        } else {
            try {
                security.checkPermission(new FilePermission("<<ALL FILES>>", "read"));
                ret = true;
            }
            catch (SecurityException e) {
                ret = false;
            }
            catch (Throwable t) {
                new ThrowableDialog(t, true);
            }
        }
        return ret;
    }

    private JPanel getSourcesLabelPanel() {
        if (this.sourcesLabelPanel == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.insets = new Insets(10, 0, 0, 5);
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.anchor = 12;
            gridBagConstraints6.gridx = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.anchor = 12;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.fill = 0;
            gridBagConstraints1.insets = new Insets(0, 5, 0, 5);
            this.sourcesLabelPanel = new JPanel();
            this.sourcesLabelPanel.setLayout(new GridBagLayout());
            this.sourcesLabelPanel.add((Component)this.sourceLabel, gridBagConstraints1);
            this.sourcesLabelPanel.add((Component)this.getAddSourceButton(), gridBagConstraints6);
        }
        return this.sourcesLabelPanel;
    }

    class MyActions
    extends DisableAllAndExecuteActionListener
    implements ListSelectionListener {
        private PlotFrame snoopy;

        MyActions() {
        }

        private void sourcesListChanged() {
            SourcesList cb = SearchFrame.this.getSourcesList();
            Source[] sources = cb.getSelectedSources();
            TelescopesTable table = SearchFrame.this.getTelescopesTable();
            table.setSources(sources);
        }

        public void sourcesListChanged(Source s) {
            SourcesList cb = SearchFrame.this.getSourcesList();
            cb.addSource(s);
            this.sourcesListChanged();
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource().getClass().equals(SourcesList.class)) {
                this.sourcesListChanged();
            }
        }

        public void execute(ActionEvent evnt) {
            if (evnt.getActionCommand() == null) {
                new ThrowableDialog((Throwable)new Exception("Action command is NULL."), true);
            } else if ("addSource".equals(evnt.getActionCommand())) {
                super.restore();
                new AddSourceDialog(null, new MySourceSelectedListener());
            } else if ("search".equals(evnt.getActionCommand()) || "searchNew".equals(evnt.getActionCommand())) {
                SearchFrame.this.errors.clear();
                SearchFrame.this.errors.setErrors();
                if (!SearchFrame.this.errors.isEmpty()) {
                    SearchFrame.this.errors.displayText();
                } else {
                    double min = SearchFrame.this.getFreqSearchCriteriaPanel().getFreqMin();
                    double max = SearchFrame.this.getFreqSearchCriteriaPanel().getFreqMax();
                    double[] range = null;
                    double[] center = null;
                    if (SearchFrame.this.getFreqSearchCriteriaPanel().isCenter()) {
                        center = SearchFrame.this.getFreqSearchCriteriaPanel().getCenterInput();
                    } else {
                        range = SearchFrame.this.getFreqSearchCriteriaPanel().getRangeInput();
                    }
                    MySourceBean[] sources = SearchFrame.this.getTelescopesTable().getSelectedSources();
                    System.out.println("MIN: " + min);
                    System.out.println("MAX: " + max);
                    System.out.println("CENTER: " + SearchFrame.this.getFreqSearchCriteriaPanel().isCenter());
                    System.out.println("SOURCES: " + Arrays.asList(sources));
                    int totalMatches = 0;
                    PlotFrame p = this.getPlotFrame(evnt);
                    p.clear();
                    int i = 0;
                    while (i < sources.length) {
                        MySourceBean source = sources[i];
                        Map<String, SourceDataList> map = null;
                        try {
                            if (source.isUserDataSet()) {
                                map = SearchFrame.this.sliseModel.getUserSourceDataMap(min, max, (Source)source);
                                for (List list : map.values()) {
                                    if (list != null) continue;
                                    throw new RuntimeException("Why did model.getUserSourceDataList() return null?");
                                }
                            } else {
                                map = SearchFrame.this.sliseModel.getSourceDataMap(min, max, (Source)source);
                                for (List list : map.values()) {
                                    if (list != null) continue;
                                    throw new RuntimeException("Why did model.getSourceDataList() return null?");
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            new ThrowableDialog(throwable, true);
                        }
                        for (List list : map.values()) {
                            totalMatches += list.size();
                        }
                        p.plot(range, center, map, source);
                        ++i;
                    }
                    if (totalMatches == 0) {
                        JOptionPane.showMessageDialog(SearchFrame.this, "No matches found.", "No Matches", 1);
                    } else {
                        p.setVisible(true);
                    }
                }
            }
        }

        public PlotFrame getPlotFrame(ActionEvent evnt) {
            PlotFrame retval = null;
            if ("searchNew".equals(evnt.getActionCommand())) {
                retval = new PlotFrame(SearchFrame.this.sliseModel, SearchFrame.this.losstModel);
            } else {
                if (this.snoopy == null) {
                    this.snoopy = new PlotFrame(SearchFrame.this.sliseModel, SearchFrame.this.losstModel);
                }
                retval = this.snoopy;
            }
            return retval;
        }
    }

    class MySourceSelectedListener
    implements SourceSelectedListener {
        MySourceSelectedListener() {
        }

        public void addSource(SourceSelectedEvent evnt) {
            System.out.println("Adding user data source");
            Source source = this.getSource(evnt);
            boolean ok = this.errorCheckSource(source);
            if (ok) {
                SearchFrame.this.myActions.sourcesListChanged(source);
            }
        }

        private boolean errorCheckSource(Source source) {
            try {
                SearchFrame.this.sliseModel.getUserSourceDataMap(0.0, 0.0, source);
                return true;
            }
            catch (Throwable e) {
                new ThrowableDialog(e, false);
                return false;
            }
        }

        private Source getSource(SourceSelectedEvent evnt) {
            Source source = null;
            try {
                source = SearchFrame.this.sliseModel.getUserSource(evnt.getSourceDataFile(), this.getName(evnt), evnt.getVelocity(), evnt.getFrequencyMultiplier());
                if (source == null) {
                    throw new RuntimeException("For some reason model.getUserSource() returned null.");
                }
            }
            catch (Throwable e) {
                new ThrowableDialog(e, true);
            }
            return source;
        }

        private String getName(SourceSelectedEvent evnt) {
            String name = evnt.getSourceDataFile().getName();
            int instances = SearchFrame.this.getSourcesList().getInstances(name);
            if (instances > 0) {
                name = String.valueOf(name) + " (" + (instances + 1) + ")";
            }
            return name;
        }
    }
}

