/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.search;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.ferris.slise.search.SearchFrame;
import org.ferris.slise.search.SourcesList;
import org.ferris.slise.search.TelescopesTable;
import org.ferris.swing.JComponentErrors;

public class SearchFrameErrors
extends JComponentErrors {
    private SearchFrame input;

    public SearchFrameErrors(SearchFrame mainframe) {
        this.input = mainframe;
    }

    public Component getParent() {
        return this.input;
    }

    public void setErrors() {
        TelescopesTable table;
        SourcesList list = this.input.getSourcesList();
        if (list.getSelectedIndex() < 0) {
            this.addError(list, "Select a Source");
        }
        if ((table = this.input.getTelescopesTable()).getSelectedCount() == 0) {
            this.addError(table, "Select a Telescope");
        }
        JTextField text = this.input.getFreqMinText();
        this.addNumericError(text, "Minimum Frequency");
        text = this.input.getFreqMaxText();
        this.addNumericError(text, "Maximum Frequency");
        this.addRequiredError(this.input.getFreqMinText(), "Minimum Frequency", this.input.getFreqMaxText(), "Maximum Frequency");
        this.addMinimumValueError(this.input.getFreqMinText(), this.input.getFreqMaxText(), "Minimum Frequency");
        text = this.input.getFreqCenterText();
        this.addNumericError(text, "Center Frequency");
        text = this.input.getFreqPlusMinusText();
        this.addNumericError(text, "Frequency Offset");
        this.addRequiredError(this.input.getFreqCenterText(), "Center Frequency", this.input.getFreqPlusMinusText(), "Center Frequency Offset");
        this.setRequiredError(this.input.getFreqMinText(), this.input.getFreqMaxText(), this.input.getFreqCenterText(), this.input.getFreqPlusMinusText(), "Either Min/Max or Center/Offset Frequency");
        this.setRequiredError(this.input.getMhzRadioButton(), this.input.getGhzRadioButton(), "Either MHz or GHz");
    }

    private void setRequiredError(JRadioButton mhzRadioButton, JRadioButton ghzRadioButton, String string) {
        if (!ghzRadioButton.isSelected() && !mhzRadioButton.isSelected()) {
            JComponent[] array = new JComponent[]{mhzRadioButton, ghzRadioButton};
            this.addError(array, String.valueOf(string) + " is required.");
        }
    }

    private void setRequiredError(JTextField f1, JTextField f2, JTextField f3, JTextField f4, String name) {
        if (f1.getText().length() == 0 && f2.getText().length() == 0 && f3.getText().length() == 0 && f4.getText().length() == 0) {
            JComponent[] array = new JComponent[]{f1, f2, f3, f4};
            this.addError(array, String.valueOf(name) + " is required.");
        }
    }
}

