/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.search;

import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.ferris.astronomy.data.catalog.CatalogList;
import org.ferris.losst.common.model.LosstModel;
import org.ferris.losst.common.search.SearchFrame;
import org.ferris.slise.plot.PlotFrame;

public class SlaimSearchDialog
extends JDialog {
    private static final long serialVersionUID = 132732737647440754L;
    protected JButton cancelButton;

    public SlaimSearchDialog(PlotFrame owner, LosstModel model, String title, double[] range, double[] center) throws HeadlessException {
        super(owner, title, true);
        SlaimSearchFrame frm = new SlaimSearchFrame(model, range, center);
        this.setSize(frm.getWidth(), frm.getHeight() - 20);
        this.getContentPane().add((Component)frm.getSearchCriteriaPanel(), "North");
        this.setLocationRelativeTo(this.getOwner());
        frm.getMhzRadioButton().setSelected(true);
        super.pack();
    }

    protected JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SlaimSearchDialog.this.setVisible(false);
                    SlaimSearchDialog.this.dispose();
                }
            });
        }
        return this.cancelButton;
    }

    class DisposeRunnable
    implements Runnable {
        DisposeRunnable() {
        }

        public void run() {
            SlaimSearchDialog.this.setVisible(false);
            SlaimSearchDialog.this.dispose();
        }
    }

    class SlaimSearchFrame
    extends SearchFrame {
        private static final long serialVersionUID = -6709253519963902128L;

        public SlaimSearchFrame(LosstModel model, double[] range, double[] center) {
            super(model, "");
            this.setJMenuBar(null);
            this.setButtons(new JButton[]{this.getSearchButton(), SlaimSearchDialog.this.getCancelButton()});
            if (range != null) {
                this.setFrequencyRange(range[0], range[1]);
            }
            if (center != null) {
                this.setFrequencyCenter(center[0], center[1]);
            }
        }

        protected void showDisplayFrame(CatalogList list, String actionCommand) {
            if (list.getSize() == 0) {
                JOptionPane.showMessageDialog(SlaimSearchDialog.this, "No overlapping slaim data found.");
                return;
            }
            PlotFrame plot = (PlotFrame)SlaimSearchDialog.this.getOwner();
            plot.plotSlaim(list);
            SwingUtilities.invokeLater(new DisposeRunnable());
        }
    }
}

