/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.search;

import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;
import org.ferris.astronomy.data.source.Source;
import org.ferris.slise.search.SourceListCellRenderer;

public class SourceComboBox
extends JComboBox {
    private static final long serialVersionUID = 4828713682683096260L;
    private List completeList;
    private List noDuplicatesList;

    public List getAllSources() {
        return this.completeList;
    }

    public SourceComboBox(List sourceList, ActionListener myActions) {
        this.setPreferredSize(new Dimension(31, 20));
        this.setActionCommand("sourceComboBoxChanged");
        this.setRenderer(new SourceListCellRenderer());
        this.completeList = new ArrayList(sourceList.size());
        this.completeList.addAll(sourceList);
        this.noDuplicatesList = new LinkedList();
        block0: for (Source item : this.completeList) {
            for (Source itemx : this.noDuplicatesList) {
                if (itemx.getName().equals(item.getName())) continue block0;
            }
            this.noDuplicatesList.add(item);
        }
        Iterator itr = this.noDuplicatesList.iterator();
        while (itr.hasNext()) {
            this.addItem(itr.next());
        }
        this.addActionListener(myActions);
    }

    public Source getSelectedSource() {
        return (Source)this.getSelectedItem();
    }

    public int getInstances(String name) {
        int instances = 0;
        int i = 0;
        while (i < this.getItemCount()) {
            Source s = (Source)this.getItemAt(i);
            if (s.getName().startsWith(name)) {
                ++instances;
            }
            ++i;
        }
        return instances;
    }

    public void addSource(Source source) {
        this.completeList.add(source);
        this.addItem(source);
        this.setSelectedItem(source);
    }
}

