/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.search;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JList;
import org.ferris.astronomy.data.source.Source;
import org.ferris.slise.search.SourcesListCellRenderer;
import org.ferris.slise.search.SourcesListModel;

public class SourcesList
extends JList {
    private static final long serialVersionUID = -7508239213704633909L;
    private List completeList;

    public SourcesList(List sourceList) {
        super.setLayoutOrientation(0);
        super.setVisibleRowCount(8);
        this.setCellRenderer(new SourcesListCellRenderer());
        this.completeList = new ArrayList(sourceList.size());
        this.completeList.addAll(sourceList);
        LinkedList<Source> noDuplicatesList = new LinkedList<Source>();
        block0: for (Source item : this.completeList) {
            for (Source itemx : noDuplicatesList) {
                if (itemx.getName().equals(item.getName())) continue block0;
            }
            noDuplicatesList.add(item);
        }
        this.setModel(new SourcesListModel(noDuplicatesList));
        this.setSelectedIndex(0);
    }

    public Source[] getSelectedSources() {
        Object[] objs = this.getSelectedValues();
        Source[] sources = new Source[objs.length];
        System.arraycopy(objs, 0, sources, 0, objs.length);
        return sources;
    }

    public Source getSelectedSource() {
        return (Source)this.getSelectedValue();
    }

    public List getAllSources() {
        return this.completeList;
    }

    public SourcesListModel getMyModel() {
        return (SourcesListModel)this.getModel();
    }

    public int getInstances(String name) {
        int instances = 0;
        for (Source s : this.getMyModel().getList()) {
            if (!s.getName().startsWith(name)) continue;
            ++instances;
        }
        return instances;
    }

    public void addSource(Source source) {
        this.completeList.add(source);
        this.getMyModel().addSource(source);
        this.setSelectedValue(source, true);
    }
}

