/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.search;

import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.ferris.astronomy.data.source.Source;

class TelescopeTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -7805202953434576553L;
    private List sources;
    private String[] columnNames = new String[]{"Source", "Telescope", "Include In Search"};
    private Boolean[] checked;

    public TelescopeTableModel() {
        this.sources = new LinkedList();
        this.checked = new Boolean[0];
    }

    public LinkedList getSelectedSources() {
        LinkedList selected = new LinkedList();
        int i = 0;
        while (i < this.checked.length) {
            Boolean element = this.checked[i];
            if (element.booleanValue()) {
                selected.add(this.sources.get(i));
            }
            ++i;
        }
        return selected;
    }

    public void setSources(List list) {
        this.sources = list;
        int i = 0;
        while (i < this.checked.length) {
            this.checked[i] = null;
            ++i;
        }
        this.checked = null;
        this.checked = new Boolean[list.size()];
        i = 0;
        while (i < this.checked.length) {
            this.checked[i] = Boolean.TRUE;
            ++i;
        }
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.sources.size();
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Object getValueAt(int row, int col) {
        Object retval = null;
        switch (col) {
            case 0: {
                retval = ((Source)this.sources.get(row)).getName();
                break;
            }
            case 1: {
                retval = ((Source)this.sources.get(row)).getTelescope().getName();
                break;
            }
            default: {
                retval = this.checked[row];
            }
        }
        return retval;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 2: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    public void setValueAt(Object value, int row, int col) {
        if (col == 1) {
            this.checked[row] = (Boolean)value;
        }
        this.fireTableCellUpdated(row, col);
    }
}

