/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.search;

import java.util.LinkedList;
import java.util.List;
import javax.swing.JTable;
import org.ferris.astronomy.data.source.Source;
import org.ferris.slise.data.source.MySourceBean;
import org.ferris.slise.search.TelescopeTableModel;

public class TelescopesTable
extends JTable {
    private static final long serialVersionUID = -1805809007860429128L;
    private List allSources;

    public TelescopesTable(List allSources) {
        this.allSources = allSources;
        this.setModel(new TelescopeTableModel());
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(false);
    }

    private TelescopeTableModel getMyModel() {
        return (TelescopeTableModel)super.getModel();
    }

    public void setSources(Source[] s) {
        LinkedList telescopes = new LinkedList();
        int i = 0;
        while (i < s.length) {
            telescopes.addAll(this.getDuplicateSources(s[i]));
            ++i;
        }
        this.getMyModel().setSources(telescopes);
    }

    private List getDuplicateSources(Source source) {
        LinkedList<Source> sources = new LinkedList<Source>();
        for (Source item : this.allSources) {
            if (!item.getName().equals(source.getName())) continue;
            sources.add(item);
        }
        return sources;
    }

    public int getSelectedCount() {
        return this.getMyModel().getSelectedSources().size();
    }

    public MySourceBean[] getSelectedSources() {
        LinkedList l = this.getMyModel().getSelectedSources();
        MySourceBean[] array = new MySourceBean[l.size()];
        System.arraycopy(l.toArray(), 0, array, 0, array.length);
        return array;
    }
}

