/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.source;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.ferris.astronomy.math.BigDecimalTools;
import org.ferris.slise.filechooser.ChooseSourceFile;
import org.ferris.slise.source.SourceSelectedEvent;
import org.ferris.slise.source.SourceSelectedListener;
import org.ferris.swing.event.DisableAllAndExecuteActionListener;

public class AddSourceDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Preferences prefs;
    private ButtonGroup mhzGhzGroup;
    private JPanel mhzGhzPanel;
    private JPanel panel;
    private JPanel btnPanel;
    private JLabel sourceFileLbl;
    private SourceFileTextField sourceFileTxt;
    private JButton sourceFileBtn;
    private JLabel velocityLbl;
    private JTextField velocityTxt;
    private JLabel mhzGhzLbl;
    private JRadioButton mhzRadioBtn;
    private JRadioButton ghzRadioBtn;
    private JButton cancelBtn;
    private JButton submitBtn;
    private SourceSelectedListener sourceSelectedListener;

    public AddSourceDialog(Frame parent, SourceSelectedListener sourceSelectedListener) throws HeadlessException {
        this(parent, sourceSelectedListener, true);
    }

    public AddSourceDialog(Frame parent, SourceSelectedListener sourceSelectedListener, boolean setVisible) throws HeadlessException {
        super(parent, "Add Source");
        this.setProperties(sourceSelectedListener);
        this.createVisualObjects();
        this.groupVisualObjects();
        this.layoutVisualObjects(setVisible);
    }

    private void layoutVisualObjects(boolean setVisible) {
        this.layoutFileSelected();
        this.layoutVelocity();
        this.layoutMhzGhz();
        this.layoutButtons();
        this.getContentPane().add((Component)this.panel, "North");
        this.setVisible(setVisible);
    }

    private void layoutButtons() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        this.panel.add((Component)this.btnPanel, gbc);
    }

    private void layoutMhzGhz() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 3, 0, 3);
        this.panel.add((Component)this.mhzGhzLbl, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        this.panel.add((Component)this.mhzGhzPanel, gbc);
    }

    private void layoutVelocity() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 3, 0, 3);
        this.panel.add((Component)this.velocityLbl, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.panel.add((Component)this.velocityTxt, gbc);
    }

    private void layoutFileSelected() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 3, 0, 3);
        this.panel.add((Component)this.sourceFileLbl, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.panel.add((Component)this.sourceFileTxt, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        this.panel.add((Component)this.sourceFileBtn, gbc);
    }

    private void groupVisualObjects() {
        this.mhzGhzGroup = new ButtonGroup();
        this.mhzGhzGroup.add(this.mhzRadioBtn);
        this.mhzGhzGroup.add(this.ghzRadioBtn);
        this.panel = this.getPanel();
        this.mhzGhzPanel = new JPanel(new FlowLayout(0));
        this.mhzGhzPanel.add(this.mhzRadioBtn);
        this.mhzGhzPanel.add(this.ghzRadioBtn);
        this.btnPanel = new JPanel(new FlowLayout(1));
        this.btnPanel.add(this.submitBtn);
        this.btnPanel.add(this.cancelBtn);
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel(new GridBagLayout());
        }
        return this.panel;
    }

    private void createVisualObjects() {
        this.sourceFileLbl = new JLabel("Source File: ");
        this.sourceFileTxt = new SourceFileTextField();
        this.sourceFileBtn = new JButton("Browse");
        this.sourceFileBtn.addActionListener(new SourceFileAction());
        this.velocityLbl = new JLabel("LSR Velocity (km/s): ");
        this.velocityTxt = this.getVelocityText();
        this.mhzGhzLbl = new JLabel("Frequency: ");
        this.mhzRadioBtn = this.getMhzRadioButton();
        this.ghzRadioBtn = this.getGhzRadioButton();
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.addActionListener(new CancelAction());
        this.submitBtn = new JButton("Add Source");
        this.submitBtn.addActionListener((ActionListener)((Object)new SubmitAction(this.getPanel(), this.getPanel())));
    }

    public JRadioButton getMhzRadioButton() {
        if (this.mhzRadioBtn == null) {
            this.mhzRadioBtn = new JRadioButton("MHz");
        }
        return this.mhzRadioBtn;
    }

    public JRadioButton getGhzRadioButton() {
        if (this.ghzRadioBtn == null) {
            this.ghzRadioBtn = new JRadioButton("GHz");
        }
        return this.ghzRadioBtn;
    }

    public JTextField getVelocityText() {
        if (this.velocityTxt == null) {
            this.velocityTxt = new JTextField(10);
        }
        return this.velocityTxt;
    }

    private void setProperties(SourceSelectedListener sourceSelectedListener) {
        this.sourceSelectedListener = sourceSelectedListener;
        this.prefs = Preferences.systemNodeForPackage(this.getClass());
        this.setDefaultCloseOperation(2);
        this.setSize(500, 150);
        this.setResizable(false);
        this.setModal(true);
        this.setLocationRelativeTo(this.getOwner());
        this.getContentPane().setLayout(new BorderLayout());
    }

    private void setSourceFile(File file) {
        this.sourceFileTxt.setFile(file);
    }

    private String getSourceFileText() {
        return StringUtils.trimToNull((String)this.sourceFileTxt.getText());
    }

    private File getSourceFile() {
        return this.sourceFileTxt.getFile();
    }

    private void setSourceFileFocus() {
        this.sourceFileBtn.requestFocusInWindow();
    }

    private String getVelocity() {
        return StringUtils.trimToNull((String)this.velocityTxt.getText());
    }

    private void setVelocityFocus() {
        this.velocityTxt.requestFocusInWindow();
        int len = this.velocityTxt.getText().length();
        if (len > 0) {
            this.velocityTxt.setSelectionStart(0);
            this.velocityTxt.setSelectionEnd(len);
        }
    }

    private Object getMhzGhz() {
        return this.mhzGhzGroup.getSelection();
    }

    private int getFrequencyMultiplier() {
        if (this.mhzRadioBtn.getModel().equals(this.mhzGhzGroup.getSelection())) {
            return 1;
        }
        return 1000;
    }

    class CancelAction
    implements ActionListener {
        CancelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            AddSourceDialog.this.setVisible(false);
            AddSourceDialog.this.dispose();
        }
    }

    class SourceFileAction
    implements ActionListener {
        SourceFileAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ChooseSourceFile choose = new ChooseSourceFile(new File(AddSourceDialog.this.prefs.get("lastDataFileDir", System.getProperty("user.home"))));
            if (choose.isCanceled() || choose.getSelectedFile() == null) {
                return;
            }
            AddSourceDialog.this.setSourceFile(choose.getSelectedFile());
            AddSourceDialog.this.prefs.put("lastDataFileDir", AddSourceDialog.this.getSourceFile().getParent());
            try {
                AddSourceDialog.this.prefs.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class SourceFileTextField
    extends JTextField {
        private static final long serialVersionUID = 19792798670986L;
        private File file;

        SourceFileTextField() {
        }

        public void setFile(File f) {
            this.file = f;
            this.setText(f.toString());
        }

        public File getFile() {
            return this.file;
        }

        public String getText() {
            if (this.file != null) {
                return this.file.toString();
            }
            return "";
        }
    }

    class SubmitAction
    extends DisableAllAndExecuteActionListener {
        public SubmitAction(Container container, JComponent component) {
            super(container, component);
        }

        public void execute(ActionEvent e) {
            if (AddSourceDialog.this.getSourceFileText() == null) {
                JOptionPane.showMessageDialog(AddSourceDialog.this, "Source File is required.", "Input Error", 0);
                AddSourceDialog.this.setSourceFileFocus();
                return;
            }
            if (AddSourceDialog.this.getVelocity() == null) {
                JOptionPane.showMessageDialog(AddSourceDialog.this, "Velocity is required.", "Input Error", 0);
                AddSourceDialog.this.setVelocityFocus();
                return;
            }
            if (!this.isDouble(AddSourceDialog.this.getVelocity())) {
                JOptionPane.showMessageDialog(AddSourceDialog.this, "Velocity must be numeric.", "Input Error", 0);
                AddSourceDialog.this.setVelocityFocus();
                return;
            }
            if (AddSourceDialog.this.getMhzGhz() == null) {
                JOptionPane.showMessageDialog(AddSourceDialog.this, "Frequency must be selected.", "Input Error", 0);
                return;
            }
            AddSourceDialog.this.sourceSelectedListener.addSource(new SourceSelectedEvent((Object)AddSourceDialog.this, AddSourceDialog.this.getSourceFile(), BigDecimalTools.getBigDecimal((String)AddSourceDialog.this.getVelocity()).doubleValue(), AddSourceDialog.this.getFrequencyMultiplier()));
            AddSourceDialog.this.setVisible(false);
            AddSourceDialog.this.dispose();
        }

        private boolean isDouble(String s) {
            boolean ret = true;
            try {
                BigDecimalTools.getBigDecimal((String)s);
            }
            catch (NumberFormatException e) {
                ret = false;
            }
            return ret;
        }
    }
}

