/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.splatalogue;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.ferris.astronomy.data.telescope.TelescopeArrayType;
import org.ferris.slise.model.SliseModel;
import org.ferris.swing.ui.ThrowableDialog;

public class ArrayOrSingleDishDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel contentPanel = null;
    private JPanel radioButtonsPanel = null;
    private ButtonGroup radioButtonGroup = null;
    private JRadioButton arrayRadioButton = null;
    private JRadioButton singleDishRadioButton = null;
    private JButton goButton = null;
    private SliseModel sliseModel = null;
    private TelescopeArrayType telescopeArrayType = null;

    private SliseModel getSliseModel() {
        return this.sliseModel;
    }

    private void setSliseModel(SliseModel sliseModel) {
        this.sliseModel = sliseModel;
    }

    public TelescopeArrayType getTelescopeArrayType() {
        return this.telescopeArrayType;
    }

    private void setTelescopeArrayType(TelescopeArrayType telescopeArrayType) {
        this.telescopeArrayType = telescopeArrayType;
    }

    public ArrayOrSingleDishDialog(Frame parent, SliseModel model) {
        super(parent, "", true);
        this.initialize();
        this.setSliseModel(model);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(parent);
    }

    private void initialize() {
        this.setSize(216, 111);
        this.setTitle("Telescope Array Type");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getContentPanel(), "North");
        }
        return this.jContentPane;
    }

    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.insets = new Insets(5, 0, 5, 0);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new GridBagLayout());
            this.contentPanel.add((Component)this.getRadioButtonsPanel(), gridBagConstraints2);
            this.contentPanel.add((Component)this.getGoButton(), gridBagConstraints3);
        }
        return this.contentPanel;
    }

    private JPanel getRadioButtonsPanel() {
        if (this.radioButtonsPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.fill = 2;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            this.radioButtonsPanel = new JPanel();
            this.radioButtonsPanel.setLayout(new GridBagLayout());
            this.radioButtonsPanel.add((Component)this.getArrayRadioButton(), gridBagConstraints);
            this.radioButtonsPanel.add((Component)this.getSingleDishRadioButton(), gridBagConstraints1);
        }
        return this.radioButtonsPanel;
    }

    private ButtonGroup getRadioButtonGroup() {
        if (this.radioButtonGroup == null) {
            this.radioButtonGroup = new ButtonGroup();
        }
        return this.radioButtonGroup;
    }

    private JRadioButton getArrayRadioButton() {
        if (this.arrayRadioButton == null) {
            this.arrayRadioButton = new JRadioButton();
            this.arrayRadioButton.setText("Array");
            this.getRadioButtonGroup().add(this.arrayRadioButton);
        }
        return this.arrayRadioButton;
    }

    private JRadioButton getSingleDishRadioButton() {
        if (this.singleDishRadioButton == null) {
            this.singleDishRadioButton = new JRadioButton();
            this.singleDishRadioButton.setText("Single Dish");
            this.getRadioButtonGroup().add(this.singleDishRadioButton);
        }
        return this.singleDishRadioButton;
    }

    private JButton getGoButton() {
        if (this.goButton == null) {
            this.goButton = new JButton();
            this.goButton.setActionCommand("go");
            this.goButton.setText("Go");
            this.goButton.addActionListener(new GoAction());
        }
        return this.goButton;
    }

    private class GoAction
    implements ActionListener {
        private GoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (ArrayOrSingleDishDialog.this.getArrayRadioButton().isSelected()) {
                    ArrayOrSingleDishDialog.this.setTelescopeArrayType(ArrayOrSingleDishDialog.this.getSliseModel().getArrayTelescopeType());
                    ArrayOrSingleDishDialog.this.dispose();
                } else if (ArrayOrSingleDishDialog.this.getSingleDishRadioButton().isSelected()) {
                    ArrayOrSingleDishDialog.this.setTelescopeArrayType(ArrayOrSingleDishDialog.this.getSliseModel().getSingleDishTelescopeType());
                    ArrayOrSingleDishDialog.this.dispose();
                }
            }
            catch (Throwable t) {
                new ThrowableDialog(t, true).setVisible(true);
            }
        }
    }
}

