/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.splatalogue;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ferris.astronomy.data.molecule.Molecule;
import org.ferris.astronomy.data.telescope.TelescopeArrayType;
import org.ferris.losst.common.search.FrequencySearchCriteriaPanel;
import org.ferris.slise.plot.PlotFrame;
import org.ferris.slise.splatalogue.MoleculeSearchCriteria;
import org.ferris.slise.splatalogue.PlotItEvent;
import org.ferris.slise.splatalogue.PlotItListener;
import org.ferris.slise.splatalogue.SelectedMolecule;
import org.ferris.slise.splatalogue.SplatalogueSearchErrors;
import org.ferris.slise.swing.SliseFrame;
import org.ferris.swing.InvokeAndWait;
import org.ferris.swing.event.DisableAllAndExecuteActionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplatalogueSearchDialog
extends SliseFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel contentPanel = null;
    private FrequencySearchCriteriaPanel frequencySearchCriteriaPanel = null;
    private JLabel frequencySpacer = null;
    private JLabel frequencyLabel = null;
    private JLabel asteriskLabel = null;
    private JPanel selectedMoleculesPanel = null;
    private JLabel selectedMoleculesLabel = null;
    private JList selectedMoleculesList = null;
    private JPanel moleculesPanel = null;
    private JButton selectMoleculeButton = null;
    private JButton unselectMoleculeButton = null;
    private JPanel selectMoleculeButtonsPanel = null;
    private JPanel availableMoleculesPanel = null;
    private JLabel availableMoleculesLabel = null;
    private JTextField availableMoleculesFilterText = null;
    private JList availableMoleculesList = null;
    private JLabel moleculesSpacer = null;
    private JPanel moleculeSearchCriteraPanel = null;
    private JLabel temperatureLabel = null;
    private JTextField temperatureText = null;
    private JLabel columnDensityLabel = null;
    private JTextField columnDensityText = null;
    private JLabel thetaALabel = null;
    private JTextField thetaAText = null;
    private JLabel thetaBLabel = null;
    private JTextField thetaBText = null;
    private JLabel bLabel1 = null;
    private JTextField bText = null;
    private JTextField backgroundTemperatureText = null;
    private JLabel etaBLabel = null;
    private JTextField etaBText = null;
    private JLabel speciesSearchCriteriaSpacerLabel = null;
    private JPanel buttonPanel = null;
    private JButton searchButton = null;
    private JButton cancelButton = null;
    private JLabel lineWidthLabel = null;
    private JTextField lineWidthText = null;
    private JScrollPane availableMoleculesScrollPane = null;
    private JScrollPane selectedMoleculesScrollPane = null;
    private JLabel availableMoleculesListPositionLabel = null;
    private TelescopeArrayType telescopeArrayType = null;
    private Double frequencyMin = null;
    private Double frequencyMax = null;
    private List moleculeList = null;
    private SplatalogueSearchErrors inputErrors;
    private SelectedMoleculesListModel selectedMoleculesListModel;
    private AvailableMoleculesListModel availableMoleculesListModel;
    private JLabel selectedMoleculesListPositionLabel = null;
    private Set<PlotItListener> plotItListeners;
    private EnableUpdateButtonListener enableUpdateButtonListener;
    private JPanel backgroundTemperatureLabelPanel = null;
    private JLabel backgroundTemperatureLabel1 = null;
    private JLabel backgroundTemperatureLabel2 = null;
    private JLabel backgroundTemperatureLabel3 = null;

    private Set<PlotItListener> getPlotItListeners() {
        if (this.plotItListeners == null) {
            this.plotItListeners = new HashSet<PlotItListener>();
        }
        return this.plotItListeners;
    }

    public void addPlotItListener(PlotItListener listener) {
        this.getPlotItListeners().add(listener);
    }

    public void removePlotItListener(PlotItListener listener) {
        this.getPlotItListeners().remove(listener);
    }

    private EnableUpdateButtonListener getEnableUpdateButtonListener() {
        if (this.enableUpdateButtonListener == null) {
            this.enableUpdateButtonListener = new EnableUpdateButtonListener();
        }
        return this.enableUpdateButtonListener;
    }

    private SplatalogueSearchErrors getInputErrors() {
        if (this.inputErrors == null) {
            this.inputErrors = new SplatalogueSearchErrors(this);
        }
        return this.inputErrors;
    }

    private Double getFrequencyMax() {
        return this.frequencyMax;
    }

    private void setFrequencyMax(Double frequencyMax) {
        this.frequencyMax = frequencyMax;
    }

    private Double getFrequencyMin() {
        return this.frequencyMin;
    }

    private void setFrequencyMin(Double frequencyMin) {
        this.frequencyMin = frequencyMin;
    }

    private List getMoleculeList() {
        return this.moleculeList;
    }

    private void setMoleculeList(List moleculeList) {
        this.moleculeList = moleculeList;
    }

    private TelescopeArrayType getTelescopeArrayType() {
        return this.telescopeArrayType;
    }

    private void setTelescopeArrayType(TelescopeArrayType telescopeArrayType) {
        this.telescopeArrayType = telescopeArrayType;
    }

    public SplatalogueSearchDialog(PlotFrame owner, List moleculeList, Double frequencyMin, Double frequencyMax, TelescopeArrayType telescopeArrayType) {
        super("Splatalog Search");
        this.setMoleculeList(moleculeList);
        this.setFrequencyMin(frequencyMin);
        this.setFrequencyMax(frequencyMax);
        this.setTelescopeArrayType(telescopeArrayType);
        this.initialize();
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(owner);
    }

    private void initialize() {
        this.setSize(429, 546);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getContentPanel(), "North");
        }
        return this.jContentPane;
    }

    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            GridBagConstraints gridBagConstraints111 = new GridBagConstraints();
            gridBagConstraints111.gridx = 0;
            gridBagConstraints111.anchor = 17;
            gridBagConstraints111.gridy = 2;
            GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
            gridBagConstraints32.gridx = 0;
            gridBagConstraints32.gridwidth = 3;
            gridBagConstraints32.fill = 2;
            gridBagConstraints32.insets = new Insets(15, 0, 0, 0);
            gridBagConstraints32.gridy = 8;
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.gridx = 0;
            gridBagConstraints25.gridwidth = 2;
            gridBagConstraints25.gridy = 5;
            this.speciesSearchCriteriaSpacerLabel = new JLabel();
            this.speciesSearchCriteriaSpacerLabel.setText("   ");
            GridBagConstraints gridBagConstraints110 = new GridBagConstraints();
            gridBagConstraints110.gridx = 1;
            gridBagConstraints110.fill = 2;
            gridBagConstraints110.gridwidth = 2;
            gridBagConstraints110.gridy = 6;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 1;
            gridBagConstraints21.gridy = 2;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.gridwidth = 2;
            gridBagConstraints11.gridy = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.insets = new Insets(0, 5, 0, 10);
            gridBagConstraints2.gridy = 1;
            this.frequencyLabel = new JLabel();
            this.frequencyLabel.setText("Frequency (MHz) :");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridx = 2;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new GridBagLayout());
            this.contentPanel.add((Component)this.getFrequencySearchCriteriaPanel(), gridBagConstraints1);
            this.contentPanel.add((Component)this.frequencySpacer, gridBagConstraints);
            this.contentPanel.add((Component)this.frequencyLabel, gridBagConstraints2);
            this.contentPanel.add((Component)this.getMoleculesPanel(), gridBagConstraints11);
            this.contentPanel.add((Component)this.moleculesSpacer, gridBagConstraints21);
            this.contentPanel.add((Component)this.getMoleculeSearchCriteraPanel(), gridBagConstraints110);
            this.contentPanel.add((Component)this.speciesSearchCriteriaSpacerLabel, gridBagConstraints25);
            this.contentPanel.add((Component)this.getButtonPanel(), gridBagConstraints32);
        }
        return this.contentPanel;
    }

    private FrequencySearchCriteriaPanel getFrequencySearchCriteriaPanel() {
        if (this.frequencySearchCriteriaPanel == null) {
            this.frequencySpacer = new JLabel();
            this.frequencySpacer.setText("   ");
            this.frequencySearchCriteriaPanel = new FrequencySearchCriteriaPanel();
            this.frequencySearchCriteriaPanel.setCenterOffsetVisible(false);
            this.frequencySearchCriteriaPanel.setMinAndMax(this.getFrequencyMin(), this.getFrequencyMax());
            this.frequencySearchCriteriaPanel.getMhzBtn().setVisible(false);
            this.frequencySearchCriteriaPanel.getGhzBtn().setVisible(false);
        }
        return this.frequencySearchCriteriaPanel;
    }

    private JPanel getSelectedMoleculesPanel() {
        if (this.selectedMoleculesPanel == null) {
            GridBagConstraints gridBagConstraints33 = new GridBagConstraints();
            gridBagConstraints33.gridx = 0;
            gridBagConstraints33.anchor = 17;
            gridBagConstraints33.gridy = 3;
            GridBagConstraints gridBagConstraints29 = new GridBagConstraints();
            gridBagConstraints29.fill = 1;
            gridBagConstraints29.weighty = 1.0;
            gridBagConstraints29.gridx = 0;
            gridBagConstraints29.gridy = 2;
            gridBagConstraints29.weightx = 1.0;
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.anchor = 17;
            gridBagConstraints31.gridy = 0;
            this.selectedMoleculesLabel = new JLabel();
            this.selectedMoleculesLabel.setText("Selected Species");
            this.selectedMoleculesPanel = new JPanel();
            this.selectedMoleculesPanel.setLayout(new GridBagLayout());
            this.selectedMoleculesPanel.setPreferredSize(new Dimension(167, 210));
            this.selectedMoleculesPanel.add((Component)this.selectedMoleculesLabel, gridBagConstraints31);
            this.selectedMoleculesPanel.add((Component)this.getSelectedMoleculesScrollPane(), gridBagConstraints29);
            this.selectedMoleculesPanel.add((Component)this.getSelectedMoleculesListPositionLabel(), gridBagConstraints33);
        }
        return this.selectedMoleculesPanel;
    }

    public JList getSelectedMoleculesList() {
        if (this.selectedMoleculesList == null) {
            this.selectedMoleculesList = new JList();
            this.selectedMoleculesList.setModel(this.getSelectedMoleculesListModel());
            this.selectedMoleculesList.setSelectionMode(0);
            this.selectedMoleculesList.addListSelectionListener(new MoleculesListPositionListener(this.getSelectedMoleculesListPositionLabel()));
            this.selectedMoleculesList.addListSelectionListener(new SelectedMoleculesListChangeSearchCriteraListener());
            this.selectedMoleculesList.addFocusListener(new ToggleUnselectMoleculeButtonListener());
            this.selectedMoleculesList.addFocusListener(new DisableSelectMoleculeButtonListener());
            this.selectedMoleculesList.addFocusListener(new SelectedMoleculeClearSelectionListener());
            this.selectedMoleculesList.getSelectionModel().setSelectionInterval(0, 0);
        }
        return this.selectedMoleculesList;
    }

    private SelectedMoleculesListModel getSelectedMoleculesListModel() {
        if (this.selectedMoleculesListModel == null) {
            this.selectedMoleculesListModel = new SelectedMoleculesListModel();
        }
        return this.selectedMoleculesListModel;
    }

    private JPanel getMoleculesPanel() {
        if (this.moleculesPanel == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridy = 1;
            this.moleculesSpacer = new JLabel();
            this.moleculesSpacer.setText("   ");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.fill = 3;
            gridBagConstraints7.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.gridheight = 2;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridy = 2;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.gridx = 0;
            this.moleculesPanel = new JPanel();
            this.moleculesPanel.setLayout(new GridBagLayout());
            this.moleculesPanel.add((Component)this.getSelectedMoleculesPanel(), gridBagConstraints3);
            this.moleculesPanel.add((Component)this.getSelectMoleculeButtonsPanel(), gridBagConstraints7);
            this.moleculesPanel.add((Component)this.getAvailableMoleculesPanel(), gridBagConstraints8);
        }
        return this.moleculesPanel;
    }

    private JButton getSelectMoleculeButton() {
        if (this.selectMoleculeButton == null) {
            this.selectMoleculeButton = new JButton(){
                private static final long serialVersionUID = 1934934276L;

                public void setActionCommand(String s) {
                    super.setActionCommand(s);
                    if (s.equals("selected")) {
                        this.setText(SplatalogueSearchDialog.this.getDeltaText());
                        SplatalogueSearchDialog.this.getSelectMoleculeButton().setToolTipText("update selected species");
                    } else {
                        this.setText(SplatalogueSearchDialog.this.getGreaterThanText());
                        SplatalogueSearchDialog.this.selectMoleculeButton.setToolTipText("Move to selected species");
                    }
                }
            };
            this.selectMoleculeButton.setText(this.getGreaterThanText());
            this.selectMoleculeButton.addActionListener(new SelectMoleculeAction());
            this.selectMoleculeButton.addActionListener(new UpdateMoleculeAction());
        }
        return this.selectMoleculeButton;
    }

    private String getGreaterThanText() {
        return ">";
    }

    private String getDeltaText() {
        return "\u0394";
    }

    private MoleculeSearchCriteria getMoleculeSearchCriteria() {
        MoleculeSearchCriteria criteria = new MoleculeSearchCriteria();
        criteria.setB(this.getBText().getText());
        criteria.setBackgroundTemperature(this.getBackgroundTemperatureText().getText());
        criteria.setColumnDensity(this.getColumnDensityText().getText());
        criteria.setEtaB(this.getEtaBText().getText());
        criteria.setLineWidth(this.getLineWidthText().getText());
        criteria.setMolecule(this.getSelectMoleculeButton().getActionCommand().equals("selected") ? this.getSelectedMoleculesListModel().getMoleculeAt(this.getSelectedMoleculesList().getSelectedIndex()) : this.getAvailableMoleculesListModel().getMoleculeAt(this.getAvailableMoleculesList().getSelectedIndex()));
        criteria.setTemperature(this.getTemperatureText().getText());
        criteria.setThetaA(this.getThetaAText().getText());
        criteria.setThetaB(this.getThetaBText().getText());
        return criteria;
    }

    private void setMoleculeSearchCriteria(MoleculeSearchCriteria criteria, String actionCommand) {
        this.getBText().setText(criteria.getB());
        this.getBackgroundTemperatureText().setText(criteria.getBackgroundTemperature());
        this.getColumnDensityText().setText(criteria.getColumnDensity());
        this.getEtaBText().setText(criteria.getEtaB());
        this.getLineWidthText().setText(criteria.getLineWidth());
        this.getTemperatureText().setText(criteria.getTemperature());
        this.getThetaAText().setText(criteria.getThetaA());
        this.getThetaBText().setText(criteria.getThetaB());
        this.getSelectMoleculeButton().setEnabled(false);
        this.getSelectMoleculeButton().setActionCommand(actionCommand);
    }

    private JButton getUnselectMoleculeButton() {
        if (this.unselectMoleculeButton == null) {
            this.unselectMoleculeButton = new JButton();
            this.unselectMoleculeButton.setText("<");
            this.unselectMoleculeButton.setToolTipText("Delete selected species");
            this.unselectMoleculeButton.setEnabled(false);
            this.unselectMoleculeButton.setPreferredSize(new Dimension(43, 26));
            this.unselectMoleculeButton.addActionListener(new UnSelectMoleculeAction());
        }
        return this.unselectMoleculeButton;
    }

    private JPanel getSelectMoleculeButtonsPanel() {
        if (this.selectMoleculeButtonsPanel == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.anchor = 11;
            gridBagConstraints6.gridx = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.anchor = 15;
            gridBagConstraints4.gridx = 0;
            this.selectMoleculeButtonsPanel = new JPanel();
            this.selectMoleculeButtonsPanel.setLayout(new GridBagLayout());
            this.selectMoleculeButtonsPanel.add((Component)this.getUnselectMoleculeButton(), gridBagConstraints4);
            this.selectMoleculeButtonsPanel.add((Component)this.getSelectMoleculeButton(), gridBagConstraints6);
        }
        return this.selectMoleculeButtonsPanel;
    }

    private JPanel getAvailableMoleculesPanel() {
        if (this.availableMoleculesPanel == null) {
            GridBagConstraints gridBagConstraints30 = new GridBagConstraints();
            gridBagConstraints30.gridx = 0;
            gridBagConstraints30.anchor = 17;
            gridBagConstraints30.gridy = 4;
            GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
            gridBagConstraints28.fill = 1;
            gridBagConstraints28.weighty = 1.0;
            gridBagConstraints28.gridx = 0;
            gridBagConstraints28.gridy = 3;
            gridBagConstraints28.weightx = 1.0;
            GridBagConstraints gridBagConstraints411 = new GridBagConstraints();
            gridBagConstraints411.fill = 1;
            gridBagConstraints411.gridy = 1;
            gridBagConstraints411.weightx = 1.0;
            gridBagConstraints411.gridx = 0;
            GridBagConstraints gridBagConstraints311 = new GridBagConstraints();
            gridBagConstraints311.gridx = 0;
            gridBagConstraints311.anchor = 17;
            gridBagConstraints311.gridy = 0;
            GridBagConstraints gridBagConstraints111 = new GridBagConstraints();
            gridBagConstraints111.gridx = 0;
            gridBagConstraints111.anchor = 17;
            gridBagConstraints111.gridy = 3;
            this.availableMoleculesLabel = new JLabel();
            this.availableMoleculesLabel.setText("Available Species");
            this.availableMoleculesPanel = new JPanel();
            this.availableMoleculesPanel.setLayout(new GridBagLayout());
            this.availableMoleculesPanel.setPreferredSize(new Dimension(167, 210));
            this.availableMoleculesPanel.add((Component)this.availableMoleculesLabel, gridBagConstraints311);
            this.availableMoleculesPanel.add((Component)this.getAvailableMoleculesFilterText(), gridBagConstraints411);
            this.availableMoleculesPanel.add((Component)this.getAvailableMoleculesScrollPane(), gridBagConstraints28);
            this.availableMoleculesPanel.add((Component)this.getAvailableMoleculesListPositionLabel(), gridBagConstraints30);
        }
        return this.availableMoleculesPanel;
    }

    private JTextField getAvailableMoleculesFilterText() {
        if (this.availableMoleculesFilterText == null) {
            this.availableMoleculesFilterText = new JTextField();
            this.availableMoleculesFilterText.setText("filter");
            this.availableMoleculesFilterText.setToolTipText("Type in filter string then hit \"Enter\" to filter, clear filter to get entire list.");
            this.availableMoleculesFilterText.setForeground(Color.gray);
            this.availableMoleculesFilterText.addActionListener(new FilterAvailableMoleculesAction());
            this.availableMoleculesFilterText.addFocusListener(new SelectDefaultTextOnFocus(this.availableMoleculesFilterText));
        }
        return this.availableMoleculesFilterText;
    }

    public JList getAvailableMoleculesList() {
        if (this.availableMoleculesList == null) {
            AvailableMoleculesListModel listModel = this.getAvailableMoleculesListModel();
            AvailableMoleculesListSelectionModel selectionModel = new AvailableMoleculesListSelectionModel();
            this.availableMoleculesList = new JList(listModel);
            this.availableMoleculesList.setModel(listModel);
            this.availableMoleculesList.setSelectionModel(selectionModel);
            this.availableMoleculesList.setSelectionMode(0);
            this.availableMoleculesList.addListSelectionListener(new MoleculesListPositionListener(this.getAvailableMoleculesListPositionLabel()));
            this.availableMoleculesList.addListSelectionListener(new DisableAddMoleculeButtonListener());
            this.availableMoleculesList.addListSelectionListener(new AvailableMoleculesListChangeSearchCriteraListener());
            this.availableMoleculesList.getSelectionModel().setSelectionInterval(0, 0);
        }
        return this.availableMoleculesList;
    }

    private MoleculeSearchCriteria getDefaultMoleculeSearchCriteria(Molecule m) {
        MoleculeSearchCriteria criteria = new MoleculeSearchCriteria();
        criteria.setMolecule(m);
        criteria.setB("0.5");
        criteria.setColumnDensity("1e14");
        criteria.setLineWidth("5");
        criteria.setTemperature("10");
        if (this.getTelescopeArrayType().isArray()) {
            criteria.setEtaB("");
            criteria.setBackgroundTemperature("");
            criteria.setThetaA("10");
            criteria.setThetaB("10");
        } else if (this.getTelescopeArrayType().isSingleDish()) {
            criteria.setEtaB("1");
            criteria.setBackgroundTemperature("2.78");
            criteria.setThetaA("");
            criteria.setThetaB("");
        }
        return criteria;
    }

    private AvailableMoleculesListModel getAvailableMoleculesListModel() {
        if (this.availableMoleculesListModel == null) {
            this.availableMoleculesListModel = new AvailableMoleculesListModel(this.getMoleculeList());
        }
        return this.availableMoleculesListModel;
    }

    private JPanel getMoleculeSearchCriteraPanel() {
        if (this.moleculeSearchCriteraPanel == null) {
            GridBagConstraints gridBagConstraints36 = new GridBagConstraints();
            gridBagConstraints36.gridx = 0;
            gridBagConstraints36.anchor = 13;
            gridBagConstraints36.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints36.gridy = 6;
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.fill = 1;
            gridBagConstraints27.gridy = 2;
            gridBagConstraints27.weightx = 1.0;
            gridBagConstraints27.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints27.gridx = 1;
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.gridx = 0;
            gridBagConstraints26.anchor = 13;
            gridBagConstraints26.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints26.gridy = 2;
            this.lineWidthLabel = new JLabel();
            this.lineWidthLabel.setText("<html><body>Line Width (km/s)<font color=\"red\">*</font> :</body></html>");
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.fill = 1;
            gridBagConstraints24.gridy = 7;
            gridBagConstraints24.weightx = 1.0;
            gridBagConstraints24.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints24.gridx = 1;
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.gridx = 0;
            gridBagConstraints23.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints23.anchor = 13;
            gridBagConstraints23.gridy = 7;
            this.etaBLabel = new JLabel();
            this.etaBLabel.setText("<html><body>&#951;<sub>b</sub> :</html>");
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.fill = 2;
            gridBagConstraints22.gridy = 6;
            gridBagConstraints22.weightx = 1.0;
            gridBagConstraints22.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints22.gridx = 1;
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.fill = 1;
            gridBagConstraints19.gridy = 5;
            gridBagConstraints19.weightx = 1.0;
            gridBagConstraints19.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints19.gridx = 1;
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 0;
            gridBagConstraints18.anchor = 13;
            gridBagConstraints18.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints18.gridy = 5;
            this.bLabel1 = new JLabel();
            this.bLabel1.setText("<html><body>Filling Factor :</html>");
            GridBagConstraints gridBagConstraintsAst = new GridBagConstraints();
            gridBagConstraintsAst.gridx = 0;
            gridBagConstraintsAst.anchor = 13;
            gridBagConstraintsAst.insets = new Insets(0, 5, 0, 5);
            gridBagConstraintsAst.gridy = 8;
            this.asteriskLabel = new JLabel();
            this.asteriskLabel.setText("<html><body><font color=\"red\">* Required Fields</font></html>");
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.fill = 1;
            gridBagConstraints17.gridy = 4;
            gridBagConstraints17.weightx = 1.0;
            gridBagConstraints17.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints17.gridx = 1;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 0;
            gridBagConstraints16.anchor = 13;
            gridBagConstraints16.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints16.gridy = 4;
            this.thetaBLabel = new JLabel();
            this.thetaBLabel.setText("<html><body>Theta B :</html>");
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.fill = 1;
            gridBagConstraints15.gridy = 3;
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints15.gridx = 1;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints14.anchor = 13;
            gridBagConstraints14.gridy = 3;
            this.thetaALabel = new JLabel();
            this.thetaALabel.setText("<html><body>Theta A :</html>");
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.fill = 1;
            gridBagConstraints13.gridy = 1;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.anchor = 17;
            gridBagConstraints13.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints13.gridx = 1;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.anchor = 13;
            gridBagConstraints12.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints12.gridy = 1;
            this.columnDensityLabel = new JLabel();
            this.columnDensityLabel.setText("<html><body>Column Density (cm<sup>-2</sup>)<font color=\"red\">*</font> :</html>");
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.fill = 1;
            gridBagConstraints10.gridy = 0;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.anchor = 17;
            gridBagConstraints10.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints10.gridx = 1;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints9.anchor = 13;
            gridBagConstraints9.gridy = 0;
            this.temperatureLabel = new JLabel();
            this.temperatureLabel.setText("<html><body>Temperature (K)<font color=\"red\">*</font> :</html>");
            this.moleculeSearchCriteraPanel = new JPanel();
            this.moleculeSearchCriteraPanel.setLayout(new GridBagLayout());
            this.moleculeSearchCriteraPanel.add((Component)this.temperatureLabel, gridBagConstraints9);
            this.moleculeSearchCriteraPanel.add((Component)this.getTemperatureText(), gridBagConstraints10);
            this.moleculeSearchCriteraPanel.add((Component)this.columnDensityLabel, gridBagConstraints12);
            this.moleculeSearchCriteraPanel.add((Component)this.getColumnDensityText(), gridBagConstraints13);
            this.moleculeSearchCriteraPanel.add((Component)this.thetaALabel, gridBagConstraints14);
            this.moleculeSearchCriteraPanel.add((Component)this.getThetaAText(), gridBagConstraints15);
            this.moleculeSearchCriteraPanel.add((Component)this.thetaBLabel, gridBagConstraints16);
            this.moleculeSearchCriteraPanel.add((Component)this.getThetaBText(), gridBagConstraints17);
            this.moleculeSearchCriteraPanel.add((Component)this.bLabel1, gridBagConstraints18);
            this.moleculeSearchCriteraPanel.add((Component)this.getBText(), gridBagConstraints19);
            this.moleculeSearchCriteraPanel.add((Component)this.getBackgroundTemperatureText(), gridBagConstraints22);
            this.moleculeSearchCriteraPanel.add((Component)this.etaBLabel, gridBagConstraints23);
            this.moleculeSearchCriteraPanel.add((Component)this.getEtaBText(), gridBagConstraints24);
            this.moleculeSearchCriteraPanel.add((Component)this.lineWidthLabel, gridBagConstraints26);
            this.moleculeSearchCriteraPanel.add((Component)this.getLineWidthText(), gridBagConstraints27);
            this.moleculeSearchCriteraPanel.add((Component)this.getBackgroundTemperatureLabelPanel(), gridBagConstraints36);
            this.moleculeSearchCriteraPanel.add((Component)this.asteriskLabel, gridBagConstraintsAst);
            if (this.getTelescopeArrayType().isArray()) {
                this.getEtaBText().setText("");
                this.getEtaBText().setVisible(false);
                this.etaBLabel.setVisible(false);
                this.getBackgroundTemperatureText().setText("");
                this.getBackgroundTemperatureText().setVisible(false);
                this.backgroundTemperatureLabel1.setVisible(false);
                this.backgroundTemperatureLabel2.setVisible(false);
                this.backgroundTemperatureLabel3.setVisible(false);
            } else if (this.getTelescopeArrayType().isSingleDish()) {
                this.getThetaAText().setText("");
                this.getThetaAText().setVisible(false);
                this.thetaALabel.setVisible(false);
                this.getThetaBText().setText("");
                this.getThetaBText().setVisible(false);
                this.thetaBLabel.setVisible(false);
            }
            this.setMoleculeSearchCriteria(this.getDefaultMoleculeSearchCriteria(null), "");
        }
        return this.moleculeSearchCriteraPanel;
    }

    public JTextField getTemperatureText() {
        if (this.temperatureText == null) {
            this.temperatureText = new JTextField();
            this.temperatureText.setText("10");
            this.temperatureText.setPreferredSize(new Dimension(80, 20));
            this.temperatureText.addFocusListener(new SelectTextOnFocus(this.temperatureText));
            this.temperatureText.addKeyListener(this.getEnableUpdateButtonListener());
        }
        return this.temperatureText;
    }

    public JTextField getColumnDensityText() {
        if (this.columnDensityText == null) {
            this.columnDensityText = new JTextField();
            this.columnDensityText.setPreferredSize(new Dimension(80, 20));
            this.columnDensityText.setText("1e14");
            this.columnDensityText.addFocusListener(new SelectTextOnFocus(this.columnDensityText));
            this.columnDensityText.addKeyListener(this.getEnableUpdateButtonListener());
        }
        return this.columnDensityText;
    }

    public JTextField getThetaAText() {
        if (this.thetaAText == null) {
            this.thetaAText = new JTextField();
            this.thetaAText.setPreferredSize(new Dimension(80, 20));
            this.thetaAText.setText("10");
            this.thetaAText.addFocusListener(new SelectTextOnFocus(this.thetaAText));
            this.thetaAText.addKeyListener(this.getEnableUpdateButtonListener());
        }
        return this.thetaAText;
    }

    public JTextField getThetaBText() {
        if (this.thetaBText == null) {
            this.thetaBText = new JTextField();
            this.thetaBText.setPreferredSize(new Dimension(80, 20));
            this.thetaBText.setText("10");
            this.thetaBText.addFocusListener(new SelectTextOnFocus(this.thetaBText));
            this.thetaBText.addKeyListener(this.getEnableUpdateButtonListener());
        }
        return this.thetaBText;
    }

    public JTextField getBText() {
        if (this.bText == null) {
            this.bText = new JTextField();
            this.bText.setPreferredSize(new Dimension(80, 20));
            this.bText.setText("0.5");
            this.bText.addFocusListener(new SelectTextOnFocus(this.bText));
            this.bText.addKeyListener(this.getEnableUpdateButtonListener());
        }
        return this.bText;
    }

    public JTextField getBackgroundTemperatureText() {
        if (this.backgroundTemperatureText == null) {
            this.backgroundTemperatureText = new JTextField();
            this.backgroundTemperatureText.setPreferredSize(new Dimension(80, 20));
            this.backgroundTemperatureText.setText("2.78");
            this.backgroundTemperatureText.addFocusListener(new SelectTextOnFocus(this.backgroundTemperatureText));
            this.backgroundTemperatureText.addKeyListener(this.getEnableUpdateButtonListener());
        }
        return this.backgroundTemperatureText;
    }

    public JTextField getEtaBText() {
        if (this.etaBText == null) {
            this.etaBText = new JTextField();
            this.etaBText.setPreferredSize(new Dimension(80, 20));
            this.etaBText.setText("1");
            this.etaBText.addFocusListener(new SelectTextOnFocus(this.etaBText));
            this.etaBText.addKeyListener(this.getEnableUpdateButtonListener());
        }
        return this.etaBText;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setVgap(10);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setBorder(new SoftBevelBorder(0));
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.add((Component)this.getSearchButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getSearchButton() {
        if (this.searchButton == null) {
            this.searchButton = new JButton();
            this.searchButton.setActionCommand("search");
            this.searchButton.setText("Plot It!");
            this.searchButton.addActionListener((ActionListener)((Object)new PlotItAction(this.getJContentPane(), this.getJContentPane())));
        }
        return this.searchButton;
    }

    @Override
    public void dispose() {
        System.out.println("Dispose()");
        this.getPlotItListeners().clear();
        super.dispose();
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setActionCommand("cancel");
            this.cancelButton.setText("Close");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.out.println("Close click");
                    SplatalogueSearchDialog.this.dispose();
                    SplatalogueSearchDialog.this.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }

    public JTextField getLineWidthText() {
        if (this.lineWidthText == null) {
            this.lineWidthText = new JTextField();
            this.lineWidthText.setText("5");
            this.lineWidthText.addFocusListener(new SelectTextOnFocus(this.lineWidthText));
            this.lineWidthText.addKeyListener(this.getEnableUpdateButtonListener());
        }
        return this.lineWidthText;
    }

    private JScrollPane getAvailableMoleculesScrollPane() {
        if (this.availableMoleculesScrollPane == null) {
            this.availableMoleculesScrollPane = new JScrollPane();
            this.availableMoleculesScrollPane.setViewportView(this.getAvailableMoleculesList());
        }
        return this.availableMoleculesScrollPane;
    }

    private JScrollPane getSelectedMoleculesScrollPane() {
        if (this.selectedMoleculesScrollPane == null) {
            this.selectedMoleculesScrollPane = new JScrollPane();
            this.selectedMoleculesScrollPane.setViewportView(this.getSelectedMoleculesList());
        }
        return this.selectedMoleculesScrollPane;
    }

    private JLabel getAvailableMoleculesListPositionLabel() {
        if (this.availableMoleculesListPositionLabel == null) {
            this.availableMoleculesListPositionLabel = new JLabel();
            this.availableMoleculesListPositionLabel.setText("JLabel");
        }
        return this.availableMoleculesListPositionLabel;
    }

    public JTextField getFreqMinText() {
        return this.getFrequencySearchCriteriaPanel().getFreqMinText();
    }

    public JTextField getFreqMaxText() {
        return this.getFrequencySearchCriteriaPanel().getFreqMaxText();
    }

    private double getFreqMin() {
        return this.getFrequencySearchCriteriaPanel().getFreqMin();
    }

    private double getFreqMax() {
        return this.getFrequencySearchCriteriaPanel().getFreqMax();
    }

    private List<SelectedMolecule> getSelectedMolecules() {
        SelectedMoleculesListModel m = this.getSelectedMoleculesListModel();
        ArrayList<SelectedMolecule> ms = new ArrayList<SelectedMolecule>(m.size());
        int i = 0;
        int ilen = m.size();
        while (i < ilen) {
            ms.add(m.getSelectedMoleculeAt(i));
            ++i;
        }
        return ms;
    }

    private JLabel getSelectedMoleculesListPositionLabel() {
        if (this.selectedMoleculesListPositionLabel == null) {
            this.selectedMoleculesListPositionLabel = new JLabel();
            this.selectedMoleculesListPositionLabel.setText("JLabel");
        }
        return this.selectedMoleculesListPositionLabel;
    }

    private JPanel getBackgroundTemperatureLabelPanel() {
        if (this.backgroundTemperatureLabelPanel == null) {
            GridBagConstraints gridBagConstraints35 = new GridBagConstraints();
            gridBagConstraints35.gridx = 1;
            gridBagConstraints35.gridheight = 2;
            gridBagConstraints35.fill = 3;
            gridBagConstraints35.anchor = 10;
            gridBagConstraints35.gridy = 0;
            this.backgroundTemperatureLabel3 = new JLabel();
            this.backgroundTemperatureLabel3.setText(":");
            GridBagConstraints gridBagConstraints34 = new GridBagConstraints();
            gridBagConstraints34.anchor = 13;
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.gridx = 0;
            gridBagConstraints20.anchor = 13;
            gridBagConstraints20.gridy = 1;
            this.backgroundTemperatureLabel2 = new JLabel();
            this.backgroundTemperatureLabel2.setText("Temperature (K) ");
            this.backgroundTemperatureLabel1 = new JLabel();
            this.backgroundTemperatureLabel1.setText("Background ");
            this.backgroundTemperatureLabel1.setVisible(true);
            this.backgroundTemperatureLabelPanel = new JPanel();
            this.backgroundTemperatureLabelPanel.setLayout(new GridBagLayout());
            this.backgroundTemperatureLabelPanel.add((Component)this.backgroundTemperatureLabel1, gridBagConstraints34);
            this.backgroundTemperatureLabelPanel.add((Component)this.backgroundTemperatureLabel2, gridBagConstraints20);
            this.backgroundTemperatureLabelPanel.add((Component)this.backgroundTemperatureLabel3, gridBagConstraints35);
        }
        return this.backgroundTemperatureLabelPanel;
    }

    private class AvailableMoleculesListChangeSearchCriteraListener
    implements ListSelectionListener {
        private AvailableMoleculesListChangeSearchCriteraListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            SplatalogueSearchDialog.this.getInputErrors().clear();
            if (e.getValueIsAdjusting()) {
                int si = SplatalogueSearchDialog.this.getAvailableMoleculesList().getSelectedIndex();
                Molecule m = SplatalogueSearchDialog.this.getAvailableMoleculesListModel().getMoleculeAt(si);
                SelectedMolecule sm = SplatalogueSearchDialog.this.getSelectedMoleculesListModel().getRemovedSelectedMoleculeFor(m);
                if (sm == null) {
                    sm = new SelectedMolecule(SplatalogueSearchDialog.this.getDefaultMoleculeSearchCriteria(m));
                }
                SplatalogueSearchDialog.this.setMoleculeSearchCriteria(sm.getCriteria(), "available");
            }
        }
    }

    private class AvailableMoleculesListModel
    extends AbstractListModel {
        private static final long serialVersionUID = -5037599220039809788L;
        private List data;
        private List originalList;

        public AvailableMoleculesListModel(List moleculeList) {
            this.originalList = moleculeList;
            this.setData(this.originalList);
        }

        private void setData(List data) {
            this.data = data;
            this.fireContentsChanged(this, 0, data.size() - 1);
        }

        public Object getElementAt(int index) {
            Molecule m = this.getMoleculeAt(index);
            return "<html><body>" + m.getSplatId() + "&nbsp;&nbsp;" + m.getDescription() + "</body></html>";
        }

        public Molecule getMoleculeAt(int index) {
            return (Molecule)this.data.get(index);
        }

        public int getSize() {
            return this.data.size();
        }

        public void filter(String filter) {
            if ((filter = filter.trim()).length() == 0) {
                this.setData(this.originalList);
            } else {
                filter = filter.toUpperCase();
                LinkedList<Molecule> matches = new LinkedList<Molecule>();
                for (Molecule m : this.originalList) {
                    String name = m.getName().toUpperCase();
                    String splatId = m.getSplatId().toUpperCase();
                    if (!splatId.contains(filter) && !name.contains(filter)) continue;
                    matches.add(m);
                }
                this.setData(matches);
            }
        }
    }

    private class AvailableMoleculesListSelectionModel
    extends DefaultListSelectionModel {
        private static final long serialVersionUID = -6840555185598458418L;

        private AvailableMoleculesListSelectionModel() {
        }

        public void setSelectionInterval(int index0, int index1) {
            super.setSelectionInterval(index0, index1);
            this.fireValueChanged(index0, index1, this.getValueIsAdjusting());
        }
    }

    private class DisableAddMoleculeButtonListener
    implements ListSelectionListener {
        private DisableAddMoleculeButtonListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            boolean enabled = true;
            boolean bl = enabled = ((JList)e.getSource()).getModel().getSize() > 0;
            if (enabled) {
                Molecule m = SplatalogueSearchDialog.this.getAvailableMoleculesListModel().getMoleculeAt(((JList)e.getSource()).getSelectedIndex());
                boolean bl2 = enabled = !SplatalogueSearchDialog.this.getSelectedMoleculesListModel().contains(m);
            }
            if (enabled) {
                SplatalogueSearchDialog.this.getSelectMoleculeButton().setToolTipText("Move to selected species");
            } else {
                SplatalogueSearchDialog.this.getSelectMoleculeButton().setToolTipText("update selected species");
            }
            SplatalogueSearchDialog.this.getSelectMoleculeButton().setEnabled(enabled);
        }
    }

    private class DisableSelectMoleculeButtonListener
    implements FocusListener {
        private DisableSelectMoleculeButtonListener() {
        }

        public void focusGained(FocusEvent e) {
            SplatalogueSearchDialog.this.getSelectMoleculeButton().setEnabled(false);
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private class EnableUpdateButtonListener
    implements KeyListener {
        private EnableUpdateButtonListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
            String action = SplatalogueSearchDialog.this.getSelectMoleculeButton().getActionCommand();
            if (action != null && action.equals("selected")) {
                SplatalogueSearchDialog.this.getSelectMoleculeButton().setEnabled(true);
            }
        }
    }

    private class FilterAvailableMoleculesAction
    implements ActionListener {
        private FilterAvailableMoleculesAction() {
        }

        public void actionPerformed(ActionEvent evnt) {
            Thread t = new Thread(){

                public void run() {
                    Runnable r = new Runnable(){

                        public void run() {
                            SplatalogueSearchDialog.this.getAvailableMoleculesListModel().filter(SplatalogueSearchDialog.this.getAvailableMoleculesFilterText().getText());
                            SplatalogueSearchDialog.this.getAvailableMoleculesList().getSelectionModel().setSelectionInterval(0, 0);
                        }
                    };
                    InvokeAndWait.run((Runnable)r);
                }
            };
            t.start();
        }
    }

    private class MoleculesListPositionListener
    implements ListSelectionListener {
        private JLabel label;

        private MoleculesListPositionListener(JLabel label) {
            this.label = label;
        }

        private JLabel getLabel() {
            return this.label;
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateSize(((JList)e.getSource()).getSelectedIndex(), ((JList)e.getSource()).getModel().getSize());
        }

        private void updateSize(final int newPosition, final int newSize) {
            new Thread(){

                public void run() {
                    InvokeAndWait.run((Runnable)new Runnable(){

                        public void run() {
                            MoleculesListPositionListener.this.getLabel().setText("Position: " + (newSize == 0 ? 0 : newPosition + 1) + " - " + newSize);
                        }
                    });
                }
            }.start();
        }
    }

    private class PlotItAction
    extends DisableAllAndExecuteActionListener {
        public PlotItAction(Container container, JComponent component) {
            super(container, component);
        }

        public void execute(ActionEvent evnt) {
            SplatalogueSearchErrors errors = SplatalogueSearchDialog.this.getInputErrors();
            errors.clear();
            errors.setPlotItErrors();
            if (!errors.isEmpty()) {
                errors.displayHtml();
                return;
            }
            PlotItEvent piEvnt = new PlotItEvent(SplatalogueSearchDialog.this, SplatalogueSearchDialog.this.getFreqMin(), SplatalogueSearchDialog.this.getFreqMax(), SplatalogueSearchDialog.this.getSelectedMolecules());
            for (PlotItListener listener : SplatalogueSearchDialog.this.getPlotItListeners()) {
                listener.plotIt(piEvnt);
            }
        }
    }

    private class SelectDefaultTextOnFocus
    implements FocusListener {
        private JTextField filter;

        private SelectDefaultTextOnFocus(JTextField filter) {
            this.filter = filter;
        }

        public void focusGained(FocusEvent e) {
            if (!e.isTemporary() && this.filter.getText().equals("filter")) {
                this.filter.setSelectionStart(0);
                this.filter.setSelectionEnd("filter".length());
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private class SelectMoleculeAction
    implements ActionListener {
        private SelectMoleculeAction() {
        }

        public void actionPerformed(ActionEvent evnt) {
            String actionCommand = SplatalogueSearchDialog.this.getSelectMoleculeButton().getActionCommand();
            if (actionCommand == null) {
                return;
            }
            if ("available".equals(actionCommand)) {
                this.select(evnt);
            }
            if ("".equals(actionCommand)) {
                this.select(evnt);
            }
        }

        private void select(ActionEvent evnt) {
            SplatalogueSearchErrors errors = SplatalogueSearchDialog.this.getInputErrors();
            errors.clear();
            errors.setSelectMoleculeErrors();
            if (!errors.isEmpty()) {
                errors.displayHtml();
                return;
            }
            SelectedMolecule sm = new SelectedMolecule(SplatalogueSearchDialog.this.getMoleculeSearchCriteria());
            SplatalogueSearchDialog.this.getSelectedMoleculesListModel().addElement(sm);
            ((JButton)evnt.getSource()).setEnabled(false);
        }
    }

    private class SelectTextOnFocus
    implements FocusListener {
        private JTextField filter;

        private SelectTextOnFocus(JTextField filter) {
            this.filter = filter;
        }

        public void focusGained(FocusEvent e) {
            if (!e.isTemporary()) {
                this.filter.setSelectionStart(0);
                this.filter.setSelectionEnd(this.filter.getText().length());
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private class SelectedMoleculeClearSelectionListener
    implements FocusListener {
        private SelectedMoleculeClearSelectionListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            boolean b;
            if (e.getOppositeComponent() == null) {
                return;
            }
            boolean bl = b = e.getOppositeComponent().equals(SplatalogueSearchDialog.this.getUnselectMoleculeButton()) || e.getOppositeComponent().equals(SplatalogueSearchDialog.this.getTemperatureText()) || e.getOppositeComponent().equals(SplatalogueSearchDialog.this.getColumnDensityText()) || e.getOppositeComponent().equals(SplatalogueSearchDialog.this.getLineWidthText()) || e.getOppositeComponent().equals(SplatalogueSearchDialog.this.getThetaAText()) || e.getOppositeComponent().equals(SplatalogueSearchDialog.this.getThetaBText()) || e.getOppositeComponent().equals(SplatalogueSearchDialog.this.getBText()) || e.getOppositeComponent().equals(SplatalogueSearchDialog.this.getBackgroundTemperatureText()) || e.getOppositeComponent().equals(SplatalogueSearchDialog.this.getEtaBText());
            if (!b) {
                SplatalogueSearchDialog.this.getSelectedMoleculesList().clearSelection();
            }
        }
    }

    private class SelectedMoleculesListChangeSearchCriteraListener
    implements ListSelectionListener {
        private SelectedMoleculesListChangeSearchCriteraListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            SplatalogueSearchDialog.this.getInputErrors().clear();
            if (e.getValueIsAdjusting()) {
                int si = SplatalogueSearchDialog.this.getSelectedMoleculesList().getSelectedIndex();
                SelectedMolecule sm = SplatalogueSearchDialog.this.getSelectedMoleculesListModel().getSelectedMoleculeAt(si);
                SplatalogueSearchDialog.this.setMoleculeSearchCriteria(sm.getCriteria(), "selected");
            }
        }
    }

    private class SelectedMoleculesListModel
    extends DefaultListModel {
        private static final long serialVersionUID = 3609047861299498118L;
        private Set removed = null;

        private SelectedMoleculesListModel() {
        }

        private Set getRemoved() {
            if (this.removed == null) {
                this.removed = new HashSet();
            }
            return this.removed;
        }

        public SelectedMolecule getRemovedSelectedMoleculeFor(Molecule o) {
            SelectedMolecule sm = null;
            Iterator itr = this.getRemoved().iterator();
            while (itr.hasNext() && sm == null) {
                sm = (SelectedMolecule)itr.next();
                if (o.equals(sm.getMolecule())) continue;
                sm = null;
            }
            return sm;
        }

        public Object getElementAt(int index) {
            Molecule m = this.getSelectedMoleculeAt(index).getMolecule();
            return "<html><body>" + m.getSplatId() + "&nbsp;&nbsp;" + m.getDescription() + "</body></html>";
        }

        public boolean contains(Molecule o) {
            Enumeration enu = super.elements();
            boolean found = false;
            while (!found && enu.hasMoreElements()) {
                found = o.equals(((SelectedMolecule)enu.nextElement()).getMolecule());
            }
            return found;
        }

        public SelectedMolecule getSelectedMoleculeAt(int index) {
            return (SelectedMolecule)super.getElementAt(index);
        }

        public Molecule getMoleculeAt(int index) {
            return this.getSelectedMoleculeAt(index).getMolecule();
        }

        public Object remove(int index) {
            Object o = super.remove(index);
            if (o != null) {
                this.getRemoved().add(o);
            }
            return o;
        }

        public void addElement(Object obj) {
            this.getRemoved().remove(obj);
            super.addElement(obj);
        }

        public void replaceElement(SelectedMolecule sm) {
            int index = -1;
            index = 0;
            while (index < this.size()) {
                SelectedMolecule toReplace = this.getSelectedMoleculeAt(index);
                if (toReplace.equals(sm)) break;
                ++index;
            }
            super.setElementAt(sm, index);
        }
    }

    private class ToggleUnselectMoleculeButtonListener
    implements FocusListener {
        private ToggleUnselectMoleculeButtonListener() {
        }

        public void focusGained(FocusEvent e) {
            if (!SplatalogueSearchDialog.this.getSelectedMoleculesListModel().isEmpty()) {
                SplatalogueSearchDialog.this.getUnselectMoleculeButton().setEnabled(true);
            } else {
                SplatalogueSearchDialog.this.getUnselectMoleculeButton().setEnabled(false);
            }
            SplatalogueSearchDialog.this.getSelectMoleculeButton().setEnabled(false);
        }

        public void focusLost(FocusEvent e) {
            if (e == null || e.getOppositeComponent() == null) {
                return;
            }
            if (!e.getOppositeComponent().equals(SplatalogueSearchDialog.this.getUnselectMoleculeButton())) {
                SplatalogueSearchDialog.this.getUnselectMoleculeButton().setEnabled(false);
            }
        }
    }

    private class UnSelectMoleculeAction
    implements ActionListener {
        private UnSelectMoleculeAction() {
        }

        public void actionPerformed(ActionEvent evnt) {
            int si = SplatalogueSearchDialog.this.getSelectedMoleculesList().getSelectedIndex();
            SplatalogueSearchDialog.this.getSelectedMoleculesListModel().remove(si);
            SplatalogueSearchDialog.this.getUnselectMoleculeButton().setEnabled(false);
        }
    }

    private class UpdateMoleculeAction
    implements ActionListener {
        private UpdateMoleculeAction() {
        }

        public void actionPerformed(ActionEvent evnt) {
            String actionCommand = SplatalogueSearchDialog.this.getSelectMoleculeButton().getActionCommand();
            if (actionCommand == null) {
                return;
            }
            if ("selected".equals(actionCommand)) {
                this.update(evnt);
            }
        }

        private void update(ActionEvent evnt) {
            SplatalogueSearchErrors errors = SplatalogueSearchDialog.this.getInputErrors();
            errors.clear();
            errors.setUpdateMoleculeErrors();
            if (!errors.isEmpty()) {
                errors.displayHtml();
                return;
            }
            SelectedMolecule sm = new SelectedMolecule(SplatalogueSearchDialog.this.getMoleculeSearchCriteria());
            SplatalogueSearchDialog.this.getSelectedMoleculesListModel().replaceElement(sm);
            ((JButton)evnt.getSource()).setEnabled(false);
        }
    }
}

