/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.splatalogue;

import java.awt.Component;
import org.ferris.slise.splatalogue.SplatalogueSearchDialog;
import org.ferris.swing.JComponentErrors;

public class SplatalogueSearchErrors
extends JComponentErrors {
    private SplatalogueSearchDialog input = null;

    public SplatalogueSearchErrors(SplatalogueSearchDialog dialog) {
        this.input = dialog;
    }

    public Component getParent() {
        return this.input;
    }

    public void setSelectMoleculeErrors() {
        if (this.input.getAvailableMoleculesList().getSelectedIndex() < 0) {
            this.addError(this.input.getAvailableMoleculesList(), "Click on a specie from the list available.");
        }
        this.setDataInputErrors();
    }

    public void setUpdateMoleculeErrors() {
        if (this.input.getSelectedMoleculesList().getSelectedIndex() < 0) {
            this.addError(this.input.getSelectedMoleculesList(), "Click on a selected species to update its search criteria.");
        }
        this.setDataInputErrors();
    }

    private void setDataInputErrors() {
        this.addRequiredError(this.input.getTemperatureText(), "Temperature (K)");
        this.addNumericError(this.input.getTemperatureText(), "Temperature (K)");
        this.addRequiredError(this.input.getColumnDensityText(), "Column Density (cm <sup>-2</sup>)");
        this.addNumericError(this.input.getColumnDensityText(), "Column Density (cm <sup>-2</sup>)");
        this.addRequiredError(this.input.getLineWidthText(), "Line Width (km/s)");
        this.addNumericError(this.input.getLineWidthText(), "Line Width (km/s)");
        this.addNumericError(this.input.getBText(), "Filling Factor");
        this.addNumericError(this.input.getThetaAText(), "Theta A");
        this.addNumericError(this.input.getThetaBText(), "Theta B");
        this.addNumericError(this.input.getBackgroundTemperatureText(), "Background Temperature (K)");
        this.addNumericError(this.input.getEtaBText(), "&eta;<sub>b</sub>");
    }

    public void setPlotItErrors() {
        this.addNumericError(this.input.getFreqMinText(), "Minimum Frequency (MHz)");
        this.addNumericError(this.input.getFreqMaxText(), "Maximum Frequency (MHz)");
        this.addRequiredError(this.input.getFreqMinText(), "Minimum Frequency (MHz)", this.input.getFreqMaxText(), "Maximum Frequency (MHz)");
        this.addMinimumValueError(this.input.getFreqMinText(), this.input.getFreqMaxText(), "Minimum Frequency (MHz)");
        if (this.input.getSelectedMoleculesList().getModel().getSize() == 0) {
            this.addError(this.input.getSelectedMoleculesList(), "Selected Species is required.");
        }
    }
}

