/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.splatalogue;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.ferris.astronomy.data.source.Source;
import org.ferris.astronomy.data.sourcedata.SourceDataList;
import org.ferris.astronomy.data.telescope.TelescopeArrayType;
import org.ferris.losst.common.model.LosstModel;
import org.ferris.slise.data.source.MySourceBean;
import org.ferris.slise.model.SliseModel;
import org.ferris.slise.plot.PlotFrame;
import org.ferris.slise.source.AddSourceDialog;
import org.ferris.slise.source.SourceSelectedEvent;
import org.ferris.slise.source.SourceSelectedListener;
import org.ferris.slise.splatalogue.SyntheticSpectrumDialog;
import org.ferris.slise.swing.SliseFrame;
import org.ferris.swing.ui.ThrowableDialog;

public class SyntheticOrModelFrame
extends SliseFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel contentPanel = null;
    private JPanel buttonPanel = null;
    private JButton syntheticSpectrumButton = null;
    private JButton modelMyDataButton = null;
    private SliseModel sliseModel;
    private LosstModel losstModel;

    private SliseModel getSliseModel() {
        return this.sliseModel;
    }

    private LosstModel getLosstModel() {
        return this.losstModel;
    }

    public SyntheticOrModelFrame(SliseModel sliseModel, LosstModel losstModel) {
        this.sliseModel = sliseModel;
        this.losstModel = losstModel;
        this.initialize();
    }

    private void initialize() {
        this.setSize(183, 99);
        this.setContentPane(this.getJContentPane());
        this.setTitle("JFrame");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getContentPanel(), "Center");
        }
        return this.jContentPane;
    }

    public JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new GridBagLayout());
            this.contentPanel.add((Component)this.getButtonPanel(), new GridBagConstraints());
        }
        return this.contentPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints1.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints.gridy = 0;
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            this.buttonPanel.add((Component)this.getSyntheticSpectrumButton(), gridBagConstraints);
            this.buttonPanel.add((Component)this.getModelMyDataButton(), gridBagConstraints1);
        }
        return this.buttonPanel;
    }

    private JButton getSyntheticSpectrumButton() {
        if (this.syntheticSpectrumButton == null) {
            this.syntheticSpectrumButton = new JButton();
            this.syntheticSpectrumButton.setActionCommand("syntheticSpectrum");
            this.syntheticSpectrumButton.setText("Synthetic Spectrum");
            this.syntheticSpectrumButton.addActionListener(new SyntheticSpectrumAction(null, null));
        }
        return this.syntheticSpectrumButton;
    }

    private JButton getModelMyDataButton() {
        if (this.modelMyDataButton == null) {
            this.modelMyDataButton = new JButton();
            this.modelMyDataButton.setActionCommand("modelMyData");
            this.modelMyDataButton.setText("Model My Data");
            this.modelMyDataButton.setEnabled(false);
            this.modelMyDataButton.addActionListener(new ModelMyDataAction());
        }
        return this.modelMyDataButton;
    }

    private class ModelMyDataAction
    extends SyntheticSpectrumAction
    implements SourceSelectedListener {
        boolean sourceAdded;

        private ModelMyDataAction() {
        }

        public void actionPerformed(ActionEvent e) {
            this.collectData();
            if (this.sourceAdded) {
                this.plot();
            }
        }

        protected void collectData() {
            super.collectData();
            this.sourceAdded = false;
            AddSourceDialog dialog = new AddSourceDialog(null, this, false);
            dialog.getVelocityText().setText(this.velocityStr);
            dialog.setTitle("Select Source");
            dialog.getMhzRadioButton().setSelected(true);
            dialog.getGhzRadioButton().setVisible(false);
            dialog.setVisible(true);
        }

        public void addSource(SourceSelectedEvent evnt) {
            this.frequencyMultiplier = evnt.getFrequencyMultiplier();
            this.velocity = evnt.getVelocity();
            try {
                this.source = (MySourceBean)SyntheticOrModelFrame.this.getSliseModel().getUserSource(evnt.getSourceDataFile(), evnt.getSourceDataFile().getName(), this.velocity, this.frequencyMultiplier);
                this.map = SyntheticOrModelFrame.this.sliseModel.getUserSourceDataMap(this.freqMinMax[0], this.freqMinMax[1], (Source)this.source);
                this.sourceAdded = true;
            }
            catch (Throwable e) {
                new ThrowableDialog(e, false);
            }
        }
    }

    private class SyntheticSpectrumAction
    implements ActionListener {
        protected Map<String, SourceDataList> map;
        protected double[] freqMinMax;
        protected String velocityStr;
        protected double velocity;
        protected String velocityResStr;
        protected double velocityRes;
        protected double frequencyMultiplier;
        protected TelescopeArrayType type;
        protected MySourceBean source;

        private SyntheticSpectrumAction() {
        }

        public void actionPerformed(ActionEvent e) {
            this.collectData();
            this.plot();
        }

        protected void collectData() {
            SyntheticSpectrumDialog dialog = new SyntheticSpectrumDialog(null, SyntheticOrModelFrame.this.getSliseModel());
            dialog.setVisible(true);
            this.type = dialog.getTelescopeArrayType();
            this.freqMinMax = dialog.getFreqMinMax();
            this.frequencyMultiplier = 1.0;
            this.velocityStr = dialog.getVelocityText().getText();
            this.velocity = dialog.getVelocity();
            this.velocityResStr = dialog.getVelocityResText().getText();
            this.velocityRes = dialog.getVelocityRes();
            try {
                this.source = (MySourceBean)SyntheticOrModelFrame.this.getSliseModel().getEmptySource("Synthetic Spectrum", this.velocity, this.frequencyMultiplier);
            }
            catch (Throwable e) {
                new ThrowableDialog(e, true);
            }
            this.map = new HashMap<String, SourceDataList>();
            if (this.type == null) {
                return;
            }
        }

        protected void plot() {
            PlotFrame plot = new PlotFrame(SyntheticOrModelFrame.this.getSliseModel(), SyntheticOrModelFrame.this.getLosstModel(), this.type);
            try {
                plot.plot(this.map, this.freqMinMax, this.velocity, this.velocityRes, this.source);
                plot.setVisible(true);
            }
            catch (Throwable t) {
                new ThrowableDialog(t, true).setVisible(true);
            }
        }

        /* synthetic */ SyntheticSpectrumAction(SyntheticSpectrumAction syntheticSpectrumAction, SyntheticSpectrumAction syntheticSpectrumAction2) {
            this();
        }
    }
}

