/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.splatalogue;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.ferris.astronomy.data.telescope.TelescopeArrayType;
import org.ferris.astronomy.math.BigDecimalTools;
import org.ferris.losst.common.search.FrequencySearchCriteriaPanel;
import org.ferris.slise.model.SliseModel;
import org.ferris.slise.splatalogue.SyntheticSpectrumErrors;
import org.ferris.swing.ui.ThrowableDialog;

public class SyntheticSpectrumDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel contentPanel = null;
    private JPanel radioButtonsPanel = null;
    private ButtonGroup radioButtonGroup = null;
    private JRadioButton arrayRadioButton = null;
    private JRadioButton singleDishRadioButton = null;
    private JButton goButton = null;
    private SliseModel sliseModel = null;
    private TelescopeArrayType telescopeArrayType = null;
    private FrequencySearchCriteriaPanel frequencySearchCriteriaPanel = null;
    private JLabel frequencyLabel = null;
    private JLabel frequencySpacerLabel = null;
    private JLabel velocitySpacerLabel = null;
    private JLabel velocityLabel = null;
    private JTextField velocityText = null;
    private JLabel velocityResSpacerLabel = null;
    private JLabel velocityResLabel = null;
    private JTextField velocityResText = null;
    private JLabel telescopeTypeSpacerLabel = null;
    private JLabel telescopeTypeLabel = null;
    private JPanel buttonPanel = null;
    private SyntheticSpectrumErrors syntheticSpectrumErrors = null;

    private SyntheticSpectrumErrors getSyntheticSpectrumErrors() {
        if (this.syntheticSpectrumErrors == null) {
            this.syntheticSpectrumErrors = new SyntheticSpectrumErrors(this);
        }
        return this.syntheticSpectrumErrors;
    }

    private SliseModel getSliseModel() {
        return this.sliseModel;
    }

    private void setSliseModel(SliseModel sliseModel) {
        this.sliseModel = sliseModel;
    }

    public TelescopeArrayType getTelescopeArrayType() {
        return this.telescopeArrayType;
    }

    private void setTelescopeArrayType(TelescopeArrayType telescopeArrayType) {
        this.telescopeArrayType = telescopeArrayType;
    }

    public SyntheticSpectrumDialog(Frame parent, SliseModel model) {
        super(parent, "", true);
        this.initialize();
        this.setSliseModel(model);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(parent);
    }

    private void initialize() {
        this.setSize(460, 281);
        this.setTitle("Synthetic Spectrum");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getContentPanel(), "North");
        }
        return this.jContentPane;
    }

    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.insets = new Insets(10, 0, 10, 0);
            gridBagConstraints9.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new GridBagLayout());
            this.contentPanel.add((Component)this.getRadioButtonsPanel(), gridBagConstraints2);
            this.contentPanel.add((Component)this.getButtonPanel(), gridBagConstraints9);
        }
        return this.contentPanel;
    }

    private JPanel getRadioButtonsPanel() {
        if (this.radioButtonsPanel == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridy = 5;
            this.telescopeTypeLabel = new JLabel();
            this.telescopeTypeLabel.setText("<html><body>Telescope Type<font color=\"red\">*</font> :</body></html>");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 4;
            this.telescopeTypeSpacerLabel = new JLabel();
            this.telescopeTypeSpacerLabel.setText("  ");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.gridy = 3;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraintsU = new GridBagConstraints();
            gridBagConstraintsU.fill = 1;
            gridBagConstraintsU.gridy = 4;
            gridBagConstraintsU.weightx = 1.0;
            gridBagConstraintsU.insets = new Insets(0, 5, 0, 5);
            gridBagConstraintsU.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 3;
            this.velocityLabel = new JLabel();
            this.velocityLabel.setText("<html><body>LSR Velocity (km/s)<font color=\"red\">*</font> :</body></html>");
            GridBagConstraints gridBagConstraintsW = new GridBagConstraints();
            gridBagConstraintsW.gridx = 0;
            gridBagConstraintsW.gridy = 4;
            this.velocityResLabel = new JLabel();
            this.velocityResLabel.setText("<html><body>Velocity Resolution (km/s)<font color=\"red\">*</font> :</body></html>");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 2;
            this.velocitySpacerLabel = new JLabel();
            this.velocitySpacerLabel.setText("  ");
            GridBagConstraints gridBagConstraintsV = new GridBagConstraints();
            gridBagConstraintsV.gridx = 0;
            gridBagConstraintsV.gridy = 3;
            this.velocityResSpacerLabel = new JLabel();
            this.velocityResSpacerLabel.setText("  ");
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 1;
            gridBagConstraints31.gridy = 1;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.gridy = 0;
            this.frequencySpacerLabel = new JLabel();
            this.frequencySpacerLabel.setText("   ");
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints11.anchor = 11;
            gridBagConstraints11.gridy = 1;
            this.frequencyLabel = new JLabel();
            this.frequencyLabel.setText("<html><body>Frequency<font color=\"red\">*</font> :</body></html>");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 6;
            gridBagConstraints1.fill = 2;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.fill = 2;
            this.radioButtonsPanel = new JPanel();
            this.radioButtonsPanel.setLayout(new GridBagLayout());
            this.radioButtonsPanel.add((Component)this.getArrayRadioButton(), gridBagConstraints);
            this.radioButtonsPanel.add((Component)this.getSingleDishRadioButton(), gridBagConstraints1);
            this.radioButtonsPanel.add((Component)this.frequencyLabel, gridBagConstraints11);
            this.radioButtonsPanel.add((Component)this.frequencySpacerLabel, gridBagConstraints21);
            this.radioButtonsPanel.add((Component)this.getFrequencySearchCriteriaPanel(), gridBagConstraints31);
            this.radioButtonsPanel.add((Component)this.velocitySpacerLabel, gridBagConstraints4);
            this.radioButtonsPanel.add((Component)this.velocityLabel, gridBagConstraints5);
            this.radioButtonsPanel.add((Component)this.getVelocityText(), gridBagConstraints6);
            this.radioButtonsPanel.add((Component)this.velocityResSpacerLabel, gridBagConstraintsV);
            this.radioButtonsPanel.add((Component)this.velocityResLabel, gridBagConstraintsW);
            this.radioButtonsPanel.add((Component)this.getVelocityResText(), gridBagConstraintsU);
            this.radioButtonsPanel.add((Component)this.telescopeTypeSpacerLabel, gridBagConstraints7);
            this.radioButtonsPanel.add((Component)this.telescopeTypeLabel, gridBagConstraints8);
        }
        return this.radioButtonsPanel;
    }

    public double getFrequencyMultiplier() {
        if (this.getFrequencySearchCriteriaPanel().getGhzBtn().isSelected()) {
            return 1000.0;
        }
        return 1.0;
    }

    public ButtonGroup getRadioButtonGroup() {
        if (this.radioButtonGroup == null) {
            this.radioButtonGroup = new ButtonGroup();
        }
        return this.radioButtonGroup;
    }

    private JRadioButton getArrayRadioButton() {
        if (this.arrayRadioButton == null) {
            this.arrayRadioButton = new JRadioButton();
            this.arrayRadioButton.setText("Array");
            this.getRadioButtonGroup().add(this.arrayRadioButton);
        }
        return this.arrayRadioButton;
    }

    private JRadioButton getSingleDishRadioButton() {
        if (this.singleDishRadioButton == null) {
            this.singleDishRadioButton = new JRadioButton();
            this.singleDishRadioButton.setText("Single Dish");
            this.singleDishRadioButton.setEnabled(false);
            this.getRadioButtonGroup().add(this.singleDishRadioButton);
        }
        return this.singleDishRadioButton;
    }

    private JButton getGoButton() {
        if (this.goButton == null) {
            this.goButton = new JButton();
            this.goButton.setActionCommand("go");
            this.goButton.setText("Go");
            this.goButton.addActionListener(new GoAction());
        }
        return this.goButton;
    }

    public FrequencySearchCriteriaPanel getFrequencySearchCriteriaPanel() {
        if (this.frequencySearchCriteriaPanel == null) {
            this.frequencySearchCriteriaPanel = new FrequencySearchCriteriaPanel();
        }
        return this.frequencySearchCriteriaPanel;
    }

    public JTextField getVelocityText() {
        if (this.velocityText == null) {
            this.velocityText = new JTextField();
        }
        return this.velocityText;
    }

    public JTextField getVelocityResText() {
        if (this.velocityResText == null) {
            this.velocityResText = new JTextField();
        }
        return this.velocityResText;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.gridx = -1;
            gridBagConstraints3.gridy = -1;
            gridBagConstraints3.insets = new Insets(5, 0, 5, 0);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            this.buttonPanel.setBorder(new SoftBevelBorder(0));
            this.buttonPanel.add((Component)this.getGoButton(), gridBagConstraints3);
        }
        return this.buttonPanel;
    }

    public JTextField getFreqMinText() {
        return this.getFrequencySearchCriteriaPanel().getFreqMinText();
    }

    public JTextField getFreqMaxText() {
        return this.getFrequencySearchCriteriaPanel().getFreqMaxText();
    }

    public JTextField getFreqCenterText() {
        return this.getFrequencySearchCriteriaPanel().getFreqCenterText();
    }

    public JTextField getFreqPlusMinusText() {
        return this.getFrequencySearchCriteriaPanel().getFreqPlusMinusText();
    }

    public double[] getFreqMinMax() {
        return new double[]{this.getFrequencySearchCriteriaPanel().getFreqMin(), this.getFrequencySearchCriteriaPanel().getFreqMax()};
    }

    public double getVelocity() {
        return BigDecimalTools.getBigDecimal((String)this.getVelocityText().getText()).doubleValue();
    }

    public double getVelocityRes() {
        return BigDecimalTools.getBigDecimal((String)this.getVelocityResText().getText()).doubleValue();
    }

    private class GoAction
    implements ActionListener {
        private GoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SyntheticSpectrumErrors errors = SyntheticSpectrumDialog.this.getSyntheticSpectrumErrors();
            errors.clear();
            errors.setErrors();
            if (!errors.isEmpty()) {
                errors.displayHtml();
            } else {
                try {
                    if (SyntheticSpectrumDialog.this.getArrayRadioButton().isSelected()) {
                        SyntheticSpectrumDialog.this.setTelescopeArrayType(SyntheticSpectrumDialog.this.getSliseModel().getArrayTelescopeType());
                        SyntheticSpectrumDialog.this.dispose();
                    } else if (SyntheticSpectrumDialog.this.getSingleDishRadioButton().isSelected()) {
                        SyntheticSpectrumDialog.this.setTelescopeArrayType(SyntheticSpectrumDialog.this.getSliseModel().getSingleDishTelescopeType());
                        SyntheticSpectrumDialog.this.dispose();
                    }
                }
                catch (Throwable t) {
                    new ThrowableDialog(t, true).setVisible(true);
                }
            }
        }
    }
}

