/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.slise.splatalogue;

import java.awt.Component;
import javax.swing.JTextField;
import org.ferris.astronomy.math.BigDecimalTools;
import org.ferris.slise.splatalogue.SyntheticSpectrumDialog;
import org.ferris.swing.JComponentErrors;

public class SyntheticSpectrumErrors
extends JComponentErrors {
    private SyntheticSpectrumDialog parent;

    public SyntheticSpectrumErrors(SyntheticSpectrumDialog parent) {
        this.parent = parent;
    }

    public Component getParent() {
        return this.parent;
    }

    public void setErrors() {
        JTextField text = null;
        text = this.parent.getFreqMinText();
        this.addNumericError(text, "Minimum Frequency (MHz)");
        text = this.parent.getFreqMaxText();
        this.addNumericError(text, "Maximum Frequency (MHz)");
        this.addRequiredError(this.parent.getFreqMinText(), "Minimum Frequency (MHz)", this.parent.getFreqMaxText(), "Maximum Frequency (MHz)");
        this.addMinimumValueError(this.parent.getFreqMinText(), this.parent.getFreqMaxText(), "Minimum Frequency (MHz)");
        this.addNoMoreThanGigahertzError(this.parent.getFreqMaxText(), this.parent.getFreqMinText(), "Minimum Frequency (MHz)");
        text = this.parent.getFreqCenterText();
        this.addNumericError(text, "Center Frequency (MHz)");
        this.addRequiredError(new JTextField[]{this.parent.getFreqMinText(), this.parent.getFreqMaxText(), this.parent.getFreqCenterText(), this.parent.getFreqPlusMinusText()}, "Either Min/Max or Center/Offset Frequency ");
        text = this.parent.getVelocityText();
        this.addNumericError(text, "LSR Velocity (km/s)");
        this.addRequiredError(text, "LSR Velocity (km/s)");
        this.addRequiredError(this.parent.getRadioButtonGroup(), "Telescope type");
    }

    public void addNoMoreThanGigahertzError(JTextField freqMaxText, JTextField freqMinText, String string) {
        if (freqMaxText.getText().length() > 0 && freqMinText.getText().length() > 0) {
            try {
                double d1 = BigDecimalTools.getBigDecimal((String)freqMaxText.getText()).doubleValue();
                double d2 = BigDecimalTools.getBigDecimal((String)freqMinText.getText()).doubleValue();
                if (this.parent.getFrequencySearchCriteriaPanel().getGhzBtn().isSelected()) {
                    d1 *= 1000.0;
                    d2 *= 1000.0;
                }
                if (d1 - d2 > 1000.0) {
                    this.addError(freqMaxText, "Frequency range must be less or equal to 1000 MHz");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

