
\connect "MARKET"

-- -----------------------------------------------------------------------------
-- Table: markets
-- -----------------------------------------------------------------------------
CREATE TABLE markets
(
  id character varying(36) NOT NULL,
  created_on timestamp with time zone NOT NULL,
  updated_on timestamp with time zone NOT NULL,
  code character varying(5) NOT NULL,
  description character varying(30) NOT NULL,
  CONSTRAINT markets_pk PRIMARY KEY (id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE markets OWNER TO postgres;



-- -----------------------------------------------------------------------------
-- Table: year_end_prices
-- -----------------------------------------------------------------------------
CREATE TABLE year_end_prices
(
  id character varying(36) NOT NULL,
  created_on timestamp with time zone NOT NULL,
  updated_on timestamp with time zone NOT NULL,
  market_ptr character varying(36) NOT NULL,
  "year" integer NOT NULL,
  price numeric(10,2) NOT NULL,  
  CONSTRAINT year_end_prices_pk PRIMARY KEY (id),
  CONSTRAINT year_end_prices_market_fk FOREIGN KEY (market_ptr)
      REFERENCES markets (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE year_end_prices OWNER TO postgres;


-- -----------------------------------------------------------------------------
-- Table: day_end_prices
-- -----------------------------------------------------------------------------
CREATE TABLE day_end_prices
(
  id character varying(36) NOT NULL,
  created_on timestamp with time zone NOT NULL,
  updated_on timestamp with time zone NOT NULL,  
  market_ptr character varying(36) NOT NULL,
  "day" date NOT NULL,
  price numeric(10,2) NOT NULL DEFAULT 0.00,   
  CONSTRAINT day_end_price_pk PRIMARY KEY (id),
  CONSTRAINT day_end_prices_market_fk FOREIGN KEY (market_ptr)
      REFERENCES markets (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT day_market_uniq UNIQUE (day, market_ptr)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE day_end_prices OWNER TO postgres;


-- -----------------------------------------------------------------------------
-- Table: futures_expirations
-- -----------------------------------------------------------------------------
CREATE TABLE futures_expirations
(
  id character varying(36) NOT NULL,
  created_on timestamp with time zone NOT NULL,
  updated_on timestamp with time zone NOT NULL,
  market_ptr character varying(36) NOT NULL,
  contract_description character varying(30) NOT NULL,
  contract_month char NOT NULL,
  contract_year int NOT NULL,
  last_trading_day date NOT NULL, 
  CONSTRAINT futures_expirations_pk PRIMARY KEY (id),
  CONSTRAINT futures_expirations_market_fk FOREIGN KEY (market_ptr)
      REFERENCES markets (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (
  OIDS=FALSE
);
ALTER TABLE futures_expirations OWNER TO postgres;



-- -----------------------------------------------------------------------------
-- Table: email_addresses
--
--  type: bcc, cc, to, from, reply
-- -----------------------------------------------------------------------------
CREATE TABLE email_addresses
(
  id character varying(36) NOT NULL,
  created_on timestamp with time zone NOT NULL,
  updated_on timestamp with time zone NOT NULL,
  "type" character varying(5) NOT NULL,
  address character varying(50) NOT NULL,
  "name" character varying(50) NOT NULL,  
  CONSTRAINT email_addresses_pk PRIMARY KEY (id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE email_addresses OWNER TO postgres;