/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.yahoo.finance.jmce.bean;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import org.apache.commons.lang.StringEscapeUtils;
import org.ferris.yahoo.finance.jmce.bean.Market;
import org.ferris.yahoo.finance.jmce.lang.StringBufferWrapper;

public class Message {
    private StringBufferWrapper sp = new StringBufferWrapper();
    private DecimalFormat dformat = new DecimalFormat("#,###.00");
    private DecimalFormat pformat = new DecimalFormat("#,###.00%");

    private String getStyle(double doub) {
        return this.getStyle(String.format("%f", doub));
    }

    private String getStyle(String str) {
        if (str.charAt(0) == '+') {
            return " style=\"text-align:right;font-family:courier;color:green;\" ";
        }
        if (str.charAt(0) == '-') {
            return " style=\"text-align:right;font-family:courier;color:red;\" ";
        }
        return " style=\"text-align:right;font-family:courier;color:green;\" ";
    }

    public String toString() {
        return this.sp.toString();
    }

    public void writeStart() {
        this.sp.appendLine("<h2>Market Summary</h2>");
        this.sp.appendLine("<a style=\"color:blue; text-decoration:underline; font-weight:bold;\" href=\"http://finance.yahoo.com/\">Go To Yahoo! Finance</a><br /><br />");
        this.sp.appendLine("<table border=\"1\" cellpadding=\"3\">");
    }

    public void writeEnd() {
        this.sp.appendLine("</table>");
    }

    public void writeHeader(int lastYear) {
        this.sp.appendLine("<tr>");
        this.sp.appendLine("<th>");
        this.sp.appendLine("MARKET");
        this.sp.appendLine("</th>");
        this.sp.appendLine("<th style=\"vertical-align:top;\">");
        this.sp.appendLine("" + lastYear);
        this.sp.appendLine("<br />");
        this.sp.appendLine("CLOSING");
        this.sp.appendLine("</th>");
        this.sp.appendLine("<th style=\"vertical-align:top;\">");
        this.sp.appendLine("DAY<br/>CLOSING");
        this.sp.appendLine("</th>");
        this.sp.appendLine("<th style=\"vertical-align:top;\">");
        this.sp.appendLine("DAY<br/>VALUE<br/>CHANGE");
        this.sp.appendLine("</th>");
        this.sp.appendLine("<th style=\"vertical-align:top;\">");
        this.sp.appendLine("DAY<br/>PERCENT<br/>CHANGE");
        this.sp.appendLine("</th>");
        this.sp.appendLine("<th style=\"vertical-align:top;\">");
        this.sp.appendLine("YTD<br/>VALUE<br/>CHANGE");
        this.sp.appendLine("</th>");
        this.sp.appendLine("<th style=\"vertical-align:top;\">");
        this.sp.appendLine("YTD<br/>PERCENT<br/>CHANGE");
        this.sp.appendLine("</th>");
        this.sp.appendLine("</tr>");
    }

    public void writeMarket(Market market) {
        this.sp.appendLine("<tr>");
        this.sp.appendLine("<td style=\"font-weight:bold;\">");
        this.sp.appendLine(StringEscapeUtils.escapeHtml((String)market.getName()));
        this.sp.appendLine("</td>");
        this.sp.appendLine("<td style=\"text-align:right;font-family:courier;\">");
        this.sp.appendLine(market.getPriceAtEndOfLastYear() == 0.0 ? "unknown" : this.dformat.format(market.getPriceAtEndOfLastYear()));
        this.sp.appendLine("</td>");
        this.sp.appendLine("<td style=\"text-align:right;font-family:courier;\">");
        this.sp.appendLine(this.dformat.format(market.getPriceAtEndOfDay()));
        this.sp.appendLine("</td>");
        this.sp.appendLine("<td " + this.getStyle(market.getPriceChangeSinceYesterday()) + ">");
        this.sp.appendLine(market.getPriceChangeSinceYesterday());
        this.sp.appendLine("</td>");
        this.sp.appendLine("<td " + this.getStyle(market.getPercentageChangeSinceYesterday()) + ">");
        this.sp.appendLine(market.getPercentageChangeSinceYesterday());
        this.sp.appendLine("</td>");
        this.sp.appendLine("<td " + this.getStyle(market.getPriceChangeSinceEndOfLastYear()) + ">");
        this.sp.appendLine(Double.isNaN(market.getPriceChangeSinceEndOfLastYear()) ? "unknown" : this.dformat.format(market.getPriceChangeSinceEndOfLastYear()));
        this.sp.appendLine("</td>");
        this.sp.appendLine("<td " + this.getStyle(market.getPercentageChangeSinceEndOfLastYear()) + ">");
        this.sp.appendLine(Double.isNaN(market.getPercentageChangeSinceEndOfLastYear()) ? "unknown" : this.pformat.format(market.getPercentageChangeSinceEndOfLastYear() / 100.0));
        this.sp.appendLine("</td>");
        this.sp.appendLine("</tr>");
    }

    public void setThrowable(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        this.sp.appendLine(sw.toString());
        pw.close();
    }
}

