/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.yahoo.finance.jmce.handler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class AbstractHandlerBySql {
    private static final Logger log = Logger.getLogger(AbstractHandlerBySql.class);
    private DataSource dataSource;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Setting DataSource %s", String.valueOf(dataSource)));
        }
        this.dataSource = dataSource;
    }

    public Connection getConnection() {
        Connection conn = null;
        try {
            conn = this.getDataSource().getConnection();
        }
        catch (Throwable t) {
            throw new RuntimeException("Problem getting Connection", t);
        }
        return conn;
    }

    public void close(Connection conn, Statement stmt, ResultSet rs) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Throwable ignore) {
                log.warn((Object)"Problem closing Connection", ignore);
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable ignore) {
                log.warn((Object)"Problem closing Statement", ignore);
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Throwable ignore) {
                log.warn((Object)"Problem closing ResultSet", ignore);
            }
        }
    }

    protected PreparedStatement prepareStatement(Connection conn, String sql) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Preparing statement \"%s\"", sql));
        }
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql);
        }
        catch (Throwable t) {
            throw new RuntimeException("Problem preparing statement", t);
        }
        return stmt;
    }

    protected PreparedStatement setInt(PreparedStatement stmt, int idx, int value) {
        try {
            stmt.setInt(idx, value);
            return stmt;
        }
        catch (Throwable t) {
            throw new RuntimeException("Problem setting int", t);
        }
    }

    protected PreparedStatement setDouble(PreparedStatement stmt, int idx, double value) {
        try {
            stmt.setDouble(idx, value);
            return stmt;
        }
        catch (Throwable t) {
            throw new RuntimeException("Problem setting double", t);
        }
    }

    protected PreparedStatement setString(PreparedStatement stmt, int idx, String value) {
        try {
            stmt.setString(idx, value);
            return stmt;
        }
        catch (Throwable t) {
            throw new RuntimeException("Problem setting String", t);
        }
    }

    protected PreparedStatement setDate(PreparedStatement stmt, int idx, Date value) {
        try {
            stmt.setDate(idx, new java.sql.Date(value.getTime()));
            return stmt;
        }
        catch (Throwable t) {
            throw new RuntimeException("Problem setting Date", t);
        }
    }

    protected PreparedStatement setTimestamp(PreparedStatement stmt, int idx, Calendar value) {
        try {
            stmt.setTimestamp(idx, new Timestamp(value.getTimeInMillis()));
            return stmt;
        }
        catch (Throwable t) {
            throw new RuntimeException("Problem setting Date", t);
        }
    }

    protected ResultSet executeQuery(PreparedStatement stmt) {
        try {
            return stmt.executeQuery();
        }
        catch (Throwable t) {
            throw new RuntimeException("Problem executing query", t);
        }
    }

    protected int executeUpdate(PreparedStatement stmt) {
        try {
            return stmt.executeUpdate();
        }
        catch (Throwable t) {
            throw new RuntimeException("Problem executing query", t);
        }
    }
}

