/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.yahoo.finance.jmce.handler;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ferris.yahoo.finance.jmce.bean.Future;
import org.ferris.yahoo.finance.jmce.handler.CmeGroupHandler;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class CmeGroupHandlerByJson
implements CmeGroupHandler {
    private static final Logger log = Logger.getLogger(CmeGroupHandlerByJson.class);

    @Override
    public Future getGreatestOpenInterestFutureForGold() {
        try {
            List<JSONObject> matching;
            JSONArray message;
            JSONObject marketDataInfoAsStringList;
            JSONObject jsonObject;
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("ENTER getGreatestOpenInterestFutureForGold()", new Object[0]));
            }
            Calendar calendar = Calendar.getInstance();
            String urlString = String.format("http://www.cmegroup.com/CmeWS/md/MDServer/V1/Venue/G/Exchange/XCEC/FOI/FUT/Product/GC?currentTime=%d&contractCDs=,GCG2,GCH2,GCJ2,GCK2,GCM2,GCQ2,GCV2,GCZ2,GCG3,GCJ3,GCM3,GCQ3,GCV3,GCZ3,GCM4,GCZ4,GCM5,GCZ5,GCM6,GCZ6,GCM7,GCZ7,GCG2,GCH2,GCJ2,GCK2,GCM2,GCQ2,GCV2,GCZ2,GCG3,GCJ3,GCM3,GCQ3,GCV3,GCZ3,GCM4,GCZ4,GCM5,GCZ5,GCM6,GCZ6,GCM7,GCZ7", calendar.getTimeInMillis());
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("URL String: %s", urlString));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Open connection", new Object[0]));
            }
            URL url = new URL(urlString);
            URLConnection conn = url.openConnection();
            InputStream is = conn.getInputStream();
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Read InputSteam into String", new Object[0]));
            }
            String jsonString = IOUtils.toString((InputStream)is);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("String is \"%s\"", jsonString));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Create JSONParser", new Object[0]));
            }
            JSONParser parser = new JSONParser();
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Parse JSON String into JSONObject", new Object[0]));
            }
            if ((jsonObject = (JSONObject)parser.parse(jsonString)) == null) {
                throw new RuntimeException("Parser did not create a JSONObject");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Get key \"marketDataInfoAsStringList\"", new Object[0]));
            }
            if ((marketDataInfoAsStringList = (JSONObject)jsonObject.get((Object)"marketDataInfoAsStringList")) == null) {
                throw new RuntimeException("marketDataInfoAsStringList is null");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Get key \"market\"", new Object[0]));
            }
            if ((message = (JSONArray)marketDataInfoAsStringList.get((Object)"message")) == null) {
                throw new RuntimeException("message is null");
            }
            int greatestOpenInterest = this.getGreatestOpenInterest(message);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Greatest Open Interest: %d\n", greatestOpenInterest));
            }
            if ((matching = this.getMatchingGreatestOpenInterest(message, greatestOpenInterest)).isEmpty()) {
                throw new RuntimeException("No matching greatest open interest found!");
            }
            Future future = new Future(StringUtils.trimToEmpty((String)((String)matching.get(0).get((Object)"ticker"))), greatestOpenInterest);
            if (future.getTicker().isEmpty()) {
                throw new RuntimeException("Value for property \"ticker\" is empty");
            }
            return future;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }

    private List<JSONObject> getMatchingGreatestOpenInterest(JSONArray jsonArray, int greatestOpenInterest) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getMatchingGreatestOpenInterest(%s,%d)", jsonArray, greatestOpenInterest));
        }
        LinkedList<JSONObject> matches = new LinkedList<JSONObject>();
        for (Object obj : jsonArray) {
            JSONObject jsonObj = (JSONObject)obj;
            String openInterest = (String)jsonObj.get((Object)"openInterest");
            if (openInterest.equals("-")) continue;
            try {
                int openInterestInt = Integer.parseInt(openInterest);
                if (openInterestInt != greatestOpenInterest) continue;
                matches.add(jsonObj);
            }
            catch (Throwable ignore) {}
        }
        return matches;
    }

    private int getGreatestOpenInterest(JSONArray jsonArray) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getGreatestOpenInterest(%s)", jsonArray));
        }
        int greatest = 0;
        for (Object obj : jsonArray) {
            JSONObject jsonObj = (JSONObject)obj;
            String openInterest = (String)jsonObj.get((Object)"openInterest");
            if (openInterest.equals("-")) continue;
            try {
                int openInterestInt = Integer.parseInt(openInterest);
                greatest = Math.max(greatest, openInterestInt);
            }
            catch (Throwable ignore) {}
        }
        return greatest;
    }
}

