/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.yahoo.finance.jmce.handler;

import java.text.DecimalFormat;
import org.apache.log4j.Logger;
import org.ferris.yahoo.finance.jmce.bean.FuturesExpirations;
import org.ferris.yahoo.finance.jmce.bean.Oil;
import org.ferris.yahoo.finance.jmce.bean.YearEndPrice;
import org.ferris.yahoo.finance.jmce.handler.AbstractHandlerByScrape;
import org.ferris.yahoo.finance.jmce.handler.CalendarHandler;
import org.ferris.yahoo.finance.jmce.handler.CrudeOilHandler;
import org.ferris.yahoo.finance.jmce.handler.FuturesExpirationsHandler;
import org.ferris.yahoo.finance.jmce.net.HtmlPageContents;

public class CrudeOilHandlerByScrape
extends AbstractHandlerByScrape
implements CrudeOilHandler {
    private static final Logger log = Logger.getLogger(CrudeOilHandlerByScrape.class);
    private FuturesExpirationsHandler futuresExpirationsHandler;
    private CalendarHandler calendarHandler;

    @Override
    public Oil getByCurrentContract() {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getByCurrentContract()", new Object[0]));
        }
        try {
            FuturesExpirations futures = this.getFuturesExpirationsHandler().getForCrudeOil();
            if (futures == null) {
                throw new RuntimeException(String.format("A futures last trading date could not be found for OIL", new Object[0]));
            }
            String yahooTickerSymbol = String.format("%s%s%d.nym", futures.getTickerSymbol(), Character.valueOf(futures.getContractMonth()), futures.getContractYear()).toLowerCase();
            HtmlPageContents pageContents = this.getHtmlPageContents(String.format("http://finance.yahoo.com/q?s=%s", yahooTickerSymbol));
            String value = pageContents.getContentsOfTagByIds(String.format("yfs_l10_%s", yahooTickerSymbol));
            String valueChange = pageContents.getContentsOfTagByIds(String.format("yfs_c10_%s", yahooTickerSymbol));
            String percentageChange = pageContents.getContentsOfTagByIds(String.format("yfs_p20_%s", yahooTickerSymbol));
            valueChange = String.format("%s%s", this.getMarketDown(pageContents), valueChange);
            percentageChange = String.format("%s%s", this.getMarketDown(pageContents), percentageChange);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Create Oil bean and set data", new Object[0]));
            }
            Oil bean = new Oil();
            bean.setName(String.format("%s (%s)", bean.getName(), yahooTickerSymbol));
            bean.setPriceAtEndOfDay(DecimalFormat.getNumberInstance().parse(value).doubleValue());
            bean.setPriceChangeSinceYesterday(valueChange);
            bean.setPercentageChangeSinceYesterday(percentageChange);
            YearEndPrice yearEndPrice = this.getYearEndPriceHandler().getYearEndPriceForOil(this.getCalendarHandler().getLastYear());
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Year end price \"%s\"", String.valueOf(yearEndPrice)));
            }
            if (yearEndPrice != null) {
                bean.setPriceAtEndOfLastYear(yearEndPrice.getPrice().doubleValue());
            }
            return bean;
        }
        catch (Throwable t) {
            log.fatal((Object)"Couldn't get oil by current contract", t);
            throw new RuntimeException(t);
        }
    }

    public FuturesExpirationsHandler getFuturesExpirationsHandler() {
        return this.futuresExpirationsHandler;
    }

    public void setFuturesExpirationsHandler(FuturesExpirationsHandler futuresExpirationsHandler) {
        this.futuresExpirationsHandler = futuresExpirationsHandler;
    }

    public CalendarHandler getCalendarHandler() {
        return this.calendarHandler;
    }

    public void setCalendarHandler(CalendarHandler calendarHandler) {
        this.calendarHandler = calendarHandler;
    }
}

