/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.yahoo.finance.jmce.handler;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.ferris.yahoo.finance.jmce.bean.DayEndPrice;
import org.ferris.yahoo.finance.jmce.bean.Market;
import org.ferris.yahoo.finance.jmce.handler.AbstractHandlerBySql;
import org.ferris.yahoo.finance.jmce.handler.CalendarHandler;
import org.ferris.yahoo.finance.jmce.handler.DayEndPriceHandler;
import org.ferris.yahoo.finance.jmce.handler.PrimaryKeyHandler;

public class DayEndPriceHandlerBySql
extends AbstractHandlerBySql
implements DayEndPriceHandler {
    private static final Logger log = Logger.getLogger(DayEndPriceHandlerBySql.class);
    public CalendarHandler calendarHandler;
    private PrimaryKeyHandler primaryKeyHandler;

    public CalendarHandler getCalendarHandler() {
        return this.calendarHandler;
    }

    public void setCalendarHandler(CalendarHandler calendarHandler) {
        this.calendarHandler = calendarHandler;
    }

    public PrimaryKeyHandler getPrimaryKeyHandler() {
        return this.primaryKeyHandler;
    }

    public void setPrimaryKeyHandler(PrimaryKeyHandler primaryKeyHandler) {
        this.primaryKeyHandler = primaryKeyHandler;
    }

    @Override
    public DayEndPrice getDayEndPriceForGold(Calendar day) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getDayEndPriceForGold(%s)", day));
        }
        return this.getDayEndPriceForMarket(day, Market.Code.gc);
    }

    @Override
    public DayEndPrice getDayEndPriceForOil(Calendar day) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getDayEndPriceForOil(%s)", day));
        }
        return this.getDayEndPriceForMarket(day, Market.Code.cl);
    }

    @Override
    public DayEndPrice getDayEndPriceForStandardAndPoors500(Calendar day) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getDayEndPriceForStandardAndPoors500(%s)", day));
        }
        return this.getDayEndPriceForMarket(day, Market.Code.sp);
    }

    @Override
    public DayEndPrice getDayEndPriceForNasdaq(Calendar day) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getDayEndPriceForNasdaq(%s)", day));
        }
        return this.getDayEndPriceForMarket(day, Market.Code.nas);
    }

    @Override
    public DayEndPrice getDayEndPriceForDow(Calendar day) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getDayEndPriceForDow(%s)", day));
        }
        return this.getDayEndPriceForMarket(day, Market.Code.dow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DayEndPrice getDayEndPriceForMarket(Calendar day, Market.Code marketCode) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getDayEndPriceForMarket(%s,%s)", new Object[]{day, marketCode}));
        }
        StringBuilder sp = new StringBuilder();
        sp.append(String.format(" select ", new Object[0]));
        sp.append(String.format("\t\tdep.id, dep.created_on, dep.updated_on, m.id as market_id, dep.day, dep.price ", new Object[0]));
        sp.append(String.format(" from ", new Object[0]));
        sp.append(String.format("   day_end_prices dep ", new Object[0]));
        sp.append(String.format(" , markets m ", new Object[0]));
        sp.append(String.format(" where ", new Object[0]));
        sp.append(String.format("\t\tdep.market_ptr=m.id ", new Object[0]));
        sp.append(String.format("\t\tand ", new Object[0]));
        sp.append(String.format("\t\tdep.market_ptr=(select id from markets where code=?) ", new Object[0]));
        sp.append(String.format("\t\tand ", new Object[0]));
        sp.append(String.format("\t\tdep.day = ? ", new Object[0]));
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DayEndPrice bean = null;
        try {
            conn = this.getConnection();
            stmt = this.prepareStatement(conn, sp.toString());
            this.setString(stmt, 1, marketCode.toString());
            this.setDate(stmt, 2, day.getTime());
            rs = this.executeQuery(stmt);
            bean = this.getBean(rs);
        }
        catch (Throwable throwable) {
            this.close(conn, stmt, rs);
            throw throwable;
        }
        this.close(conn, stmt, rs);
        return bean;
    }

    private DayEndPrice getBean(ResultSet rs) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getBean()", new Object[0]));
        }
        DayEndPrice bean = null;
        try {
            if (!rs.next()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("ResultSet is empty!", new Object[0]));
                }
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("ResultSet has record so building bean", new Object[0]));
                }
                String id = rs.getString("id");
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("id=\"%s\"", id));
                }
                Calendar createdOn = Calendar.getInstance();
                createdOn.setTimeInMillis(rs.getTimestamp("created_on").getTime());
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("createdOn=\"%s\"", createdOn.toString()));
                }
                Calendar updatedOn = Calendar.getInstance();
                updatedOn.setTimeInMillis(rs.getTimestamp("updated_on").getTime());
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("updatedOn=\"%s\"", updatedOn.toString()));
                }
                String marketId = rs.getString("market_id");
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("marketId=\"%s\"", marketId));
                }
                Calendar day = Calendar.getInstance();
                day.setTimeInMillis(rs.getTimestamp("day").getTime());
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("day=\"%s\"", day.toString()));
                }
                BigDecimal price = rs.getBigDecimal("price");
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("price=\"%f\"", price.doubleValue()));
                }
                bean = new DayEndPrice(id, createdOn, updatedOn, marketId, day, price);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Returning =\"%s\" with id=\"%s\"", bean.getClass().getSimpleName(), bean.getId()));
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Problem getting DayEndPrice bean", t);
        }
        return bean;
    }

    @Override
    public void setDayEndPriceForMarket(double price, Calendar day, Market.Code marketCode) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER setDayEndPriceForMarket(%f,%s,%s)", new Object[]{price, day, marketCode}));
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Getting DB Connection", new Object[0]));
        }
        try {
            conn = this.getConnection();
            conn.setAutoCommit(false);
        }
        catch (Throwable t) {
            this.close(conn, stmt, null);
            throw new RuntimeException("Unable to get a DB connection", t);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Building DELETE String", new Object[0]));
        }
        StringBuilder sp = new StringBuilder();
        sp.append(String.format(" delete from day_end_prices ", new Object[0]));
        sp.append(String.format(" where ", new Object[0]));
        sp.append(String.format("   market_ptr=(select id from markets where code=?) ", new Object[0]));
        sp.append(String.format(" and ", new Object[0]));
        sp.append(String.format("   day=? ", new Object[0]));
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Attempting to DELETE...", new Object[0]));
        }
        try {
            stmt = this.prepareStatement(conn, sp.toString());
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("market_ptr=\"%s\"", marketCode.toString()));
            }
            this.setString(stmt, 1, marketCode.toString());
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("day=\"%s\"", day.getTime().toString()));
            }
            this.setDate(stmt, 2, day.getTime());
            int updated = this.executeUpdate(stmt);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Deleted %d rows", updated));
            }
            stmt.close();
            stmt = null;
        }
        catch (Throwable t) {
            this.close(conn, stmt, null);
            throw new RuntimeException("Problem deleting from day_end_prices ", t);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Building INSERT String", new Object[0]));
        }
        sp.setLength(0);
        sp.append(String.format(" insert into day_end_prices ", new Object[0]));
        sp.append(String.format(" (id, created_on, updated_on, market_ptr, day, price) ", new Object[0]));
        sp.append(String.format(" values ", new Object[0]));
        sp.append(String.format(" (?, ?, ?, (select id from markets where code=?), ?, ?) ", new Object[0]));
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Attempting to INSERT...", new Object[0]));
        }
        try {
            stmt = this.prepareStatement(conn, sp.toString());
            int idx = 1;
            Calendar now = this.getCalendarHandler().getNow();
            String id = this.getPrimaryKeyHandler().getPrimaryKey();
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("id=\"%s\"", id));
            }
            this.setString(stmt, idx++, id);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("created_on=\"%s\"", now.toString()));
            }
            this.setTimestamp(stmt, idx++, now);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("updated_on=\"%s\"", now.toString()));
            }
            this.setTimestamp(stmt, idx++, now);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("'market code'=\"%s\"", marketCode.toString()));
            }
            this.setString(stmt, idx++, marketCode.toString());
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("day=\"%s\"", day.toString()));
            }
            this.setDate(stmt, idx++, day.getTime());
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("price=\"%f\"", price));
            }
            this.setDouble(stmt, idx++, price);
            int updated = this.executeUpdate(stmt);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Inserted %d rows", updated));
            }
            conn.commit();
        }
        catch (Throwable duck) {
            try {
                conn.rollback();
            }
            catch (Throwable frog) {
                log.warn((Object)"Unable to rollback transaction", frog);
            }
            throw new RuntimeException(duck.getMessage(), duck);
        }
        finally {
            this.close(conn, stmt, null);
        }
    }
}

