/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.yahoo.finance.jmce.handler;

import java.text.DecimalFormat;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.ferris.yahoo.finance.jmce.bean.Dow;
import org.ferris.yahoo.finance.jmce.bean.YearEndPrice;
import org.ferris.yahoo.finance.jmce.handler.AbstractHandlerByScrape;
import org.ferris.yahoo.finance.jmce.handler.DowHandler;
import org.ferris.yahoo.finance.jmce.net.HtmlPageContents;

public class DowHandlerByScrape
extends AbstractHandlerByScrape
implements DowHandler {
    private static final Logger log = Logger.getLogger(DowHandlerByScrape.class);

    @Override
    public Dow getById(String id) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getById(%s)", id));
        }
        try {
            HtmlPageContents pageContents = this.getHtmlPageContents(id);
            String value = pageContents.getContentsOfTagByIds("yfi_rt_quote_summary_rt_top", "yfs_l10_^dji");
            String valueChange = pageContents.getContentsOfTagByIds("yfi_rt_quote_summary_rt_top", "yfs_c10_^dji");
            String percentageChange = pageContents.getContentsOfTagByIds("yfi_rt_quote_summary_rt_top", "yfs_p20_^dji");
            valueChange = String.format("%s%s", this.getMarketDown(pageContents), valueChange);
            percentageChange = String.format("%s%s", this.getMarketDown(pageContents), percentageChange);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Create Dow bean and set data", new Object[0]));
            }
            Dow dow = new Dow();
            dow.setPriceAtEndOfDay(DecimalFormat.getNumberInstance().parse(value).doubleValue());
            dow.setPriceChangeSinceYesterday(valueChange);
            dow.setPercentageChangeSinceYesterday(percentageChange);
            YearEndPrice yearEndPrice = this.getYearEndPriceHandler().getYearEndPriceForDow(Calendar.getInstance().get(1) - 1);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Year end price \"%s\"", String.valueOf(yearEndPrice)));
            }
            if (yearEndPrice != null) {
                dow.setPriceAtEndOfLastYear(yearEndPrice.getPrice().doubleValue());
            }
            return dow;
        }
        catch (Throwable t) {
            log.fatal((Object)"Couldn't get dow by id", t);
            throw new RuntimeException(t);
        }
    }
}

