/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.yahoo.finance.jmce.handler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ferris.yahoo.finance.jmce.bean.EmailAddress;
import org.ferris.yahoo.finance.jmce.handler.AbstractHandlerBySql;
import org.ferris.yahoo.finance.jmce.handler.EmailAddressHandler;

public class EmailAddressHandlerBySql
extends AbstractHandlerBySql
implements EmailAddressHandler {
    private static final Logger log = Logger.getLogger(EmailAddressHandlerBySql.class);

    @Override
    public EmailAddress getAdmin() {
        EmailAddress.Type theType;
        List<EmailAddress> list;
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getAdmin()", new Object[0]));
        }
        if ((list = this.getEmailAddresses(theType = EmailAddress.Type.admin)).isEmpty()) {
            throw new RuntimeException(String.format("An \"%s\" address cannot be found in the database", new Object[]{theType}));
        }
        if (list.size() > 1) {
            throw new RuntimeException(String.format("Multiple type=\"%s\" addresses found in the database", new Object[]{theType}));
        }
        return list.get(0);
    }

    @Override
    public List<EmailAddress> getCc() {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getCc()", new Object[0]));
        }
        EmailAddress.Type theType = EmailAddress.Type.cc;
        List<EmailAddress> list = this.getEmailAddresses(theType);
        return list;
    }

    @Override
    public List<EmailAddress> getBcc() {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getBcc()", new Object[0]));
        }
        EmailAddress.Type theType = EmailAddress.Type.bcc;
        List<EmailAddress> list = this.getEmailAddresses(theType);
        return list;
    }

    @Override
    public List<EmailAddress> getTo() {
        EmailAddress.Type theType;
        List<EmailAddress> list;
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getTo()", new Object[0]));
        }
        if ((list = this.getEmailAddresses(theType = EmailAddress.Type.to)).isEmpty()) {
            throw new RuntimeException(String.format("No type=\"%s\" addresses can be found in the database", new Object[]{theType}));
        }
        return list;
    }

    @Override
    public EmailAddress getFrom() {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getFrom()", new Object[0]));
        }
        EmailAddress.Type theType = null;
        theType = EmailAddress.Type.from;
        List<EmailAddress> list = this.getEmailAddresses(theType);
        if (list.isEmpty()) {
            theType = EmailAddress.Type.reply;
            list = this.getEmailAddresses(theType);
        }
        if (list.isEmpty()) {
            throw new RuntimeException(String.format("A \"from\" address cannot be found in the database", new Object[0]));
        }
        if (list.size() > 1) {
            throw new RuntimeException(String.format("Multiple type=\"%s\" addresses found in the database", new Object[]{theType}));
        }
        return list.get(0);
    }

    @Override
    public EmailAddress getReplyTo() {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getReplyTo()", new Object[0]));
        }
        EmailAddress.Type theType = null;
        theType = EmailAddress.Type.reply;
        List<EmailAddress> list = this.getEmailAddresses(theType);
        if (list.isEmpty()) {
            theType = EmailAddress.Type.from;
            list = this.getEmailAddresses(theType);
        }
        if (list.isEmpty()) {
            throw new RuntimeException(String.format("A \"reply to\" address cannot be found in the database", new Object[0]));
        }
        if (list.size() > 1) {
            throw new RuntimeException(String.format("Multiple type=\"%s\" addresses found in the database", new Object[]{theType}));
        }
        return list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<EmailAddress> getEmailAddresses(EmailAddress.Type type) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getEmailAddresses(%s)", type.toString()));
        }
        StringBuilder sp = new StringBuilder();
        sp.append(String.format(" select ", new Object[0]));
        sp.append(String.format("\t\tea.id, ea.created_on, ea.updated_on, ea.type, ea.address, ea.name ", new Object[0]));
        sp.append(String.format(" from ", new Object[0]));
        sp.append(String.format("   email_addresses ea ", new Object[0]));
        sp.append(String.format(" where ", new Object[0]));
        sp.append(String.format("       ea.type=? ", new Object[0]));
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        List<EmailAddress> beans = null;
        try {
            conn = this.getConnection();
            stmt = this.prepareStatement(conn, sp.toString());
            this.setString(stmt, 1, type.toString());
            rs = this.executeQuery(stmt);
            beans = this.getBeans(rs);
        }
        catch (Throwable throwable) {
            this.close(conn, stmt, rs);
            throw throwable;
        }
        this.close(conn, stmt, rs);
        return beans;
    }

    private List<EmailAddress> getBeans(ResultSet rs) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Enter getBeans(..)", new Object[0]));
        }
        LinkedList<EmailAddress> beans = new LinkedList<EmailAddress>();
        try {
            while (rs.next()) {
                beans.add(this.getBean(rs));
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Problem getting EmailAddress bean", t);
        }
        return beans;
    }

    private EmailAddress getBean(ResultSet rs) throws SQLException {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Enter getBean(..)", new Object[0]));
        }
        EmailAddress bean = null;
        String id = rs.getString("id");
        Calendar createdOn = Calendar.getInstance();
        createdOn.setTimeInMillis(rs.getTimestamp("created_on").getTime());
        Calendar updatedOn = Calendar.getInstance();
        createdOn.setTimeInMillis(rs.getTimestamp("updated_on").getTime());
        EmailAddress.Type type = EmailAddress.Type.valueOf(rs.getString("type"));
        String address = rs.getString("address");
        String name = rs.getString("name");
        bean = new EmailAddress(id, createdOn, updatedOn, type, address, name);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Built bean=\"%s\" with id=\"%s\"", bean.getClass().getSimpleName(), bean.getId()));
        }
        return bean;
    }
}

