/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.yahoo.finance.jmce.handler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;
import org.ferris.yahoo.finance.jmce.bean.FuturesExpirations;
import org.ferris.yahoo.finance.jmce.bean.Market;
import org.ferris.yahoo.finance.jmce.handler.AbstractHandlerBySql;
import org.ferris.yahoo.finance.jmce.handler.CalendarHandler;
import org.ferris.yahoo.finance.jmce.handler.FuturesExpirationsHandler;

public class FuturesExpirationsHandlerBySql
extends AbstractHandlerBySql
implements FuturesExpirationsHandler {
    private static final Logger log = Logger.getLogger(FuturesExpirationsHandlerBySql.class);
    private CalendarHandler calendarHandler;

    @Override
    public FuturesExpirations getForCrudeOil() {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getForCrudeOil()", new Object[0]));
        }
        Date now = this.getNow();
        Market.Code tickerSymbol = Market.Code.cl;
        return this.getFuturesExpirations(now, tickerSymbol);
    }

    public Date getNow() {
        return this.getCalendarHandler().getNow().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FuturesExpirations getFuturesExpirations(Date now, Market.Code tickerSymbol) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("ENTER getFuturesExpirations(%s,%s)", new Object[]{String.valueOf(now), tickerSymbol}));
        }
        StringBuilder sp = new StringBuilder();
        sp.append(String.format(" select ", new Object[0]));
        sp.append(String.format("\t\tfe.id, fe.created_on, fe.updated_on, m.code as ticker_symbol, contract_description, contract_month, contract_year, last_trading_day ", new Object[0]));
        sp.append(String.format(" from ", new Object[0]));
        sp.append(String.format("   futures_expirations fe ", new Object[0]));
        sp.append(String.format("   , markets           m ", new Object[0]));
        sp.append(String.format(" where ", new Object[0]));
        sp.append(String.format("       fe.market_ptr=m.id ", new Object[0]));
        sp.append(String.format("\t\tand ", new Object[0]));
        sp.append(String.format("\t\tfe.market_ptr = (select id from markets where code = ?) ", new Object[0]));
        sp.append(String.format("\t\tand ", new Object[0]));
        sp.append(String.format("\t\tfe.last_trading_day >= ? ", new Object[0]));
        sp.append(String.format(" order by ", new Object[0]));
        sp.append(String.format("\t\tfe.last_trading_day asc ", new Object[0]));
        sp.append(String.format(" limit 1 ", new Object[0]));
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        FuturesExpirations bean = null;
        try {
            conn = this.getConnection();
            stmt = this.prepareStatement(conn, sp.toString());
            this.setString(stmt, 1, tickerSymbol.toString());
            this.setDate(stmt, 2, now);
            rs = this.executeQuery(stmt);
            bean = this.getBean(rs);
        }
        catch (Throwable throwable) {
            this.close(conn, stmt, rs);
            throw throwable;
        }
        this.close(conn, stmt, rs);
        return bean;
    }

    private FuturesExpirations getBean(ResultSet rs) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Enter getBean(..)", new Object[0]));
        }
        FuturesExpirations bean = null;
        try {
            if (!rs.next()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("ResultSet is empty!", new Object[0]));
                }
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("ResultSet has records, building bean", new Object[0]));
                }
                String id = rs.getString("id");
                Calendar createdOn = Calendar.getInstance();
                createdOn.setTimeInMillis(rs.getTimestamp("created_on").getTime());
                Calendar updatedOn = Calendar.getInstance();
                createdOn.setTimeInMillis(rs.getTimestamp("updated_on").getTime());
                String tickerSymbol = rs.getString("ticker_symbol");
                String contractDescription = rs.getString("contract_description");
                char contractMonth = rs.getString("contract_month").charAt(0);
                int contractYear = rs.getInt("contract_year");
                java.sql.Date lastTradingDay = rs.getDate("last_trading_day");
                bean = new FuturesExpirations(id, createdOn, updatedOn, tickerSymbol, contractDescription, contractMonth, contractYear, lastTradingDay);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Built bean=\"%s\" with id=\"%s\"", bean.getClass().getSimpleName(), bean.getId()));
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Problem getting FuturesExpirations bean", t);
        }
        return bean;
    }

    public CalendarHandler getCalendarHandler() {
        return this.calendarHandler;
    }

    public void setCalendarHandler(CalendarHandler calendarHandler) {
        this.calendarHandler = calendarHandler;
    }
}

